/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricSignatureFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public class DSASignatureFormatter
extends AsymmetricSignatureFormatter {
    private DSA a;

    public DSASignatureFormatter() {
    }

    public DSASignatureFormatter(AsymmetricAlgorithm key) {
        this.setKey(key);
    }

    @Override
    public byte[] createSignature(byte[] rgbHash) {
        if (this.a == null) {
            throw new CryptographicUnexpectedOperationException(n.a("missing key"));
        }
        return this.a.createSignature(rgbHash);
    }

    @Override
    public void setHashAlgorithm(String strName) {
        if (strName == null) {
            throw new ArgumentNullException("strName");
        }
        try {
            SHA1.create(strName);
        }
        catch (ClassCastException classCastException) {
            throw new CryptographicUnexpectedOperationException(n.a("DSA requires SHA1"));
        }
    }

    @Override
    public void setKey(AsymmetricAlgorithm key) {
        if (key == null) {
            throw new ArgumentNullException("key");
        }
        this.a = (DSA)key;
    }
}

