/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.Pkcs9AttributeObject;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.lang.Operators;

public final class Pkcs9DocumentName
extends Pkcs9AttributeObject {
    public static final String oid = "1.3.6.1.4.1.311.88.2.1";
    public static final String friendlyName = null;
    private String a;

    public Pkcs9DocumentName() {
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
    }

    public Pkcs9DocumentName(String documentName) {
        if (documentName == null) {
            throw new ArgumentNullException("documentName");
        }
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.a = documentName;
        this.setRawData(this.encode());
    }

    public Pkcs9DocumentName(byte[] encodedDocumentName) {
        if (encodedDocumentName == null) {
            throw new ArgumentNullException("encodedDocumentName");
        }
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.setRawData(encodedDocumentName);
        this.decode(encodedDocumentName);
    }

    public String getDocumentName() {
        return this.a;
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        super.copyFrom(asnEncodedData);
        this.decode(this.getRawData());
    }

    public void decode(byte[] attribute) {
        int n2;
        if (Operators.castToInt32(attribute[0], 6) != 4) {
            return;
        }
        ASN1 aSN1 = new ASN1(attribute);
        byte[] byArray = aSN1.getValue();
        if (Operators.castToInt32(byArray[(n2 = byArray.length) - 2], 6) == 0) {
            n2 -= 2;
        }
        this.a = Encoding.getUnicode().getString(byArray, 0, n2);
    }

    public byte[] encode() {
        ASN1 aSN1 = new ASN1(4, Encoding.getUnicode().getBytes(StringExtensions.concat(this.a, Operators.boxing(Character.valueOf('\u0000')))));
        return aSN1.getBytes();
    }
}

