/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;

public class X509Extension
extends AsnEncodedData {
    private boolean a;

    protected X509Extension() {
    }

    public X509Extension(AsnEncodedData encodedExtension, boolean critical) {
        if (encodedExtension == null) {
            throw new NullReferenceException();
        }
        if (encodedExtension.getOid() == null) {
            throw new ArgumentNullException("encodedExtension.Oid");
        }
        this.setOid(encodedExtension.getOid());
        this.setRawData(encodedExtension.getRawData());
        this.a = critical;
    }

    public X509Extension(Oid oid, byte[] rawData, boolean critical) {
        if (oid == null) {
            throw new ArgumentNullException("oid");
        }
        this.setOid(oid);
        this.setRawData(rawData);
        this.a = critical;
    }

    public X509Extension(String oid, byte[] rawData, boolean critical) {
        super(oid, rawData);
        this.a = critical;
    }

    public boolean getCritical() {
        return this.a;
    }

    public void setCritical(boolean value) {
        this.a = value;
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("encodedData");
        }
        X509Extension x509Extension = Operators.as(asnEncodedData, X509Extension.class);
        if (x509Extension == null) {
            throw new ArgumentException(StringExtensions.format("Expected a X509Extension instance.", new Object[0]));
        }
        super.copyFrom(asnEncodedData);
        this.a = x509Extension.getCritical();
    }

    public String formatUnkownData(byte[] data) {
        if (data == null || data.length == 0) {
            return StringExtensions.Empty;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (int i2 = 0; i2 < data.length; ++i2) {
            msStringBuilder2.append(ByteExtensions.toString(data[i2], "X2"));
        }
        return msStringBuilder2.toString();
    }
}

