/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Principal;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Principal.IdentityNotMappedException;
import com.aspose.html.internal.ms.System.Security.Principal.IdentityReference;
import com.aspose.html.internal.ms.System.Security.Principal.SecurityIdentifier;
import com.aspose.html.internal.ms.System.Security.Principal.WellKnownAccount;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Operators;

public final class NTAccount
extends IdentityReference {
    private String a;

    public NTAccount(String name) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (name.length() == 0) {
            throw new ArgumentException("Empty", "name");
        }
        this.a = name;
    }

    public NTAccount(String domainName, String accountName) {
        if (accountName == null) {
            throw new ArgumentNullException("accountName");
        }
        if (accountName.length() == 0) {
            throw new ArgumentException("Empty", "accountName");
        }
        this.a = domainName == null ? accountName : StringExtensions.concat(domainName, "\\", accountName);
    }

    @Override
    public String getValue() {
        return this.a;
    }

    @Override
    public boolean equals(Object o2) {
        NTAccount nTAccount = Operators.as(o2, NTAccount.class);
        if (nTAccount == null) {
            return false;
        }
        return StringExtensions.equals(nTAccount.getValue(), this.getValue());
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public boolean isValidTargetType(Type targetType) {
        if (targetType == Operators.typeOf(NTAccount.class)) {
            return true;
        }
        return targetType == Operators.typeOf(SecurityIdentifier.class);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public IdentityReference translate(Type targetType) {
        if (targetType == Operators.typeOf(NTAccount.class)) {
            return this;
        }
        if (targetType == Operators.typeOf(SecurityIdentifier.class)) {
            WellKnownAccount wellKnownAccount = WellKnownAccount.f(this.getValue());
            if (wellKnownAccount == null || wellKnownAccount.c() == null) {
                throw new IdentityNotMappedException("Cannot map account name: " + this.getValue());
            }
            return new SecurityIdentifier(wellKnownAccount.c());
        }
        throw new ArgumentException("Unknown type", "targetType");
    }

    public static boolean op_Equality(NTAccount left, NTAccount right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        return StringExtensions.equals(left.getValue(), right.getValue());
    }

    public static boolean op_Inequality(NTAccount left, NTAccount right) {
        if (left == null) {
            return right != null;
        }
        if (right == null) {
            return true;
        }
        return !StringExtensions.equals(left.getValue(), right.getValue());
    }
}

