/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security;

import com.aspose.html.internal.ms.System.AppDomain;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Reflection.Assembly;
import com.aspose.html.internal.ms.System.Reflection.MethodInfo;
import com.aspose.html.internal.ms.System.Security.PermissionSet;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Struct;

public class SecurityFrame
extends Struct<SecurityFrame> {
    private AppDomain b = AppDomain.getCurrentDomain();
    private MethodInfo c;
    private PermissionSet d;
    private PermissionSet e;
    private PermissionSet f;

    public SecurityFrame() {
        this.c = null;
        this.d = new PermissionSet();
        this.e = new PermissionSet();
        this.f = new PermissionSet();
    }

    public SecurityFrame(StackTraceElement element) {
        Type type = Type.getType(element.getClassName());
        this.c = type.getMethod(element.getMethodName());
        this.d = new PermissionSet();
        this.e = new PermissionSet();
        this.f = new PermissionSet();
    }

    public Assembly getAssembly() {
        return this.c.getReflectedType().getAssembly();
    }

    public AppDomain getDomain() {
        return this.b;
    }

    public MethodInfo getMethod() {
        return this.c;
    }

    public PermissionSet getAssert() {
        return this.d;
    }

    public PermissionSet getDeny() {
        return this.e;
    }

    public PermissionSet getPermitOnly() {
        return this.f;
    }

    public boolean hasStackModifiers() {
        return this.d != null || this.e != null || this.f != null;
    }

    public boolean equals(SecurityFrame sf) {
        if (!ObjectExtensions.referenceEquals(this.b, sf.getDomain())) {
            return false;
        }
        if (!StringExtensions.equals(this.getAssembly().toString(), sf.getAssembly().toString())) {
            return false;
        }
        if (!StringExtensions.equals(this.getMethod().toString(), sf.getMethod().toString())) {
            return false;
        }
        if (this.d != null && !this.d.equals(sf.getAssert())) {
            return false;
        }
        if (this.e != null && !this.e.equals(sf.getDeny())) {
            return false;
        }
        return this.f == null || this.f.equals(sf.getPermitOnly());
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.appendFormat("Frame: {0}{1}", this.c, Environment.NewLine);
        msStringBuilder2.appendFormat("\tAppDomain: {0}{1}", this.getDomain(), Environment.NewLine);
        msStringBuilder2.appendFormat("\tAssembly: {0}{1}", this.getAssembly(), Environment.NewLine);
        if (this.d != null) {
            msStringBuilder2.appendFormat("\tAssert: {0}{1}", this.d, Environment.NewLine);
        }
        if (this.e != null) {
            msStringBuilder2.appendFormat("\tDeny: {0}{1}", this.e, Environment.NewLine);
        }
        if (this.f != null) {
            msStringBuilder2.appendFormat("\tPermitOnly: {0}{1}", this.f, Environment.NewLine);
        }
        return msStringBuilder2.toString();
    }

    public static ArrayList getStack(int skipFrames) {
        StackTraceElement stackTraceElement;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < stackTraceElementArray.length && (stackTraceElement = stackTraceElementArray[i2]) != null; ++i2) {
            arrayList.addItem(new SecurityFrame(stackTraceElement));
        }
        return arrayList;
    }

    @Override
    public void CloneTo(SecurityFrame that) {
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
        that.f = this.f;
    }

    @Override
    public SecurityFrame Clone() {
        SecurityFrame securityFrame = new SecurityFrame();
        this.CloneTo(securityFrame);
        return securityFrame;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(SecurityFrame securityFrame) {
        return ObjectExtensions.equals(securityFrame.b, this.b) && ObjectExtensions.equals(securityFrame.c, this.c) && ObjectExtensions.equals(securityFrame.d, this.d) && ObjectExtensions.equals(securityFrame.e, this.e) && ObjectExtensions.equals(securityFrame.f, this.f);
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof SecurityFrame)) {
            return false;
        }
        return this.a((SecurityFrame)obj);
    }

    public static boolean equals(SecurityFrame obj1, SecurityFrame obj2) {
        return obj1.equals(obj2);
    }

    public int hashCode() {
        int n2 = this.b != null ? this.b.hashCode() : 0;
        n2 = 31 * n2 + (this.c != null ? this.c.hashCode() : 0);
        n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
        n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
        n2 = 31 * n2 + (this.f != null ? this.f.hashCode() : 0);
        return n2;
    }
}

