/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.ICustomFormatter;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IFormattable;
import com.aspose.html.internal.ms.System.IndexOutOfRangeException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.lang.Extensions;
import com.aspose.html.internal.ms.lang.Operators;

@Extensions
public final class StringExtensions {
    public static String Empty = "";
    static final char[] a = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' ', '\u0085', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u3000', '\ufeff'};

    private StringExtensions() {
    }

    public static String newString(String str) {
        throw new NotImplementedException();
    }

    public static String newString(Object value) {
        if (value == null) {
            return Empty;
        }
        if (value.getClass() == Byte.TYPE) {
            return StringExtensions.newString((Byte)value);
        }
        return new String(value.toString());
    }

    public static String newString(byte value) {
        return new String(new byte[]{value});
    }

    public static String newString(char[] value, int startIndex, int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if ((long)startIndex + (long)length > (long)value.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return new String(value, startIndex, length);
    }

    public static String newString(char[] chars) {
        if (chars == null) {
            return Empty;
        }
        return new String(chars);
    }

    public static String newString(byte aByte, int startIndex, int length) {
        byte[] byArray = new byte[]{aByte};
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (startIndex + length >= byArray.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return new String(byArray, startIndex, length);
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static String newString(Byte b2, int startIndex, int length, Encoding encoding) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (b2 == null) {
            if (length > 0 || startIndex > 0) {
                throw new ArgumentNullException("value");
            }
            if (encoding == null) {
                throw new ArgumentNullException("value");
            }
            return Empty;
        }
        byte[] byArray = new byte[]{b2};
        if (startIndex + length >= byArray.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return new String(byArray, startIndex, length);
    }

    public static String newString(char c2, int count) {
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count");
        }
        if (count == 0) {
            return "";
        }
        char[] cArray = new char[count];
        for (int i2 = 0; i2 < count; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public static String remove(String base, int startIndex, int count) {
        if (base == null) {
            throw new NullReferenceException();
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Cannot be negative.");
        }
        if (startIndex > base.length() - count) {
            throw new ArgumentOutOfRangeException("count", "startIndex + count > this.length");
        }
        return new StringBuilder(base).delete(startIndex, startIndex + count).toString();
    }

    public static String remove(String base, int startIndex) {
        if (base == null) {
            throw new NullReferenceException();
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "StartIndex can not be less than zero");
        }
        if (startIndex >= base.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "StartIndex must be less than the length of the string");
        }
        return StringExtensions.remove(base, startIndex, base.length() - startIndex);
    }

    public static String replace(String basestr, char ch2, char toCh) {
        if (basestr == null) {
            throw new NullReferenceException();
        }
        return basestr.replace(ch2, toCh);
    }

    public static String replace(String basestr, String oldValue, String newValue) {
        if (basestr == null) {
            throw new NullReferenceException();
        }
        if (oldValue == null) {
            throw new ArgumentNullException("oldValue");
        }
        if (oldValue.length() == 0) {
            throw new ArgumentException("oldValue is the empty string.");
        }
        if (basestr.length() == 0) {
            return basestr;
        }
        if (newValue == null) {
            newValue = Empty;
        }
        return basestr.replace(oldValue, newValue);
    }

    public static String format(String format, Object ... args) {
        if (format == null) {
            throw new ArgumentNullException("format");
        }
        if (args == null) {
            throw new ArgumentNullException("args");
        }
        return StringExtensions.format((IFormatProvider)null, format, args);
    }

    public static String format(IFormatProvider provider, String format, Object ... args) {
        msStringBuilder msStringBuilder2 = StringExtensions.formatHelper(null, provider, format, args);
        return msStringBuilder2.toString();
    }

    public static msStringBuilder formatHelper(msStringBuilder result, IFormatProvider provider, String format, Object ... args) {
        int n2;
        int n3;
        if (provider == null) {
            provider = NumberFormatInfo.getInvariantInfo();
        }
        if (format == null) {
            throw new ArgumentNullException("format");
        }
        if (args == null) {
            throw new ArgumentNullException("args");
        }
        if (result == null) {
            n3 = 0;
            for (n2 = 0; n2 < args.length; ++n2) {
                String string;
                Object object = args[n2];
                String string2 = string = object instanceof String ? (String)object : null;
                if (string == null) break;
                n3 += string.length();
            }
            result = n2 == args.length ? new msStringBuilder(n3 + format.length()) : new msStringBuilder();
        }
        n3 = n2 = 0;
        while (n2 < format.length()) {
            char c2;
            if ((c2 = format.charAt(n2++)) == '{') {
                String string;
                result.append(format, n3, n2 - n3 - 1);
                if (format.charAt(n2) == '{') {
                    n3 = n2++;
                    continue;
                }
                int n4 = 0;
                int n5 = 0;
                boolean bl2 = false;
                String string3 = null;
                int[] nArray = new int[]{n2};
                int[] nArray2 = new int[]{0};
                int[] nArray3 = new int[]{0};
                boolean[] blArray = new boolean[]{false};
                String[] stringArray = new String[]{string3};
                StringExtensions.a(format, nArray, nArray2, nArray3, blArray, stringArray);
                n2 = nArray[0];
                n4 = nArray2[0];
                n5 = nArray3[0];
                bl2 = blArray[0];
                string3 = stringArray[0];
                if (n4 >= args.length) {
                    throw new FormatException("Index (zero based) must be greater than or equal to zero and less than the size of the argument list.");
                }
                Object object = args[n4];
                ICustomFormatter iCustomFormatter = null;
                if (provider != null) {
                    iCustomFormatter = (ICustomFormatter)provider.getFormat(Operators.typeOf(ICustomFormatter.class));
                }
                if ((string = object == null ? Empty : (iCustomFormatter != null ? iCustomFormatter.format(string3, object, provider) : (StringExtensions.a(object) ? k.a(object, string3, provider) : (object instanceof IFormattable ? ((IFormattable)object).toString(string3, provider) : object.toString())))) == null) {
                    string = Empty;
                }
                if (n5 > string.length()) {
                    char c3 = ' ';
                    int n6 = n5 - string.length();
                    if (bl2) {
                        result.append(string);
                        result.append(c3, n6);
                    } else {
                        result.append(c3, n6);
                        result.append(string);
                    }
                } else {
                    result.append(string);
                }
                n3 = n2;
                continue;
            }
            if (c2 == '}' && n2 < format.length() && format.charAt(n2) == '}') {
                result.append(format, n3, n2 - n3 - 1);
                n3 = n2++;
                continue;
            }
            if (c2 != '}') continue;
            throw new FormatException("Input string was not in a correct format.");
        }
        if (n3 < format.length()) {
            result.append(format, n3, format.length() - n3);
        }
        return result;
    }

    private static void a(String string, int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray, String[] stringArray) {
        block14: {
            block13: {
                int n2;
                int n3 = string.length();
                nArray2[0] = StringExtensions.a(string, nArray);
                if (nArray2[0] < 0) {
                    throw new FormatException("Input string was not in a correct format.");
                }
                if (nArray[0] < n3 && string.charAt(nArray[0]) == ',') {
                    nArray[0] = nArray[0] + 1;
                    while (nArray[0] < n3 && Char.isWhiteSpace(string.charAt(nArray[0]))) {
                        nArray[0] = nArray[0] + 1;
                    }
                    n2 = nArray[0];
                    stringArray[0] = StringExtensions.substring(string, n2, nArray[0] - n2);
                    boolean bl2 = blArray[0] = nArray[0] < n3 && string.charAt(nArray[0]) == '-';
                    if (blArray[0]) {
                        nArray[0] = nArray[0] + 1;
                    }
                    nArray3[0] = StringExtensions.a(string, nArray);
                    if (nArray3[0] < 0) {
                        throw new FormatException("Input string was not in a correct format.");
                    }
                } else {
                    nArray3[0] = 0;
                    blArray[0] = false;
                    stringArray[0] = Empty;
                }
                if (nArray[0] < n3 && string.charAt(nArray[0]) == ':') {
                    n2 = nArray[0] = nArray[0] + 1;
                    while (nArray[0] < n3 && string.charAt(nArray[0]) != '}') {
                        nArray[0] = nArray[0] + 1;
                    }
                    stringArray[0] = StringExtensions.plusEqOperator(stringArray[0], StringExtensions.substring(string, n2, nArray[0] - n2));
                } else {
                    stringArray[0] = null;
                }
                if (nArray[0] >= n3) break block13;
                int n4 = nArray[0];
                nArray[0] = n4 + 1;
                if (string.charAt(n4) == '}') break block14;
            }
            throw new FormatException("Input string was not in a correct format.");
        }
    }

    private static int a(String string, int[] nArray) {
        char c2;
        int n2;
        int n3 = 0;
        int n4 = string.length();
        for (n2 = nArray[0]; n2 < n4 && (c2 = string.charAt(n2)) >= '0' && '9' >= c2; ++n2) {
            n3 = n3 * 10 + c2 - 48;
        }
        if (n2 == nArray[0] || n2 == n4) {
            return -1;
        }
        nArray[0] = n2;
        return n3;
    }

    public static void copyTo(String base, int sourceIndex, char[] destination, int destinationIndex, int count) {
        if (base == null) {
            throw new NullReferenceException();
        }
        if (destination == null) {
            throw new ArgumentNullException("destination");
        }
        if (sourceIndex < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Cannot be negative");
        }
        if (destinationIndex < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Cannot be negative.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Cannot be negative.");
        }
        if (sourceIndex > base.length() - count) {
            throw new ArgumentOutOfRangeException("sourceIndex", "sourceIndex + count > Length");
        }
        if (destinationIndex > destination.length - count) {
            throw new ArgumentOutOfRangeException("destinationIndex", "destinationIndex + count > destination.Length");
        }
        base.getChars(sourceIndex, sourceIndex + count, destination, destinationIndex);
    }

    public static String insert(String base, int startIndex, String value) {
        if (base == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (startIndex < 0 || startIndex > base.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative and must be less than or equal to length of string.");
        }
        if (value.length() == 0) {
            return base;
        }
        if (base.length() == 0) {
            return value;
        }
        return new StringBuilder(base).insert(startIndex, value).toString();
    }

    public static int indexOfAny(String thisStr, char[] toFind) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        if (toFind == null) {
            throw new ArgumentNullException();
        }
        if (thisStr.length() == 0) {
            return -1;
        }
        return StringExtensions.indexOfAny(thisStr, toFind, 0);
    }

    public static int indexOfAny(String targetStr, char[] toFind, int startIndex) {
        if (targetStr == null) {
            throw new NullReferenceException();
        }
        if (toFind == null) {
            throw new ArgumentNullException();
        }
        if (startIndex < 0 || startIndex > targetStr.length()) {
            throw new ArgumentOutOfRangeException();
        }
        if (StringExtensions.isNullOrEmpty(targetStr) || toFind == null || toFind.length == 0 || startIndex > targetStr.length()) {
            return -1;
        }
        return StringExtensions.indexOfAny(targetStr, toFind, startIndex, targetStr.length() - startIndex);
    }

    public static int indexOfAny(String targetStr, char[] anyOf, int startIndex, int count) {
        if (targetStr == null) {
            throw new NullReferenceException();
        }
        if (anyOf == null) {
            throw new ArgumentNullException();
        }
        if (startIndex < 0 || startIndex > targetStr.length()) {
            throw new ArgumentOutOfRangeException();
        }
        if (count < 0 || startIndex > targetStr.length() - count) {
            throw new ArgumentOutOfRangeException("count", "Count cannot be negative, and startIndex + count must be less than length of the string.");
        }
        int n2 = startIndex + count;
        int n3 = n2 - 1;
        int n4 = anyOf.length;
        int n5 = n4 - 1;
        for (int i2 = startIndex; i2 < n2; ++i2) {
            char c2 = targetStr.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (anyOf[i3] != c2) continue;
                if (i2 < n3 && i3 < n5 && Character.isHighSurrogate(c2)) {
                    if (anyOf[i3 + 1] != targetStr.charAt(i2 + 1)) continue;
                    return i2;
                }
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String targetStr, char[] toFind) {
        if (targetStr == null) {
            throw new NullReferenceException();
        }
        if (toFind == null) {
            throw new ArgumentNullException();
        }
        if (targetStr.length() == 0) {
            return -1;
        }
        for (int i2 = targetStr.length() - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < toFind.length; ++i3) {
                if (targetStr.charAt(i2) != toFind[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String targetStr, char[] anyOf, int startIndex) {
        if (targetStr == null) {
            throw new NullReferenceException();
        }
        if (anyOf == null) {
            throw new ArgumentNullException();
        }
        if (targetStr.length() == 0) {
            return -1;
        }
        if (startIndex < 0 || startIndex >= targetStr.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative, and should be less than length of string.");
        }
        if (targetStr.length() == 0) {
            return -1;
        }
        if (startIndex > targetStr.length() - 1) {
            startIndex = targetStr.length() - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < anyOf.length; ++i3) {
                if (targetStr.charAt(i2) != anyOf[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String targetStr, char[] toFind, int startIndex, int count) {
        if (targetStr == null) {
            throw new NullReferenceException();
        }
        if (toFind == null) {
            throw new ArgumentNullException();
        }
        if (targetStr.length() == 0) {
            return -1;
        }
        if (startIndex < 0 || startIndex >= targetStr.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0 || > this.Length");
        }
        if (count < 0 || count > targetStr.length()) {
            throw new ArgumentOutOfRangeException("count", "< 0 || > this.Length");
        }
        if (startIndex - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("startIndex - count + 1 < 0");
        }
        if (targetStr.length() == 0) {
            return -1;
        }
        if (startIndex > targetStr.length() - 1) {
            startIndex = targetStr.length() - 1;
        }
        for (int i2 = startIndex; i2 >= 0 && i2 > startIndex - count; --i2) {
            for (int i3 = 0; i3 < toFind.length; ++i3) {
                if (targetStr.charAt(i2) != toFind[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static String trim(String str) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.trim(str, a);
    }

    public static String trim(String str, char ... trimChars) {
        int n2;
        if (str == null) {
            throw new NullReferenceException();
        }
        if (trimChars == null || trimChars.length == 0) {
            return StringExtensions.trim(str);
        }
        if (str.length() == 0) {
            return Empty;
        }
        int n3 = str.length();
        for (n2 = 0; n2 < n3 && StringExtensions.a(trimChars, str.charAt(n2)); ++n2) {
        }
        while (n2 < n3 && StringExtensions.a(trimChars, str.charAt(n3 - 1))) {
            --n3;
        }
        return n2 > 0 || n3 < str.length() ? str.substring(n2, n3) : str;
    }

    public static String trimStart(String str) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.trimStart(str, a);
    }

    public static String trimStart(String str, char ... trimChars) {
        int n2;
        if (str == null) {
            throw new NullReferenceException();
        }
        if (str.length() == 0) {
            return Empty;
        }
        int n3 = str.length();
        if (trimChars == null || trimChars.length == 0) {
            n2 = StringExtensions.a(str, 0, str.length(), 1);
        } else {
            for (n2 = 0; n2 < n3 && StringExtensions.a(trimChars, str.charAt(n2)); ++n2) {
            }
        }
        return n2 > 0 ? str.substring(n2) : str;
    }

    public static String trimEnd(String str, char ... trimChars) {
        int n2;
        if (str == null) {
            throw new NullReferenceException();
        }
        if (str.length() == 0) {
            return Empty;
        }
        int n3 = 0;
        if (trimChars == null || trimChars.length == 0) {
            n2 = StringExtensions.a(str, str.length() - 1, -1, -1);
            ++n2;
        } else {
            for (n2 = str.length(); n3 < n2 && StringExtensions.a(trimChars, str.charAt(n2 - 1)); --n2) {
            }
        }
        return n2 < str.length() ? str.substring(n3, n2) : str;
    }

    private static int a(String string, int n2, int n3, int n4) {
        while (n2 != n3) {
            char c2 = string.charAt(n2);
            if (c2 < '\u0085' ? c2 != ' ' && (c2 < '\t' || c2 > '\r') : c2 != '\u00a0' && c2 != '\ufeff' && c2 != '\u3000' && c2 != '\u0085' && c2 != '\u1680' && c2 != '\u2028' && c2 != '\u2029' && (c2 < '\u2000' || c2 > '\u200b')) {
                return n2;
            }
            n2 += n4;
        }
        return n2;
    }

    private static boolean a(char[] cArray, char c2) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != c2) continue;
            return true;
        }
        return false;
    }

    public static String join(String divider, String[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (divider == null) {
            divider = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (String string : value) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(divider);
            }
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String join(String separator, String[] value, int startIndex, int count) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (startIndex > value.length - count) {
            throw new ArgumentOutOfRangeException("startIndex", "startIndex + count > value.length");
        }
        if (startIndex == value.length) {
            return Empty;
        }
        if (separator == null) {
            separator = Empty;
        }
        String string = Empty;
        boolean bl2 = true;
        for (int i2 = startIndex; i2 < startIndex + count; ++i2) {
            String string2 = value[i2];
            if (string2 == null) {
                string2 = Empty;
            }
            if (bl2) {
                bl2 = false;
                string = StringExtensions.copy(value[i2]);
                continue;
            }
            string = StringExtensions.concat(string, separator, string2);
        }
        return string;
    }

    public static String[] split(String str, char separator) {
        if (str == null) {
            throw new NullReferenceException();
        }
        int[] nArray = new int[str.length()];
        int n2 = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (str.charAt(i2) != separator) continue;
            nArray[n2++] = i2;
        }
        String[] stringArray = new String[n2 + 1];
        if (n2 == 0) {
            stringArray[0] = str;
            return stringArray;
        }
        int n3 = 0;
        int n4 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n5 = nArray[i3];
            stringArray[n3++] = str.substring(n4, n5);
            n4 = n5 + 1;
        }
        stringArray[n3] = str.substring(n4, str.length());
        return stringArray;
    }

    public static String[] split(String str) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(str, null);
    }

    public static String[] split(String str, String[] separator, int options) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(str, separator, Integer.MAX_VALUE, options);
    }

    public static String[] split(String baseStr, String[] separator, int count, int options) {
        boolean bl2;
        if (baseStr == null) {
            throw new NullReferenceException();
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Count cannot be less than zero.");
        }
        if (options != 0 && options != 1) {
            throw new ArgumentException(StringExtensions.concat("Illegal enum value: ", options, "."));
        }
        if (count <= 1) {
            String[] stringArray;
            if (count == 0) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = baseStr;
            }
            return stringArray;
        }
        boolean bl3 = bl2 = (options & 1) != 0;
        if (separator == null || separator.length == 0) {
            return StringExtensions.a(baseStr, null, count, bl2);
        }
        if (baseStr.length() == 0 && bl2) {
            return new String[0];
        }
        List<String> list = new List<String>();
        int n2 = 0;
        int n3 = 0;
        while (n2 < baseStr.length()) {
            int n4 = -1;
            int n5 = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < separator.length; ++i2) {
                int n6;
                String string = separator[i2];
                if (string == null || string.length() == 0 || (n6 = StringExtensions.indexOf(baseStr, string, n2, baseStr.length() - n2, (short)4)) < 0 || n6 >= n5) continue;
                n4 = i2;
                n5 = n6;
            }
            if (n4 == -1) break;
            if (n5 != n2 || !bl2) {
                if (list.size() == count - 1) break;
                list.addItem(StringExtensions.substring(baseStr, n2, n5 - n2));
            }
            n2 = n5 + separator[n4].length();
            ++n3;
        }
        if (n3 == 0) {
            return new String[]{baseStr};
        }
        if (bl2 && n3 != 0 && n2 == baseStr.length() && list.size() == 0) {
            return new String[0];
        }
        if (!bl2 || n2 != baseStr.length()) {
            list.addItem(StringExtensions.substring(baseStr, n2));
        }
        return list.toArray(new String[0]);
    }

    public static String[] split(String str, char ... separators) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(str, separators, Integer.MAX_VALUE, 0);
    }

    public static String[] split(String baseStr, char[] separator, int count, int options) {
        if (baseStr == null) {
            throw new NullReferenceException();
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Count cannot be less than zero.");
        }
        if (options != 0 && options != 1) {
            throw new ArgumentException(StringExtensions.concat("Illegal enum value: ", options, "."));
        }
        if (baseStr.length() == 0 && (options & 1) != 0) {
            return new String[0];
        }
        if (count <= 1) {
            String[] stringArray;
            if (count == 0) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = baseStr;
            }
            return stringArray;
        }
        return StringExtensions.a(baseStr, separator, count, options != 0);
    }

    private static String[] a(String string, char[] cArray, int n2, boolean bl2) {
        int n3;
        int n4;
        if (cArray == null || cArray.length == 0) {
            cArray = a;
        }
        int[] nArray = new int[string.length()];
        int n5 = 0;
        block0: for (n4 = 0; n4 < string.length(); ++n4) {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (string.charAt(n4) != cArray[i2]) continue;
                nArray[n5++] = n4;
                continue block0;
            }
        }
        if (n5 == string.length() && bl2) {
            return new String[0];
        }
        n4 = n5;
        if (n2 != Integer.MAX_VALUE && n2 < n5) {
            n4 = n2;
        }
        String[] stringArray = new String[n4 + 1];
        if (n5 == 0) {
            stringArray[0] = string;
            return stringArray;
        }
        int n6 = 0;
        int n7 = 0;
        for (int i3 = 0; i3 < n4 && (n2 == Integer.MAX_VALUE || i3 < n2 - 1); ++i3) {
            n3 = nArray[i3];
            String string2 = string.substring(n7, n3);
            if (!string2.equals(Empty) || !bl2) {
                stringArray[n6++] = string2;
            }
            n7 = n3 + 1;
        }
        String string3 = string.substring(n7, string.length());
        if (!bl2 || !string3.equals(Empty)) {
            if (string3.length() > 0) {
                string3 = StringExtensions.a(string3, cArray);
            }
            stringArray[n6] = string3;
        }
        if (stringArray.length > n2 && !bl2) {
            String[] stringArray2 = new String[n2];
            Array.copy(Array.boxing(stringArray), 0, Array.boxing(stringArray2), 0, n2);
            return stringArray2;
        }
        if (bl2) {
            n3 = 0;
            int n8 = 0;
            int[] nArray2 = new int[stringArray.length];
            for (String string4 : stringArray) {
                if (string4 != null && !string4.equals(Empty)) {
                    nArray2[n3++] = n8;
                }
                ++n8;
            }
            if (n3 > 0) {
                String[] stringArray3 = new String[n3];
                for (int i4 = 0; i4 < n3; ++i4) {
                    stringArray3[i4] = stringArray[nArray2[i4]];
                }
                if (n3 < n2 && StringExtensions.indexOfAny(stringArray3[n3 - 1], cArray) != -1) {
                    if (n3 == 1) {
                        return StringExtensions.a(stringArray3[n3 - 1], cArray, n2, bl2);
                    }
                    String[] stringArray4 = StringExtensions.a(stringArray3[n3 - 1], cArray, n2 - n3, bl2);
                    for (int i5 = 0; i5 < stringArray4.length; ++i5) {
                        stringArray3[n3 - 1 + i5] = stringArray4[0];
                    }
                    return stringArray3;
                }
                return stringArray3;
            }
            return new String[0];
        }
        return stringArray;
    }

    private static String a(String string, char[] cArray) {
        String string2 = string;
        while (StringExtensions.indexOfAny(string2, cArray) == 0) {
            string2 = StringExtensions.substring(string2, 1);
        }
        return string2;
    }

    public static String[] split(String str, char[] separators, int count) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(str, separators, count, 0);
    }

    public static String[] split(String str, char[] separators, short options) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(str, separators, Integer.MAX_VALUE, (int)options);
    }

    public static String plusEqOperator(String lhs, String rhs) {
        if (lhs == null) {
            lhs = "";
        }
        if (rhs == null) {
            rhs = "";
        }
        return lhs + rhs;
    }

    public static String plusEqOperator(String lhs, char rhs) {
        if (lhs == null) {
            lhs = "";
        }
        return lhs + rhs;
    }

    public static String plusEqOperator(String lhs, int rhs) {
        if (lhs == null) {
            lhs = "";
        }
        return lhs + rhs;
    }

    public static String plusEqOperator(String lhs, StringBuilder rhs) {
        if (lhs == null) {
            lhs = "";
        }
        return lhs + rhs;
    }

    public static String plusEqOperator(String lhs, Object rhs) {
        if (lhs == null) {
            lhs = "";
        }
        return lhs + rhs;
    }

    public static String toLowerInvariant(String value) {
        if (value == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toLower(value, CultureInfo.getInvariantCulture());
    }

    public static boolean startsWith(String str, String value) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(str, value, 0L);
    }

    public static boolean startsWith(String str, String value, short comparisonType) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        switch (comparisonType) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(str, value, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(str, value, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isPrefix(str, value, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isPrefix(str, value, 1L);
            }
            case 4: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(str, value, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(str, value, 0x10000000L);
            }
        }
        String string = StringExtensions.format("Invalid value '{0}' for StringComparison", comparisonType);
        throw new ArgumentException(string, "comparisonType");
    }

    public static boolean startsWith(String str, String value, boolean ignoreCase, CultureInfo culture) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (culture == null) {
            culture = CultureInfo.getCurrentCulture();
        }
        return culture.getCompareInfo().isPrefix(str, value, ignoreCase ? 1L : 0L);
    }

    public static boolean endsWith(String str, String value, short comparisonType) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        switch (comparisonType) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(str, value, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(str, value, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isSuffix(str, value, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isSuffix(str, value, 1L);
            }
            case 4: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(str, value, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(str, value, 0x10000000L);
            }
        }
        throw new ArgumentException(StringExtensions.format("Invalid value '{0}' for StringComparison", comparisonType), "comparisonType");
    }

    public static boolean endsWith(String str, String value, boolean ignoreCase, CultureInfo culture) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (culture == null) {
            culture = CultureInfo.getCurrentCulture();
        }
        return culture.getCompareInfo().isSuffix(str, value, ignoreCase ? 1L : 0L);
    }

    public static boolean endsWith(String str, String value) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(str, value, 0L);
    }

    public static String toLower(String s2) {
        if (s2 == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toLower(s2, CultureInfo.getCurrentCulture());
    }

    public static String toLower(String value, CultureInfo culture) {
        if (value == null) {
            throw new NullReferenceException();
        }
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        return value.toLowerCase(CultureInfo.toJava(culture));
    }

    private static String a(int n2, char c2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + n2);
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public static String padRight(String str, int size, char padChar) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (size < 0) {
            throw new ArgumentOutOfRangeException("totalWidth", "< 0");
        }
        if (str == null) {
            return null;
        }
        int n2 = size - str.length();
        if (n2 <= 0) {
            return str;
        }
        return str.concat(StringExtensions.a(n2, padChar));
    }

    public static String padRight(String str, int size) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.padRight(str, size, ' ');
    }

    public static String padLeft(String str, int size, char padChar) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (size < 0) {
            throw new ArgumentOutOfRangeException("totalWidth", "< 0");
        }
        if (str == null) {
            return null;
        }
        int n2 = size - str.length();
        if (n2 <= 0) {
            return str;
        }
        return StringExtensions.a(n2, padChar).concat(str);
    }

    public static String padLeft(String str, int size) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.padLeft(str, size, ' ');
    }

    public static String copy(String str) {
        if (str == null) {
            throw new ArgumentNullException("str");
        }
        int n2 = str.length();
        String string = new String(str.toCharArray(), 0, n2);
        return string;
    }

    public static int lastIndexOf(String str, String value) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.lastIndexOf(str, value, str.length() - 1, str.length());
    }

    public static int lastIndexOf(String str, String value, short comparisonType) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (str.length() == 0) {
            return value.length() == 0 ? 0 : -1;
        }
        return StringExtensions.lastIndexOf(str, value, str.length() - 1, str.length(), comparisonType);
    }

    public static int lastIndexOf(String str, String value, int startIndex, short comparisonType) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.lastIndexOf(str, value, startIndex, startIndex + 1, comparisonType);
    }

    public static int lastIndexOf(String str, String value, int startIndex) {
        if (str == null) {
            throw new NullReferenceException();
        }
        int n2 = startIndex;
        if (n2 < str.length()) {
            ++n2;
        }
        return StringExtensions.lastIndexOf(str, value, startIndex, n2);
    }

    public static int lastIndexOf(String str, String value, int startIndex, int count) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (str.length() == 0) {
            return value.length() == 0 ? 0 : -1;
        }
        if (startIndex < -1 || startIndex > str.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0 || > this.Length");
        }
        if (count < 0 || count > str.length()) {
            throw new ArgumentOutOfRangeException("count", "< 0 || > this.Length");
        }
        if (startIndex - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("startIndex - count + 1 < 0");
        }
        if (value.length() == 0) {
            return Math.min(str.length() - 1, startIndex);
        }
        if (startIndex == 0 && str.length() == 0) {
            return -1;
        }
        if (str.length() == 0 && value.length() > 0) {
            return -1;
        }
        if (count == 0) {
            return -1;
        }
        if (startIndex == str.length()) {
            --startIndex;
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().lastIndexOf(str, value, startIndex, count);
    }

    public static int lastIndexOf(String str, char value) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (str.length() == 0) {
            return -1;
        }
        return StringExtensions.lastIndexOf(str, value, str.length() - 1, str.length());
    }

    public static int lastIndexOf(String str, char value, int startIndex) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.lastIndexOf(str, value, startIndex, startIndex + 1);
    }

    public static int lastIndexOf(String str, char value, int startIndex, int count) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (str.length() == 0) {
            return -1;
        }
        if (startIndex < 0 || startIndex >= str.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0 || >= this.Length");
        }
        if (count < 0 || count > str.length()) {
            throw new ArgumentOutOfRangeException("count", "< 0 || > this.Length");
        }
        if (startIndex - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("startIndex - count + 1 < 0");
        }
        int n2 = startIndex - count + 1;
        int n3 = startIndex + 1;
        String string = str.substring(n2, n3);
        int n4 = string.lastIndexOf(value, count - 1);
        if (n4 >= 0) {
            return n4 += n2;
        }
        return n4;
    }

    public static int lastIndexOf(String str, String value, int startIndex, int count, short comparisonType) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (str.length() == 0) {
            return value.length() == 0 ? 0 : -1;
        }
        if (comparisonType < 0 || comparisonType > 5) {
            throw new ArgumentException("comparisonType");
        }
        if (value.length() == 0) {
            return Math.min(str.length() - 1, startIndex);
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || startIndex < count - 1) {
            throw new ArgumentOutOfRangeException("count");
        }
        switch (comparisonType) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().lastIndexOf(str, value, startIndex, count, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().lastIndexOf(str, value, startIndex, count, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(str, value, startIndex, count, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(str, value, startIndex, count, 1L);
            }
            case 4: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(str, value, startIndex, count, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(str, value, startIndex, count, 0x10000000L);
            }
        }
        String string = StringExtensions.format("Invalid value '{0}' for StringComparison", comparisonType);
        throw new ArgumentException(string, "comparisonType");
    }

    public static boolean equals(String a2, String b2) {
        return a2 == null && b2 == null || a2 != null && a2.equals(b2);
    }

    public static boolean equals(String a2, Object b2) {
        return a2 == null && b2 == null || a2 != null && a2.equals(b2);
    }

    public static boolean equals(String a2, String b2, short comparisonType) {
        return a2 == null && b2 == null || a2 != null && b2 != null && StringExtensions.compare(a2, b2, comparisonType) == 0;
    }

    public static int compare(String strA, String strB) {
        return CultureInfo.getCurrentCulture().getCompareInfo().compare(strA, strB, 0L);
    }

    public static int compare(String strA, String strB, boolean ignoreCase) {
        return CultureInfo.getCurrentCulture().getCompareInfo().compare(strA, strB, ignoreCase ? 1L : 0L);
    }

    public static int compare(String strA, String strB, boolean ignoreCase, CultureInfo culture) {
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        return culture.getCompareInfo().compare(strA, strB, ignoreCase ? 1L : 0L);
    }

    public static int compare(String strA, int indexA, String strB, int indexB, int length) {
        return StringExtensions.compare(strA, indexA, strB, indexB, length, false, CultureInfo.getCurrentCulture());
    }

    public static int compare(String strA, int indexA, String strB, int indexB, int length, boolean ignoreCase) {
        return StringExtensions.compare(strA, indexA, strB, indexB, length, ignoreCase, CultureInfo.getCurrentCulture());
    }

    public static int compare(String strA, int indexA, String strB, int indexB, int length, boolean ignoreCase, CultureInfo culture) {
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        if (length == 0) {
            return 0;
        }
        if (strA == null) {
            if (strB == null) {
                return 0;
            }
            return -1;
        }
        if (strB == null) {
            return 1;
        }
        if (indexA > strA.length() || indexB > strB.length() || indexA < 0 || indexB < 0 || length < 0) {
            throw new ArgumentException();
        }
        long l2 = ignoreCase ? 1L : 0L;
        int n2 = length;
        int n3 = length;
        if (length > strA.length() - indexA) {
            n2 = strA.length() - indexA;
        }
        if (length > strB.length() - indexB) {
            n3 = strB.length() - indexB;
        }
        return culture.getCompareInfo().compare(strA, indexA, n2, strB, indexB, n3, l2);
    }

    public static int compare(String strA, String strB, short comparisonType) {
        switch (comparisonType) {
            case 0: {
                return StringExtensions.compare(strA, strB, false, CultureInfo.getCurrentCulture());
            }
            case 1: {
                return StringExtensions.compare(strA, strB, true, CultureInfo.getCurrentCulture());
            }
            case 2: {
                return StringExtensions.compare(strA, strB, false, CultureInfo.getInvariantCulture());
            }
            case 3: {
                return StringExtensions.compare(strA, strB, true, CultureInfo.getInvariantCulture());
            }
            case 4: {
                return StringExtensions.compareOrdinal(strA, strB);
            }
            case 5: {
                return StringExtensions.a(strA, strB);
            }
        }
        String string = StringExtensions.format("Invalid value '{0}' for StringComparison", comparisonType);
        throw new ArgumentException(string + "\r\nParameter name: comparisonType");
    }

    public static int compare(String strA, int indexA, String strB, int indexB, int length, short comparisonType) {
        switch (comparisonType) {
            case 0: {
                return StringExtensions.compare(strA, indexA, strB, indexB, length, false, CultureInfo.getCurrentCulture());
            }
            case 1: {
                return StringExtensions.compare(strA, indexA, strB, indexB, length, true, CultureInfo.getCurrentCulture());
            }
            case 2: {
                return StringExtensions.compare(strA, indexA, strB, indexB, length, false, CultureInfo.getInvariantCulture());
            }
            case 3: {
                return StringExtensions.compare(strA, indexA, strB, indexB, length, true, CultureInfo.getInvariantCulture());
            }
            case 4: {
                return StringExtensions.compareOrdinal(strA, indexA, strB, indexB, length);
            }
            case 5: {
                return StringExtensions.a(strA, indexA, strB, indexB, length);
            }
        }
        String string = StringExtensions.format("Invalid value '{0}' for StringComparison", comparisonType);
        throw new ArgumentException(string + "\r\nParameter name: comparisonType");
    }

    public static int compare(String strA, String strB, CultureInfo culture, long options) {
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        return culture.getCompareInfo().compare(strA, strB, options);
    }

    public static int compare(String strA, int indexA, String strB, int indexB, int length, CultureInfo culture, long options) {
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        int n2 = length;
        int n3 = length;
        if (length > strA.length() - indexA) {
            n2 = strA.length() - indexA;
        }
        if (length > strB.length() - indexB) {
            n3 = strB.length() - indexB;
        }
        return culture.getCompareInfo().compare(strA, indexA, n2, strB, indexB, n3, options);
    }

    public static int compareOrdinal(String strA, String strB) {
        if (strA == null && strB == null) {
            return 0;
        }
        if (strB == null) {
            return 1;
        }
        return strA.compareTo(strB);
    }

    public static int compareOrdinal(String strA, int indexA, String strB, int indexB, int length) {
        if (indexA > strA.length() || indexB > strB.length() || indexA < 0 || indexB < 0 || length < 0) {
            throw new ArgumentException();
        }
        String string = strA.substring(indexA, Math.min(indexA + length, strA.length()));
        String string2 = strB.substring(indexB, Math.min(indexB + length, strB.length()));
        return string.compareTo(string2);
    }

    private static int a(String string, String string2) {
        return string.compareToIgnoreCase(string2);
    }

    private static int a(String string, int n2, String string2, int n3, int n4) {
        if (n2 > string.length() || n3 > string2.length() || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new ArgumentException();
        }
        String string3 = string.substring(n2, n2 + n4);
        String string4 = string2.substring(n3, n3 + n4);
        return string3.compareToIgnoreCase(string4);
    }

    public static int indexOf(String thisStr, String value) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length() == 0) {
            return 0;
        }
        if (thisStr.length() == 0) {
            return -1;
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(thisStr, value, 0, thisStr.length(), 0x40000000L);
    }

    public static int indexOf(String thisStr, String value, int startIndex) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(thisStr, value, startIndex, thisStr.length() - startIndex);
    }

    public static int indexOf(String thisStr, char value) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(thisStr, value, 0);
    }

    public static int indexOf(String thisStr, char value, int startIndex) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0");
        }
        if (startIndex > thisStr.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "startIndex > this.length");
        }
        if (startIndex == 0 && thisStr.length() == 0 || startIndex == thisStr.length()) {
            return -1;
        }
        return thisStr.indexOf(value, startIndex);
    }

    public static int indexOf(String thisStr, char value, int startIndex, int count) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        if (startIndex < 0 || startIndex > thisStr.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative and must be< 0");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (startIndex > thisStr.length() - count) {
            throw new ArgumentOutOfRangeException("count", "startIndex + count > this.length");
        }
        if (startIndex == 0 && thisStr.length() == 0 || startIndex == thisStr.length() || count == 0) {
            return -1;
        }
        int n2 = thisStr.indexOf(value, startIndex);
        return n2 >= startIndex + count ? -1 : n2;
    }

    public static int indexOf(String thisStr, String value, short comparisonType) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(thisStr, value, 0, thisStr.length(), comparisonType);
    }

    public static int indexOf(String thisStr, String value, int startIndex, short comparisonType) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(thisStr, value, startIndex, thisStr.length() - startIndex, comparisonType);
    }

    public static int indexOf(String thisStr, String value, int startIndex, int count, short comparisonType) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        switch (comparisonType) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(thisStr, value, startIndex, count, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(thisStr, value, startIndex, count, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(thisStr, value, startIndex, count, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(thisStr, value, startIndex, count, 1L);
            }
            case 4: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(thisStr, value, startIndex, count, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(thisStr, value, startIndex, count, 0x10000000L);
            }
        }
        String string = StringExtensions.format("Invalid value '{0}' for StringComparison", comparisonType);
        throw new ArgumentException(string, "comparisonType");
    }

    public static int indexOf(String thisStr, String value, int startIndex, int count) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (startIndex < 0 || startIndex > thisStr.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative, and should not exceed length of string.");
        }
        if (count < 0 || startIndex > thisStr.length() - count) {
            throw new ArgumentOutOfRangeException("count", "Cannot be negative, and should point to location in string.");
        }
        if (value.length() == 0) {
            return startIndex;
        }
        if (startIndex == 0 && thisStr.length() == 0) {
            return -1;
        }
        if (count == 0) {
            return -1;
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(thisStr, value, startIndex, count);
    }

    private static String[] a(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = objectArray[i2] == null ? Empty : objectArray[i2].toString();
        }
        return stringArray;
    }

    private static StringBuilder a(String[] stringArray) {
        int n2 = 0;
        for (String string : stringArray) {
            if (string == null) continue;
            n2 += string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (String string : stringArray) {
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    public static String concat(String ... strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        return StringExtensions.a(strings).toString();
    }

    public static String concat(Object ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return "";
        }
        return StringExtensions.a(StringExtensions.a(objects)).toString();
    }

    public static boolean contains(String thisStr, String value) {
        if (thisStr == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(thisStr, value) != -1;
    }

    public static String isInterned(String str) {
        if (str == null) {
            throw new ArgumentNullException("str");
        }
        String string = new String(str);
        String string2 = string.intern();
        return str == string2 ? string2 : null;
    }

    public static String intern(String str) {
        if (str == null) {
            throw new ArgumentNullException("str");
        }
        return str.intern();
    }

    public static String substring(String str, int startIndex) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (startIndex == 0) {
            return str;
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return str.substring(startIndex);
    }

    public static String substring(String str, int startIndex, int length) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Cannot be negative.");
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative.");
        }
        if (startIndex > str.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot exceed length of string.");
        }
        if (startIndex > str.length() - length) {
            throw new ArgumentOutOfRangeException("length", "startIndex + length cannot exceed length of string.");
        }
        if (startIndex == 0 && length == str.length()) {
            return str;
        }
        return str.substring(startIndex, startIndex + length);
    }

    public static char[] toCharArray(String str) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toCharArray(str, 0, str.length());
    }

    public static char[] toCharArray(String str, int startIndex, int length) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "< 0");
        }
        if (startIndex > str.length() - length) {
            throw new ArgumentOutOfRangeException("startIndex", "Must be greater than the length of the string.");
        }
        char[] cArray = new char[length];
        System.arraycopy(str.toCharArray(), startIndex, cArray, 0, length);
        return cArray;
    }

    public static String toString(String str) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return str;
    }

    public static String toUpper(String str) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toUpper(str, CultureInfo.getCurrentCulture());
    }

    public static String toUpper(String str, CultureInfo culture) {
        if (str == null) {
            throw new NullReferenceException();
        }
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        return str.toUpperCase(CultureInfo.toJava(culture));
    }

    public static String toUpperInvariant(String str) {
        if (str == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toUpper(str, CultureInfo.getInvariantCulture());
    }

    public static char get_Item(String str, int index) {
        if (str == null) {
            throw new ArgumentNullException("str");
        }
        if (index < 0 || index >= str.length()) {
            throw new IndexOutOfRangeException();
        }
        return str.charAt(index);
    }

    private static boolean a(Object object) {
        boolean bl2 = false;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Float || object instanceof Decimal) {
            bl2 = true;
        }
        return bl2;
    }
}

