/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Text;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Decoder;
import com.aspose.html.internal.ms.System.Text.DecoderExceptionFallback;
import com.aspose.html.internal.ms.System.Text.DecoderFallback;
import com.aspose.html.internal.ms.System.Text.DecoderReplacementFallback;
import com.aspose.html.internal.ms.System.Text.Encoder;
import com.aspose.html.internal.ms.System.Text.EncoderFallback;
import com.aspose.html.internal.ms.core.mscorlib.d.fg;
import com.aspose.html.internal.ms.core.mscorlib.f.a;
import com.aspose.html.internal.ms.core.mscorlib.f.e;

@SerializableAttribute
public class UnicodeEncoding
extends fg {
    static final int a = 1200;
    static final int n = 1201;
    private boolean o;
    private boolean p;

    public UnicodeEncoding() {
        this(false, true);
        this.o = false;
        this.p = true;
    }

    public UnicodeEncoding(boolean bigEndian, boolean byteOrderMark) {
        this(bigEndian, byteOrderMark, false);
    }

    public UnicodeEncoding(boolean bigEndian, boolean byteOrderMark, boolean throwOnInvalidBytes) {
        super(bigEndian ? 1201 : 1200);
        if (throwOnInvalidBytes) {
            this.setFallbackInternal(null, new DecoderExceptionFallback());
        } else {
            this.setFallbackInternal(null, new DecoderReplacementFallback("\ufffd"));
        }
        this.o = bigEndian;
        this.p = byteOrderMark;
        if (bigEndian) {
            this.body_name = "unicodeFFFE";
            this.encoding_name = "Unicode (Big-Endian)";
            this.header_name = "unicodeFFFE";
            this.is_browser_save = false;
            this.web_name = "unicodeFFFE";
        } else {
            this.body_name = "utf-16";
            this.encoding_name = "Unicode";
            this.header_name = "utf-16";
            this.is_browser_save = true;
            this.web_name = "utf-16";
        }
        this.windows_code_page = 1200;
    }

    @Override
    public int getByteCount(char[] chars, int index, int count) {
        if (chars == null) {
            throw new ArgumentNullException("chars");
        }
        if (index < 0 || index > chars.length) {
            throw new ArgumentOutOfRangeException("index", UnicodeEncoding._("ArgRange_Array"));
        }
        if (count < 0 || count > chars.length - index) {
            throw new ArgumentOutOfRangeException("count", UnicodeEncoding._("ArgRange_Array"));
        }
        return this.a(count);
    }

    @Override
    public int getByteCount(String s2) {
        if (s2 == null) {
            throw new ArgumentNullException("s");
        }
        return this.a(s2.length());
    }

    private int a(int n2) {
        return n2 * 2;
    }

    @Override
    public int getMaxByteCount(int charCount) {
        if (charCount < 0) {
            throw new ArgumentOutOfRangeException("charCount", "Non-negative number required.");
        }
        return (int)((long)charCount + 1L) << 1;
    }

    @Override
    public int getBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex) {
        if (chars == null) {
            throw new ArgumentNullException("chars");
        }
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (charIndex < 0 || charIndex > chars.length) {
            throw new ArgumentOutOfRangeException("charIndex", "ArgRange_Array");
        }
        if (charCount < 0 || charCount > chars.length - charIndex) {
            throw new ArgumentOutOfRangeException("charCount", "ArgRange_Array");
        }
        if (byteIndex < 0 || byteIndex > bytes.length) {
            throw new ArgumentOutOfRangeException("byteIndex", "ArgRange_Array");
        }
        int n2 = bytes.length - byteIndex;
        if (bytes.length == 0) {
            bytes = new byte[1];
        }
        return this.a(chars, charIndex, charCount, bytes, byteIndex, n2);
    }

    @Override
    public int getBytes(String s2, int charIndex, int charCount, byte[] bytes, int byteIndex) {
        if (s2 == null) {
            throw new ArgumentNullException("s");
        }
        char[] cArray = StringExtensions.toCharArray(s2);
        return this.getBytes(cArray, charIndex, charCount, bytes, byteIndex);
    }

    private int a(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) {
        int n6 = this.a(n3);
        if (n5 < n6) {
            throw new ArgumentException(UnicodeEncoding._("Arg_InsufficientSpace"));
        }
        e e2 = new e(this.o, this.getEncoderFallback());
        e2.a(cArray, n2, n3, byArray, n4);
        return n6;
    }

    @Override
    public Encoder getEncoder() {
        return new UnicodeEncoder(this.o, this.getEncoderFallback());
    }

    @Override
    public Decoder getDecoder() {
        return new UnicodeDecoder(this.o, this.getDecoderFallback());
    }

    @Override
    public int getCharCount(byte[] bytes, int index, int count) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index > bytes.length) {
            throw new ArgumentOutOfRangeException("index", UnicodeEncoding._("ArgRange_Array"));
        }
        if (count < 0 || count > bytes.length - index) {
            throw new ArgumentOutOfRangeException("count", UnicodeEncoding._("ArgRange_Array"));
        }
        com.aspose.html.internal.ms.core.mscorlib.e.e e2 = new com.aspose.html.internal.ms.core.mscorlib.e.e(this.o, this.getDecoderFallback());
        return e2.a(bytes, index, count);
    }

    @Override
    public int getMaxCharCount(int byteCount) {
        if (byteCount < 0) {
            throw new ArgumentOutOfRangeException("byteCount", "Non-negative number required.");
        }
        return (int)((long)((byteCount >> 1) + (byteCount & 1)) + 1L);
    }

    @Override
    public int getChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex) {
        return this.a(bytes, byteIndex, byteCount, chars, charIndex);
    }

    @Override
    public String getString(byte[] bytes, int index, int count) {
        if (count == 0) {
            return StringExtensions.Empty;
        }
        int n2 = this.getCharCount(bytes, index, count);
        char[] cArray = new char[n2];
        this.a(bytes, index, count, cArray, 0);
        return StringExtensions.newString(cArray);
    }

    private int a(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        com.aspose.html.internal.ms.core.mscorlib.e.e e2 = new com.aspose.html.internal.ms.core.mscorlib.e.e(this.o, this.getDecoderFallback());
        return e2.a(byArray, n2, n3, cArray, n4);
    }

    @Override
    public byte[] getPreamble() {
        if (this.p) {
            if (this.o) {
                return new byte[]{-2, -1};
            }
            return new byte[]{-1, -2};
        }
        return new byte[0];
    }

    private static final class UnicodeDecoder
    extends com.aspose.html.internal.ms.core.mscorlib.e.a {
        public UnicodeDecoder(boolean bigEndian, DecoderFallback fallback) {
            super(new com.aspose.html.internal.ms.core.mscorlib.e.e(bigEndian, fallback));
        }
    }

    private static class UnicodeEncoder
    extends a {
        private UnicodeEncoder(boolean bigEndian, EncoderFallback fallback) {
            super(new e(bigEndian, fallback));
        }
    }
}

