/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Text;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IndexOutOfRangeException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Runtime.CompilerServices.IndexerNameAttribute;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import java.util.Arrays;

@SerializableAttribute
public final class msStringBuilder {
    private int a;
    private char[] b;
    private String c;
    private int d;
    private static final int e = 16;

    public msStringBuilder(String value, int startIndex, int length, int capacity) {
        this(value, startIndex, length, capacity, Integer.MAX_VALUE);
    }

    private msStringBuilder(String value, int startIndex, int length, int capacity, int maxCapacity) {
        if (null == value) {
            value = "";
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", startIndex, "StartIndex cannot be less than zero.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", length, "Length cannot be less than zero.");
        }
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", capacity, "capacity must be greater than zero.");
        }
        if (maxCapacity < 1) {
            throw new ArgumentOutOfRangeException("maxCapacity", "maxCapacity is less than one.");
        }
        if (capacity > maxCapacity) {
            throw new ArgumentOutOfRangeException("capacity", "Capacity exceeds maximum capacity.");
        }
        if (startIndex > value.length() - length) {
            throw new ArgumentOutOfRangeException("startIndex", startIndex, "StartIndex and length must refer to a location within the string.");
        }
        if (capacity == 0) {
            if (maxCapacity > 16) {
                capacity = 16;
            } else {
                this.b = new char[0];
                this.c = StringExtensions.Empty;
            }
        }
        this.d = maxCapacity;
        if (this.b == null) {
            this.b = new char[length > capacity ? length : capacity];
        }
        if (length > 0) {
            this.a(0, value, startIndex, length);
        }
        this.a = length;
    }

    public msStringBuilder() {
        this(null);
    }

    public msStringBuilder(int capacity) {
        this(StringExtensions.Empty, 0, 0, capacity);
    }

    public msStringBuilder(int capacity, int maxCapacity) {
        this(StringExtensions.Empty, 0, 0, capacity, maxCapacity);
    }

    public msStringBuilder(String value) {
        if (value == null) {
            value = StringExtensions.Empty;
        }
        this.a = value.length();
        this.b = value.toCharArray();
        this.c = value;
        this.d = Integer.MAX_VALUE;
    }

    public msStringBuilder(String value, int capacity) {
        this(value == null ? "" : value, 0, value == null ? 0 : value.length(), capacity);
    }

    public int getMaxCapacity() {
        return this.d;
    }

    public int getCapacity() {
        if (this.b.length == 0) {
            return Math.min(this.d, 16);
        }
        return this.b.length;
    }

    public void setCapacity(int value) {
        if (value < this.a) {
            throw new ArgumentException("Capacity must be larger than length");
        }
        if (value > this.d) {
            throw new ArgumentOutOfRangeException("value", "Should be less than or equal to MaxCapacity");
        }
        this.a(value);
    }

    public int getLength() {
        return this.a;
    }

    public void setLength(int value) {
        if (value < 0 || value > this.d) {
            throw new ArgumentOutOfRangeException();
        }
        if (value == this.a) {
            return;
        }
        if (value < this.a) {
            this.a(value);
            this.a = value;
        } else {
            this.append('\u0000', value - this.a);
        }
    }

    @IndexerNameAttribute(indexerName="Chars")
    public char get_Char(int index) {
        if (index >= this.a || index < 0) {
            throw new IndexOutOfRangeException();
        }
        return this.b[index];
    }

    @IndexerNameAttribute(indexerName="Chars")
    public void set_Char(int index, char value) {
        if (index >= this.a || index < 0) {
            throw new IndexOutOfRangeException();
        }
        if (this.c != null) {
            this.a(this.a);
        }
        this.a(index, value);
    }

    public String toString() {
        if (this.a == 0) {
            return StringExtensions.Empty;
        }
        if (this.c == null) {
            this.c = this.b.length == this.a ? new String(this.b) : new String(this.b, 0, this.a);
        }
        return this.c;
    }

    public String toString(int startIndex, int length) {
        if (startIndex < 0 || length < 0 || startIndex > this.a - length) {
            throw new ArgumentOutOfRangeException();
        }
        String string = this.toString();
        if (startIndex == 0 && length == this.a) {
            return string;
        }
        return StringExtensions.substring(string, startIndex, length);
    }

    public int ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Capacity must be greater than 0.");
        }
        if (capacity <= this.b.length) {
            return this.b.length;
        }
        this.a(capacity);
        return this.b.length;
    }

    public boolean equals(msStringBuilder sb) {
        if (sb == null) {
            return false;
        }
        return this.a == sb.getLength() && StringExtensions.equals(this.toString(), sb.toString());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        msStringBuilder msStringBuilder2 = (msStringBuilder)o2;
        return this.equals(msStringBuilder2);
    }

    public int hashCode() {
        int n2 = this.a;
        n2 = 31 * n2 + (this.b != null ? Arrays.hashCode(this.b) : 0);
        return n2;
    }

    public msStringBuilder remove(int startIndex, int length) {
        if (startIndex < 0 || length < 0 || startIndex > this.a - length) {
            throw new ArgumentOutOfRangeException();
        }
        if (this.c != null) {
            this.a(this.a);
        }
        if (this.a - (startIndex + length) > 0) {
            this.a(startIndex, this.b, startIndex + length, this.a - (startIndex + length));
        }
        this.a -= length;
        return this;
    }

    public msStringBuilder replace(char oldChar, char newChar) {
        return this.replace(oldChar, newChar, 0, this.a);
    }

    public msStringBuilder replace(char oldChar, char newChar, int startIndex, int count) {
        if (startIndex > this.a - count || startIndex < 0 || count < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (this.c != null) {
            this.a(this.b.length);
        }
        for (int i2 = startIndex; i2 < startIndex + count; ++i2) {
            if (this.b[i2] != oldChar) continue;
            this.a(i2, newChar);
        }
        return this;
    }

    public msStringBuilder replace(String oldValue, String newValue) {
        return this.replace(oldValue, newValue, 0, this.a);
    }

    public msStringBuilder replace(String oldValue, String newValue, int startIndex, int count) {
        if (oldValue == null) {
            throw new ArgumentNullException("The old value cannot be null.");
        }
        if (startIndex < 0 || count < 0 || startIndex > this.a - count) {
            throw new ArgumentOutOfRangeException();
        }
        if (oldValue.length() == 0) {
            throw new ArgumentException("The old value cannot be zero length.");
        }
        char[] cArray = new char[count];
        System.arraycopy(this.b, startIndex, cArray, 0, count);
        String string = new String(cArray);
        String string2 = StringExtensions.replace(string, oldValue, newValue);
        if (StringExtensions.equals(string2, string)) {
            return this;
        }
        this.a(string2.length() + (this.a - count));
        if (string2.length() < count) {
            this.a(startIndex + string2.length(), this.b, startIndex + count, this.a - startIndex - count);
        } else if (string2.length() > count) {
            this.b(startIndex + string2.length(), this.b, startIndex + count, this.a - startIndex - count);
        }
        this.a(startIndex, string2, 0, string2.length());
        this.a = string2.length() + (this.a - count);
        return this;
    }

    public msStringBuilder append(char[] value) {
        if (value == null) {
            return this;
        }
        int n2 = this.a + value.length;
        if (this.c != null || this.b.length < n2) {
            this.a(n2);
        }
        this.a(this.a, value, 0, value.length);
        this.a = n2;
        return this;
    }

    public msStringBuilder append(String value) {
        if (value == null) {
            return this;
        }
        if (this.a == 0 && value.length() < this.d && value.length() > this.b.length) {
            this.a = value.length();
            this.b = value.toCharArray();
            this.c = value;
            return this;
        }
        int n2 = this.a + value.length();
        if (this.c != null || this.b.length < n2) {
            this.a(n2);
        }
        this.a(this.a, value, 0, value.length());
        this.a = n2;
        return this;
    }

    public msStringBuilder append(boolean value) {
        return this.append(Boolean.toString(value));
    }

    public msStringBuilder append(Decimal value) {
        return this.append(value.toString());
    }

    public msStringBuilder append(double value) {
        return this.append(Double.toString(value));
    }

    public msStringBuilder append(short value) {
        return this.append(Short.toString(value));
    }

    public msStringBuilder append(int value) {
        return this.append(Integer.toString(value));
    }

    public msStringBuilder append(long value) {
        return this.append(Long.toString(value));
    }

    public msStringBuilder append(Object value) {
        if (value == null) {
            return this;
        }
        return this.append(value.toString());
    }

    public msStringBuilder append(byte value) {
        return this.append(Byte.toString(value));
    }

    public msStringBuilder append(float value) {
        return this.append(SingleExtensions.toString(value));
    }

    public msStringBuilder append(char value) {
        int n2 = this.a + 1;
        if (this.c != null || this.b.length < n2) {
            this.a(n2);
        }
        this.a(this.a, value);
        this.a = n2;
        return this;
    }

    public msStringBuilder append(char value, int repeatCount) {
        if (repeatCount < 0) {
            throw new ArgumentOutOfRangeException();
        }
        this.a(this.a + repeatCount);
        for (int i2 = 0; i2 < repeatCount; ++i2) {
            this.a(this.a++, value);
        }
        return this;
    }

    public msStringBuilder append(char[] value, int startIndex, int charCount) {
        if (value == null) {
            if (startIndex != 0 || charCount != 0) {
                throw new ArgumentNullException("value");
            }
            return this;
        }
        if (charCount < 0 || startIndex < 0 || startIndex > value.length - charCount) {
            throw new ArgumentOutOfRangeException();
        }
        int n2 = this.a + charCount;
        this.a(n2);
        this.a(this.a, value, startIndex, charCount);
        this.a = n2;
        return this;
    }

    public msStringBuilder append(String value, int startIndex, int count) {
        if (value == null) {
            if (startIndex != 0 && count != 0) {
                throw new ArgumentNullException("value");
            }
            return this;
        }
        if (count < 0 || startIndex < 0 || startIndex > value.length() - count) {
            throw new ArgumentOutOfRangeException();
        }
        int n2 = this.a + count;
        if (this.c != null || this.b.length < n2) {
            this.a(n2);
        }
        this.a(this.a, value, startIndex, count);
        this.a = n2;
        return this;
    }

    public msStringBuilder appendLine() {
        return this.append(Environment.NewLine);
    }

    public msStringBuilder appendLine(String value) {
        return this.append(value).append(Environment.NewLine);
    }

    public msStringBuilder appendFormat(String format, Object ... args) {
        return this.appendFormat((IFormatProvider)null, format, args);
    }

    public static msStringBuilder appendFormat(msStringBuilder builder, IFormatProvider culture, String format, Object ... args) {
        if (builder == null) {
            throw new NullReferenceException();
        }
        if (culture == CultureInfo.getInvariantCulture()) {
            return builder.appendFormat(format, args);
        }
        throw new NotImplementedException();
    }

    public static msStringBuilder appendFormat(msStringBuilder builder, String format, Object ... args) {
        if (builder == null) {
            throw new NullReferenceException();
        }
        if (format == null || args == null) {
            throw new ArgumentNullException(format == null ? "format" : "args");
        }
        return builder.appendFormat(format, args);
    }

    public static msStringBuilder replace(msStringBuilder builder, String oldStr, String newStr) {
        if (builder == null) {
            throw new NullReferenceException();
        }
        if (oldStr == null) {
            throw new ArgumentNullException("oldStr");
        }
        if ("".equals(oldStr)) {
            throw new ArgumentException("oldStr");
        }
        if (newStr == null) {
            newStr = "";
        }
        return builder.replace(oldStr, newStr);
    }

    public msStringBuilder appendFormat(IFormatProvider provider, String format, Object ... args) {
        StringExtensions.formatHelper(this, provider, format, args);
        return this;
    }

    public msStringBuilder insert(int index, char[] value) {
        return this.insert(index, new String(value));
    }

    public msStringBuilder insert(int index, String value) {
        if (index > this.a || index < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value == null || value.length() == 0) {
            return this;
        }
        this.a(this.a + value.length());
        this.b(index + value.length(), this.b, index, this.a - index);
        this.a(index, value, 0, value.length());
        this.a += value.length();
        return this;
    }

    public msStringBuilder insert(int index, boolean value) {
        return this.insert(index, Boolean.toString(value));
    }

    public msStringBuilder insert(int index, char value) {
        if (index > this.a || index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        this.a(this.a + 1);
        this.b(index + 1, this.b, index, this.a - index);
        this.a(index, value);
        ++this.a;
        return this;
    }

    public msStringBuilder insert(int index, Decimal value) {
        return this.insert(index, value.toString());
    }

    public msStringBuilder insert(int index, double value) {
        return this.insert(index, Double.toString(value));
    }

    public msStringBuilder insert(int index, short value) {
        return this.insert(index, Short.toString(value));
    }

    public msStringBuilder insert(int index, int value) {
        return this.insert(index, Integer.toString(value));
    }

    public msStringBuilder insert(int index, long value) {
        return this.insert(index, Long.toString(value));
    }

    public msStringBuilder insert(int index, Object value) {
        return this.insert(index, value.toString());
    }

    public msStringBuilder insert(int index, byte value) {
        return this.insert(index, Byte.toString(value));
    }

    public msStringBuilder insert(int index, float value) {
        return this.insert(index, SingleExtensions.toString(value));
    }

    public msStringBuilder insert(int index, String value, int count) {
        if (count < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value != null && !StringExtensions.equals(value, StringExtensions.Empty)) {
            for (int i2 = 0; i2 < count; ++i2) {
                this.insert(index, value);
            }
        }
        return this;
    }

    public msStringBuilder insert(int index, char[] value, int startIndex, int charCount) {
        if (value == null) {
            if (startIndex == 0 && charCount == 0) {
                return this;
            }
            throw new ArgumentNullException("value");
        }
        if (charCount < 0 || startIndex < 0 || startIndex > value.length - charCount) {
            throw new ArgumentOutOfRangeException();
        }
        return this.insert(index, StringExtensions.newString(value, startIndex, charCount));
    }

    private void a(int n2) {
        if (n2 > this.b.length) {
            int n3 = this.b.length;
            if (n2 > n3) {
                if (n3 < 16) {
                    n3 = 16;
                }
                if (n2 > (n3 <<= 1)) {
                    n3 = n2;
                }
                if (n3 >= Integer.MAX_VALUE || n3 < 0) {
                    n3 = Integer.MAX_VALUE;
                }
                if (n3 > this.d && n2 <= this.d) {
                    n3 = this.d;
                }
                if (n3 > this.d) {
                    throw new ArgumentOutOfRangeException("size", "capacity was less than the current size.");
                }
            }
            char[] cArray = this.b;
            this.b = new char[n3];
            if (this.a > 0) {
                this.a(0, cArray, 0, this.a);
            }
        }
        this.c = null;
    }

    public void copyTo(int sourceIndex, char[] destination, int destinationIndex, int count) {
        if (destination == null) {
            throw new ArgumentNullException("destination");
        }
        if (this.getLength() - count < sourceIndex || destination.length - count < destinationIndex || sourceIndex < 0 || destinationIndex < 0 || count < 0) {
            throw new ArgumentOutOfRangeException();
        }
        for (int i2 = 0; i2 < count; ++i2) {
            destination[destinationIndex + i2] = this.b[sourceIndex + i2];
        }
    }

    private void a(int n2, String string, int n3, int n4) {
        this.a(n2, string.toCharArray(), n3, n4);
    }

    private void a(int n2, char[] cArray, int n3, int n4) {
        System.arraycopy(cArray, n3, this.b, n2, n4);
    }

    private void b(int n2, char[] cArray, int n3, int n4) {
        System.arraycopy(cArray, n3, this.b, n2, n4);
    }

    private void a(int n2, char c2) {
        if (n2 > this.b.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        this.b[n2] = c2;
    }
}

