/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Threading;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Runtime.ConstrainedExecution.ReliabilityContractAttribute;
import com.aspose.html.internal.ms.System.Threading.EventWaitHandle;
import com.aspose.html.internal.ms.System.Threading.ThreadInterruptedException;
import com.aspose.time.TimeSpan;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class WaitHandle
implements IDisposable {
    protected final Object syncObj = new Object();
    protected boolean isReady = false;
    protected int eventResetMode = 0;
    private CountDownLatch a = new CountDownLatch(1);
    protected static final IntPtr InvalidHandle = new IntPtr(-1L);
    private IntPtr b;
    public static final int WaitTimeout = 258;
    private boolean c = false;

    protected WaitHandle() {
    }

    CountDownLatch b() {
        return this.a;
    }

    void a(CountDownLatch countDownLatch) {
        this.a = countDownLatch;
    }

    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.c = true;
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn) {
        return WaitHandle.signalAndWait(toSignal, toWaitOn, -1, false);
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, TimeSpan timeout, boolean exitContext) {
        long l2 = (long)timeout.getTotalMilliseconds();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.signalAndWait(toSignal, toWaitOn, (int)l2, exitContext);
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, int timeout, boolean exitContext) {
        if (toSignal == null) {
            throw new ArgumentNullException("toSignal");
        }
        if (toWaitOn == null) {
            throw new ArgumentNullException("toWaitOn");
        }
        if (-1 > timeout) {
            throw new ArgumentOutOfRangeException("millisecondsTimeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        ((EventWaitHandle)toSignal).set();
        return toWaitOn.waitOne(timeout, exitContext);
    }

    public static boolean waitAll(WaitHandle[] waitHandles) {
        return WaitHandle.waitAll(waitHandles, -1, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, int timeout) {
        return WaitHandle.waitAll(waitHandles, timeout, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, TimeSpan timeout) {
        return WaitHandle.waitAll(waitHandles, timeout, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, TimeSpan timeout, boolean exitContext) {
        long l2 = (long)timeout.getTotalMilliseconds();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.waitAll(waitHandles, (int)l2, exitContext);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, int timeout, boolean exitContext) {
        boolean bl2;
        if (waitHandles == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i2 = 0; i2 < waitHandles.length; ++i2) {
            if (waitHandles[i2] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)timeout || Integer.MAX_VALUE < (long)timeout) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(waitHandles.length);
        for (bl2 = false; bl2 < waitHandles.length; bl2 += 1) {
            if (waitHandles[bl2].b().getCount() == 1L) {
                waitHandles[bl2].a(countDownLatch);
                continue;
            }
            countDownLatch.countDown();
            waitHandles[bl2].a(countDownLatch);
        }
        try {
            if (timeout == -1) {
                countDownLatch.await();
            } else if (timeout == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        boolean bl3 = bl2 = countDownLatch.getCount() == 0L;
        if (bl2) {
            for (int i3 = 0; i3 < waitHandles.length; ++i3) {
                waitHandles[i3].a();
            }
        }
        return bl2;
    }

    @ReliabilityContractAttribute(consistencyGuarantee=3, cer=1)
    public static int waitAny(WaitHandle[] waitHandles) {
        return WaitHandle.waitAny(waitHandles, -1, true);
    }

    @ReliabilityContractAttribute(consistencyGuarantee=3, cer=1)
    public static int waitAny(WaitHandle[] waitHandles, int timeout) {
        return WaitHandle.waitAny(waitHandles, timeout, true);
    }

    @ReliabilityContractAttribute(consistencyGuarantee=3, cer=1)
    public static int waitAny(WaitHandle[] waitHandles, TimeSpan timeout) {
        return WaitHandle.waitAny(waitHandles, timeout, true);
    }

    @ReliabilityContractAttribute(consistencyGuarantee=3, cer=1)
    public static int waitAny(WaitHandle[] waitHandles, TimeSpan timeout, boolean exitContext) {
        long l2 = (long)timeout.getTotalMilliseconds();
        return WaitHandle.waitAny(waitHandles, (int)l2, exitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReliabilityContractAttribute(consistencyGuarantee=3, cer=1)
    public static int waitAny(WaitHandle[] waitHandles, int timeout, boolean exitContext) {
        int n2;
        if (waitHandles == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i2 = 0; i2 < waitHandles.length; ++i2) {
            if (waitHandles[i2] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)timeout || Integer.MAX_VALUE < (long)timeout) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        for (n2 = 0; n2 < waitHandles.length; ++n2) {
            if (waitHandles[n2].b().getCount() == 0L) {
                waitHandles[n2].a();
                return n2;
            }
            waitHandles[n2].a(countDownLatch);
        }
        try {
            if (timeout == -1) {
                countDownLatch.await();
            } else if (timeout == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        for (n2 = 0; n2 < waitHandles.length; ++n2) {
            Object object = waitHandles[n2].syncObj;
            synchronized (object) {
                if (waitHandles[n2].isReady) {
                    waitHandles[n2].a();
                    return n2;
                }
                continue;
            }
        }
        return 258;
    }

    public boolean waitOne() {
        return this.waitOne(-1, false);
    }

    public boolean waitOne(int timeout) {
        return this.waitOne(timeout, false);
    }

    public boolean waitOne(TimeSpan timeout) {
        return this.waitOne(timeout, false);
    }

    public boolean waitOne(TimeSpan timeout, boolean exitContext) {
        long l2 = (long)timeout.getTotalMilliseconds();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return this.waitOne((int)l2, exitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOne(int timeout, boolean exitContext) {
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        Object object = this.syncObj;
        synchronized (object) {
            boolean bl2 = false;
            if (!this.isReady) {
                try {
                    if (timeout == -1) {
                        this.syncObj.wait();
                        this.a();
                        return true;
                    }
                    this.syncObj.wait(timeout == 0 ? 1L : (long)timeout);
                    bl2 = this.isReady;
                    this.a();
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException.getMessage());
                }
            }
            this.a();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.eventResetMode == 0 && this.isReady) {
                this.isReady = false;
                this.a(new CountDownLatch(1));
            }
        }
    }
}

