/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.core.System.p;
import com.aspose.html.internal.ms.lang.Extensions;
import java.math.BigInteger;

@Extensions
public final class UInt64Extensions {
    public static final long MaxValue = -1L;
    public static final long MinValue = 0L;

    public static int compareTo(long a2, long b2) {
        BigInteger bigInteger = UInt64Extensions.getBigIntegerFromLong(a2);
        BigInteger bigInteger2 = UInt64Extensions.getBigIntegerFromLong(b2);
        return bigInteger.compareTo(bigInteger2);
    }

    public static int compareTo(long a2, Object b2) {
        if (b2 == null) {
            return 1;
        }
        if (b2.getClass() != Long.class) {
            throw new ArgumentException("Object must be of type Int64");
        }
        long l2 = Convert.toUInt64(b2);
        return UInt64Extensions.compareTo(a2, l2);
    }

    public static boolean equals(long a2, long b2) {
        return a2 == b2;
    }

    public static boolean equals(long a2, Object b2) {
        if (b2 == null || b2.getClass() != Long.class) {
            return false;
        }
        return Convert.toUInt64(b2) == a2;
    }

    public static int getHashCode(long a2) {
        return (int)a2 ^ (int)(a2 >> 32);
    }

    public static int getTypeCode() {
        return 12;
    }

    public static boolean tryParse(String source, int numberStyles, IFormatProvider culture, long[] referenceToValue) {
        try {
            referenceToValue[0] = UInt64Extensions.parse(source, numberStyles, culture);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        catch (OverflowException overflowException) {
            return false;
        }
    }

    public static boolean tryParse(String source, long[] referenceToValue) {
        return UInt64Extensions.tryParse(source, 7, NumberFormatInfo.getCurrentInfo(), referenceToValue);
    }

    public static long parse(String source) {
        return p.a(source);
    }

    public static long parse(String source, IFormatProvider provider) {
        return p.a(source, provider);
    }

    public static long parse(String source, int numberStyles) {
        return p.a(source, numberStyles);
    }

    public static long parse(String source, int numberStyles, IFormatProvider provider) {
        return p.a(source, numberStyles, provider);
    }

    public static String toString(long value) {
        return k.b(null, value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(long value, IFormatProvider provider) {
        return k.b(null, value, provider);
    }

    public static String toString(long value, String pattern) {
        return k.b(pattern, value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(long value, String pattern, IFormatProvider provider) {
        return k.b(pattern, value, provider);
    }

    public static BigInteger getBigIntegerFromLong(long value) {
        BigInteger bigInteger;
        if (value >= 0L) {
            bigInteger = BigInteger.valueOf(value);
        } else {
            bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
            bigInteger = bigInteger.add(BigInteger.ONE);
            bigInteger = bigInteger.add(BigInteger.valueOf(Long.MIN_VALUE - value).abs());
        }
        return bigInteger;
    }
}

