/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.AppDomain;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Collections.DictionaryEntry;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Nullable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.Xml.CodeIdentifier;
import com.aspose.html.internal.ms.System.Xml.TypeData;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.System.Xml.XmlElement;
import com.aspose.html.internal.ms.System.Xml.XmlNode;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaPatternFacet;
import com.aspose.html.internal.ms.lang.Operators;

class TypeTranslator {
    static Hashtable nameCache;
    static Hashtable primitiveTypes;
    static Hashtable primitiveArrayTypes;
    static Hashtable nullableTypes;
    static Object AppDomain_TypeTranslatorCacheLock;
    private static final String a = "System.Xml.Serialization.TypeTranslator.nameCache";
    private static final String b = "System.Xml.Serialization.TypeTranslator.nullableTypes";

    TypeTranslator() {
    }

    static Hashtable getAppDomain_nameCache() {
        return TypeTranslator.getAppDomainCache(a);
    }

    static Hashtable getAppDomain_nullableTypes() {
        return TypeTranslator.getAppDomainCache(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hashtable getAppDomainCache(String name) {
        Hashtable hashtable = (Hashtable)AppDomain.getCurrentDomain().getData(name);
        if (hashtable == null) {
            Object object = AppDomain_TypeTranslatorCacheLock;
            synchronized (object) {
                hashtable = (Hashtable)AppDomain.getCurrentDomain().getData(name);
                if (hashtable == null) {
                    hashtable = Hashtable.sync(new Hashtable());
                    AppDomain.getCurrentDomain().setData(name, hashtable);
                }
            }
        }
        return hashtable;
    }

    public static TypeData getTypeData(Type type) {
        return TypeTranslator.getTypeData(type, null);
    }

    public static TypeData getTypeData(Type runtimeType, String xmlDataType) {
        String string;
        TypeData typeData;
        Object object;
        Type type = runtimeType = runtimeType.getUnderlyingSystemType();
        boolean bl2 = false;
        if (type.isGenericType() && type.getGenericTypeDefinition() == Operators.typeOf(Nullable.class)) {
            bl2 = true;
            type = type.getGenericArguments()[0];
        }
        if (xmlDataType != null && xmlDataType.length() != 0) {
            TypeData typeData2 = TypeTranslator.getPrimitiveTypeData(xmlDataType);
            if (type.isArray() && type != typeData2.getType()) {
                TypeData typeData3 = (TypeData)primitiveArrayTypes.get_Item(xmlDataType);
                if (typeData3 != null) {
                    return typeData3;
                }
                if (typeData2.getType() == type.getElementType()) {
                    typeData3 = new TypeData(type, TypeTranslator.getArrayName(typeData2.getXmlType()), false);
                    primitiveArrayTypes.set_Item(xmlDataType, typeData3);
                    return typeData3;
                }
                throw new InvalidOperationException(StringExtensions.concat("Cannot convert values of type '", type.getElementType(), "' to '", xmlDataType, "'"));
            }
            if (bl2) {
                TypeData typeData4 = (TypeData)nullableTypes.get_Item(typeData2.getXmlType());
                if (typeData4 == null) {
                    typeData4 = new TypeData(type, typeData2.getXmlType(), false);
                    typeData4.isNullable(true);
                    nullableTypes.set_Item(typeData2.getXmlType(), typeData4);
                }
                return typeData4;
            }
            return typeData2;
        }
        if (bl2 && (object = TypeTranslator.getTypeData(type)) != null) {
            TypeData typeData5 = (TypeData)nullableTypes.get_Item(((TypeData)object).getXmlType());
            if (typeData5 == null) {
                typeData5 = (TypeData)TypeTranslator.getAppDomain_nullableTypes().get_Item(((TypeData)object).getXmlType());
            }
            if (typeData5 == null) {
                typeData5 = new TypeData(type, ((TypeData)object).getXmlType(), false);
                typeData5.isNullable(true);
                TypeTranslator.getAppDomain_nullableTypes().set_Item(((TypeData)object).getXmlType(), typeData5);
            }
            return typeData5;
        }
        object = nameCache.get_Item(runtimeType);
        TypeData typeData6 = typeData = object instanceof TypeData ? (TypeData)object : null;
        if (typeData != null) {
            return typeData;
        }
        Hashtable hashtable = TypeTranslator.getAppDomain_nameCache();
        Object object2 = hashtable.get_Item(runtimeType);
        TypeData typeData7 = typeData = object2 instanceof TypeData ? (TypeData)object2 : null;
        if (typeData != null) {
            return typeData;
        }
        if (type.isArray()) {
            String string2 = TypeTranslator.getTypeData(type.getElementType()).getXmlType();
            string = TypeTranslator.getArrayName(string2);
        } else if (type.isGenericType() && !type.isGenericTypeDefinition()) {
            string = StringExtensions.concat(XmlConvert.encodeLocalName(StringExtensions.substring(type.getName(), 0, StringExtensions.indexOf(type.getName(), '`'))), "Of");
            for (Type type2 : type.getGenericArguments()) {
                string = StringExtensions.plusEqOperator(string, type2.isArray() || type2.isGenericType() ? TypeTranslator.getTypeData(type2).getXmlType() : CodeIdentifier.makePascal(XmlConvert.encodeLocalName(type2.getName())));
            }
        } else {
            string = XmlConvert.encodeLocalName(type.getName());
        }
        typeData = new TypeData(type, string, false);
        if (bl2) {
            typeData.isNullable(true);
        }
        hashtable.set_Item(runtimeType, typeData);
        return typeData;
    }

    public static boolean isPrimitive(Type type) {
        return TypeTranslator.getTypeData(type).getSchemaType() == 1;
    }

    public static TypeData getPrimitiveTypeData(String typeName) {
        return TypeTranslator.getPrimitiveTypeData(typeName, false);
    }

    public static TypeData getPrimitiveTypeData(String typeName, boolean nullable) {
        TypeData typeData = (TypeData)primitiveTypes.get_Item(typeName);
        if (typeData != null && !typeData.getType().isValueType()) {
            return typeData;
        }
        Hashtable hashtable = nullable && nullableTypes != null ? nullableTypes : primitiveTypes;
        typeData = (TypeData)hashtable.get_Item(typeName);
        if (typeData == null) {
            throw new InvalidOperationException(StringExtensions.concat("Data type '", typeName, "' not supported"));
        }
        return typeData;
    }

    public static TypeData findPrimitiveTypeData(String typeName) {
        return (TypeData)primitiveTypes.get_Item(typeName);
    }

    public static TypeData getDefaultPrimitiveTypeData(TypeData primType) {
        TypeData typeData;
        if (primType.getSchemaType() == 1 && (typeData = TypeTranslator.getTypeData(primType.getType(), null)) != primType) {
            return typeData;
        }
        return primType;
    }

    public static boolean isDefaultPrimitiveTpeData(TypeData primType) {
        return TypeTranslator.getDefaultPrimitiveTypeData(primType) == primType;
    }

    public static TypeData createCustomType(String typeName, String fullTypeName, String xmlType, int schemaType, TypeData listItemTypeData) {
        TypeData typeData = new TypeData(typeName, fullTypeName, xmlType, schemaType, listItemTypeData);
        return typeData;
    }

    public static String getArrayName(String elemName) {
        return StringExtensions.concat("ArrayOf", Character.valueOf(Char.toUpper(elemName.charAt(0), CultureInfo.getInvariantCulture())), StringExtensions.substring(elemName, 1));
    }

    public static String getArrayName(String elemName, int dimensions) {
        String string = TypeTranslator.getArrayName(elemName);
        while (dimensions > 1) {
            string = StringExtensions.concat("ArrayOf", string);
            --dimensions;
        }
        return string;
    }

    public static void parseArrayType(String arrayType, String[] type, String[] ns, String[] dimensions) {
        int n2 = StringExtensions.lastIndexOf(arrayType, ":");
        ns[0] = n2 == -1 ? "" : StringExtensions.substring(arrayType, 0, n2);
        int n3 = StringExtensions.indexOf(arrayType, "[", n2 + 1);
        if (n3 == -1) {
            throw new InvalidOperationException(StringExtensions.concat("Cannot parse WSDL array type: ", arrayType));
        }
        type[0] = StringExtensions.substring(arrayType, n2 + 1, n3 - n2 - 1);
        dimensions[0] = StringExtensions.substring(arrayType, n3);
    }

    static {
        AppDomain_TypeTranslatorCacheLock = new Object();
        nameCache = new Hashtable();
        primitiveArrayTypes = Hashtable.sync(new Hashtable());
        nameCache = Hashtable.sync(nameCache);
        nameCache.addItem(Operators.typeOf(Boolean.class), new TypeData(Operators.typeOf(Boolean.class), "boolean", true));
        nameCache.addItem(Operators.typeOf(Short.class), new TypeData(Operators.typeOf(Short.class), "short", true));
        nameCache.addItem(Operators.typeOf(Integer.class), new TypeData(Operators.typeOf(Integer.class), "int", true));
        nameCache.addItem(Operators.typeOf(Long.class), new TypeData(Operators.typeOf(Long.class), "long", true));
        nameCache.addItem(Operators.typeOf(Float.class), new TypeData(Operators.typeOf(Float.class), "float", true));
        nameCache.addItem(Operators.typeOf(Double.class), new TypeData(Operators.typeOf(Double.class), "double", true));
        nameCache.addItem(Operators.typeOf(DateTime.class), new TypeData(Operators.typeOf(DateTime.class), "dateTime", true));
        nameCache.addItem(Operators.typeOf(Decimal.class), new TypeData(Operators.typeOf(Decimal.class), "decimal", true));
        nameCache.addItem(Operators.typeOf(XmlQualifiedName.class), new TypeData(Operators.typeOf(XmlQualifiedName.class), "QName", true));
        nameCache.addItem(Operators.typeOf(String.class), new TypeData(Operators.typeOf(String.class), "string", true));
        XmlSchemaPatternFacet xmlSchemaPatternFacet = new XmlSchemaPatternFacet();
        xmlSchemaPatternFacet.setValue("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
        nameCache.addItem(Operators.typeOf(Guid.class), new TypeData(Operators.typeOf(Guid.class), "guid", true, (TypeData)nameCache.get_Item(Operators.typeOf(String.class)), xmlSchemaPatternFacet));
        nameCache.addItem(Operators.typeOf(Byte.class), new TypeData(Operators.typeOf(Byte.class), "byte", true));
        nameCache.addItem(Operators.typeOf(Character.class), new TypeData(Operators.typeOf(Character.class), "char", true, (TypeData)nameCache.get_Item(Operators.typeOf(Integer.TYPE).getUnderlyingSystemType()), null));
        nameCache.addItem(Operators.typeOf(Object.class), new TypeData(Operators.typeOf(Object.class), "anyType", false));
        nameCache.addItem(Operators.typeOf(byte[].class), new TypeData(Operators.typeOf(byte[].class), "base64Binary", true));
        nameCache.addItem(Operators.typeOf(XmlNode.class), new TypeData(Operators.typeOf(XmlNode.class), "XmlNode", false));
        nameCache.addItem(Operators.typeOf(XmlElement.class), new TypeData(Operators.typeOf(XmlElement.class), "XmlElement", false));
        primitiveTypes = new Hashtable();
        ICollection iCollection = nameCache.getValues();
        for (Object object : iCollection) {
            primitiveTypes.addItem(((TypeData)object).getXmlType(), object);
        }
        primitiveTypes.addItem("date", new TypeData(Operators.typeOf(DateTime.class), "date", true));
        primitiveTypes.addItem("time", new TypeData(Operators.typeOf(DateTime.class), "time", true));
        primitiveTypes.addItem("timePeriod", new TypeData(Operators.typeOf(DateTime.class), "timePeriod", true));
        primitiveTypes.addItem("gDay", new TypeData(Operators.typeOf(String.class), "gDay", true));
        primitiveTypes.addItem("gMonthDay", new TypeData(Operators.typeOf(String.class), "gMonthDay", true));
        primitiveTypes.addItem("gYear", new TypeData(Operators.typeOf(String.class), "gYear", true));
        primitiveTypes.addItem("gYearMonth", new TypeData(Operators.typeOf(String.class), "gYearMonth", true));
        primitiveTypes.addItem("month", new TypeData(Operators.typeOf(DateTime.class), "month", true));
        primitiveTypes.addItem("NMTOKEN", new TypeData(Operators.typeOf(String.class), "NMTOKEN", true));
        primitiveTypes.addItem("NMTOKENS", new TypeData(Operators.typeOf(String.class), "NMTOKENS", true));
        primitiveTypes.addItem("Name", new TypeData(Operators.typeOf(String.class), "Name", true));
        primitiveTypes.addItem("NCName", new TypeData(Operators.typeOf(String.class), "NCName", true));
        primitiveTypes.addItem("language", new TypeData(Operators.typeOf(String.class), "language", true));
        primitiveTypes.addItem("integer", new TypeData(Operators.typeOf(String.class), "integer", true));
        primitiveTypes.addItem("positiveInteger", new TypeData(Operators.typeOf(String.class), "positiveInteger", true));
        primitiveTypes.addItem("nonPositiveInteger", new TypeData(Operators.typeOf(String.class), "nonPositiveInteger", true));
        primitiveTypes.addItem("negativeInteger", new TypeData(Operators.typeOf(String.class), "negativeInteger", true));
        primitiveTypes.addItem("nonNegativeInteger", new TypeData(Operators.typeOf(String.class), "nonNegativeInteger", true));
        primitiveTypes.addItem("ENTITIES", new TypeData(Operators.typeOf(String.class), "ENTITIES", true));
        primitiveTypes.addItem("ENTITY", new TypeData(Operators.typeOf(String.class), "ENTITY", true));
        primitiveTypes.addItem("hexBinary", new TypeData(Operators.typeOf(byte[].class), "hexBinary", true));
        primitiveTypes.addItem("ID", new TypeData(Operators.typeOf(String.class), "ID", true));
        primitiveTypes.addItem("IDREF", new TypeData(Operators.typeOf(String.class), "IDREF", true));
        primitiveTypes.addItem("IDREFS", new TypeData(Operators.typeOf(String.class), "IDREFS", true));
        primitiveTypes.addItem("NOTATION", new TypeData(Operators.typeOf(String.class), "NOTATION", true));
        primitiveTypes.addItem("token", new TypeData(Operators.typeOf(String.class), "token", true));
        primitiveTypes.addItem("normalizedString", new TypeData(Operators.typeOf(String.class), "normalizedString", true));
        primitiveTypes.addItem("anyURI", new TypeData(Operators.typeOf(String.class), "anyURI", true));
        primitiveTypes.addItem("base64", new TypeData(Operators.typeOf(byte[].class), "base64", true));
        primitiveTypes.addItem("duration", new TypeData(Operators.typeOf(String.class), "duration", true));
        nullableTypes = Hashtable.sync(new Hashtable());
        for (Object object : primitiveTypes) {
            TypeData typeData = (TypeData)((DictionaryEntry)object).getValue();
            TypeData typeData2 = new TypeData(typeData.getType(), typeData.getXmlType(), true);
            typeData2.isNullable(true);
            nullableTypes.addItem(((DictionaryEntry)object).getKey(), typeData2);
        }
    }
}

