/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.Expression;
import com.aspose.html.internal.ms.System.Xml.FunctionArguments;
import com.aspose.html.internal.ms.System.Xml.XPathException;
import com.aspose.html.internal.ms.System.Xml.XPathFunctions;
import com.aspose.html.internal.ms.System.Xml.XPathNodeIterator;
import com.aspose.html.internal.ms.System.Xml.XPathNumericFunction;

class XPathFunctionSum
extends XPathNumericFunction {
    private Expression a;

    public XPathFunctionSum(FunctionArguments args) {
        super(args);
        if (args == null || args.getTail() != null) {
            throw new XPathException("sum takes one arg");
        }
        this.a = args.getArg();
    }

    @Override
    boolean getPeer() {
        return this.a.getPeer();
    }

    @Override
    public Object evaluate(BaseIterator iter) {
        BaseIterator baseIterator = this.a.evaluateNodeSet(iter);
        double d2 = 0.0;
        while (((XPathNodeIterator)baseIterator).moveNext()) {
            d2 += XPathFunctions.toNumber(baseIterator.getCurrent().getValue());
        }
        return d2;
    }

    public String toString() {
        return StringExtensions.concat("sum(", this.a.toString(), ")");
    }
}

