/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.CLSCompliantAttribute;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.DateTimeOffset;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Globalization.DateTimeFormatInfo;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IO.StringWriter;
import com.aspose.html.internal.ms.System.IO.TextWriter;
import com.aspose.html.internal.ms.System.Int16Extensions;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.Int64Extensions;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.System.SByteExtensions;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.UInt16Extensions;
import com.aspose.html.internal.ms.System.UInt32Extensions;
import com.aspose.html.internal.ms.System.UInt64Extensions;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.time.TimeSpan;

public class XmlConvert {
    private static final String a = "_x003A_";
    private static final int b = 423;
    private static final int c = 7;
    static final String[] datetimeFormats = new String[]{"yyyy-MM-ddTHH:mm:sszzz", "yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz", "yyyy-MM-ddTHH:mm:ssZ", "yyyy-MM-ddTHH:mm:ss.FFFFFFFZ", "yyyy-MM-ddTHH:mm:ss", "yyyy-MM-ddTHH:mm:ss.FFFFFFF", "HH:mm:ss", "HH:mm:ss.FFFFFFF", "HH:mm:sszzz", "HH:mm:ss.FFFFFFFzzz", "HH:mm:ssZ", "HH:mm:ss.FFFFFFFZ", "yyyy-MM-dd", "yyyy-MM-ddzzz", "yyyy-MM-ddZ", "yyyy-MM", "yyyy-MMzzz", "yyyy-MMZ", "yyyy", "yyyyzzz", "yyyyZ", "--MM-dd", "--MM-ddzzz", "--MM-ddZ", "---dd", "---ddzzz", "---ddZ"};
    static final String[] defaultDateTimeFormats = new String[]{"yyyy-MM-ddTHH:mm:ss", "yyyy-MM-ddTHH:mm:ss.FFFFFFF", "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM", "yyyy", "--MM-dd", "---dd"};
    static final String[] roundtripDateTimeFormats;
    static final String[] localDateTimeFormats;
    static final String[] utcDateTimeFormats;
    static final String[] unspecifiedDateTimeFormats;
    static int _defaultStyle;
    private static final StringSwitchMap d;
    static final char[] WhitespaceChars;

    private static String a(String string) {
        if (string == null || string.length() < 6) {
            return string;
        }
        char c2 = '\uffff';
        try {
            c2 = (char)Int32Extensions.parse(StringExtensions.substring(string, 1, 4), 515, CultureInfo.getInvariantCulture());
        }
        catch (Exception exception) {
            return StringExtensions.concat(Character.valueOf(string.charAt(0)), XmlConvert.decodeName(StringExtensions.substring(string, 1)));
        }
        if (string.length() == 6) {
            return Char.toString(c2);
        }
        return StringExtensions.concat(Character.valueOf(c2), XmlConvert.decodeName(StringExtensions.substring(string, 6)));
    }

    public static String decodeName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int n2 = StringExtensions.indexOf(name, '_');
        if (n2 == -1 || n2 + 6 >= name.length()) {
            return name;
        }
        if (name.charAt(n2 + 1) != 'X' && name.charAt(n2 + 1) != 'x' || name.charAt(n2 + 6) != '_') {
            return StringExtensions.concat(Character.valueOf(name.charAt(0)), XmlConvert.decodeName(StringExtensions.substring(name, 1)));
        }
        return StringExtensions.concat(StringExtensions.substring(name, 0, n2), XmlConvert.a(StringExtensions.substring(name, n2 + 1)));
    }

    public static String encodeLocalName(String name) {
        if (name == null) {
            return name;
        }
        String string = XmlConvert.encodeName(name);
        int n2 = StringExtensions.indexOf(string, ':');
        if (n2 == -1) {
            return string;
        }
        return StringExtensions.replace(string, ":", a);
    }

    static boolean isInvalid(char c2, boolean firstOnlyLetter) {
        if (c2 == ':') {
            return false;
        }
        if (firstOnlyLetter) {
            return !XmlChar.isFirstNameChar(c2);
        }
        return !XmlChar.isNameChar(c2);
    }

    private static String a(String string, boolean bl2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (XmlConvert.isInvalid(c2, i2 == 0 && !bl2)) {
                msStringBuilder2.appendFormat("_x{0:X4}_", c2);
                continue;
            }
            if (c2 == '_' && i2 + 6 < n2 && string.charAt(i2 + 1) == 'x' && string.charAt(i2 + 6) == '_') {
                msStringBuilder2.append("_x005F_");
                continue;
            }
            msStringBuilder2.append(c2);
        }
        return msStringBuilder2.toString();
    }

    public static String encodeName(String name) {
        return XmlConvert.a(name, false);
    }

    public static String encodeNmToken(String name) {
        if (StringExtensions.equals(name, StringExtensions.Empty)) {
            throw new XmlException("Invalid NmToken: ''");
        }
        return XmlConvert.a(name, true);
    }

    public static boolean toBoolean(String s2) {
        s2 = StringExtensions.trim(s2, XmlChar.WhitespaceChars);
        switch (d.of(s2)) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        throw new FormatException(StringExtensions.concat(s2, " is not a valid boolean value"));
    }

    static String toBinHexString(byte[] buffer) {
        StringWriter stringWriter = new StringWriter();
        XmlConvert.writeBinHex(buffer, 0, buffer.length, stringWriter);
        return stringWriter.toString();
    }

    static void writeBinHex(byte[] buffer, int index, int count, TextWriter w2) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index must be non negative integer.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count must be non negative integer.");
        }
        if (buffer.length < index + count) {
            throw new ArgumentOutOfRangeException("index and count must be smaller than the length of the buffer.");
        }
        int n2 = index + count;
        for (int i2 = index; i2 < n2; ++i2) {
            int n3 = Operators.castToInt32(buffer[i2], 6);
            int n4 = n3 >> 4;
            int n5 = n3 & 0xF;
            if (n4 > 9) {
                w2.write(Operators.castToChar(n4 + 55, 9));
            } else {
                w2.write(Operators.castToChar(n4 + 48, 9));
            }
            if (n5 > 9) {
                w2.write(Operators.castToChar(n5 + 55, 9));
                continue;
            }
            w2.write(Operators.castToChar(n5 + 48, 9));
        }
    }

    public static byte toByte(String s2) {
        return ByteExtensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    public static char toChar(String s2) {
        return Char.parse(s2);
    }

    @Deprecated
    public static DateTime toDateTime(String s2) {
        return XmlConvert.toDateTime(s2, datetimeFormats);
    }

    public static DateTime toDateTime(String value, int mode) {
        DateTime dateTime = new DateTime();
        switch (mode) {
            case 0: {
                XmlConvert.toDateTime(value, localDateTimeFormats).CloneTo(dateTime);
                return new DateTime(dateTime.getTicks(), 2L);
            }
            case 3: {
                return XmlConvert.a(value, roundtripDateTimeFormats, _defaultStyle | 0x80);
            }
            case 1: {
                XmlConvert.toDateTime(value, utcDateTimeFormats).CloneTo(dateTime);
                return new DateTime(dateTime.getTicks(), 1L);
            }
            case 2: {
                return XmlConvert.toDateTime(value, unspecifiedDateTimeFormats);
            }
        }
        return XmlConvert.toDateTime(value, defaultDateTimeFormats);
    }

    public static DateTime toDateTime(String s2, String format) {
        int n2 = 3;
        return DateTime.parseExact(s2, format, (IFormatProvider)DateTimeFormatInfo.getInvariantInfo(), n2);
    }

    public static DateTime toDateTime(String s2, String[] formats) {
        return XmlConvert.a(s2, formats, _defaultStyle);
    }

    private static DateTime a(String string, String[] stringArray, int n2) {
        try {
            return DateTime.parseExact(string, stringArray, (IFormatProvider)DateTimeFormatInfo.getInvariantInfo(), n2);
        }
        catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
            return DateTime.MinValue;
        }
    }

    public static Decimal toDecimal(String s2) {
        return Decimal.parse(s2, CultureInfo.getInvariantCulture());
    }

    public static Decimal toInteger(String s2) {
        return Decimal.parse(s2, 7, NumberFormatInfo.getInvariantInfo());
    }

    public static double toDouble(String s2) {
        if (s2 == null) {
            throw new ArgumentNullException();
        }
        float f2 = XmlConvert.tryParseStringFloatConstants(s2);
        if (f2 != 0.0f) {
            return f2;
        }
        return DoubleExtensions.parse(s2, 423, CultureInfo.getInvariantCulture());
    }

    static float tryParseStringFloatConstants(String s2) {
        int n2;
        for (n2 = 0; n2 < s2.length() && Char.isWhiteSpace(s2.charAt(n2)); ++n2) {
        }
        if (n2 == s2.length()) {
            throw new FormatException();
        }
        int n3 = s2.length() - 1;
        while (Char.isWhiteSpace(s2.charAt(n3))) {
            --n3;
        }
        if (XmlConvert.tryParseStringConstant("NaN", s2, n2, n3)) {
            return Float.NaN;
        }
        if (XmlConvert.tryParseStringConstant("INF", s2, n2, n3)) {
            return Float.POSITIVE_INFINITY;
        }
        if (XmlConvert.tryParseStringConstant("-INF", s2, n2, n3)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (XmlConvert.tryParseStringConstant("Infinity", s2, n2, n3)) {
            return Float.POSITIVE_INFINITY;
        }
        if (XmlConvert.tryParseStringConstant("-Infinity", s2, n2, n3)) {
            return Float.NEGATIVE_INFINITY;
        }
        return 0.0f;
    }

    static boolean tryParseStringConstant(String format, String s2, int start, int end) {
        return end - start + 1 == format.length() && StringExtensions.compareOrdinal(format, 0, s2, start, format.length()) == 0;
    }

    public static Guid toGuid(String s2) {
        try {
            return new Guid(s2);
        }
        catch (FormatException formatException) {
            throw new FormatException(StringExtensions.format("Invalid Guid input '{0}'", formatException.getInnerException()));
        }
    }

    public static short toInt16(String s2) {
        return Int16Extensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    public static int toInt32(String s2) {
        return Int32Extensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    public static long toInt64(String s2) {
        return Int64Extensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static byte toSByte(String s2) {
        return SByteExtensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    public static float toSingle(String s2) {
        if (s2 == null) {
            throw new ArgumentNullException();
        }
        float f2 = XmlConvert.tryParseStringFloatConstants(s2);
        if (f2 != 0.0f) {
            return f2;
        }
        return SingleExtensions.parse(s2, 423, CultureInfo.getInvariantCulture());
    }

    public static String toString_Guid(Guid value) {
        return value.toString("D", CultureInfo.getInvariantCulture());
    }

    public static String toString_Int32(int value) {
        return Int32Extensions.toString(value, CultureInfo.getInvariantCulture());
    }

    public static String toString_Int16(short value) {
        return Int16Extensions.toString(value, CultureInfo.getInvariantCulture());
    }

    public static String toString_Byte(byte value) {
        return ByteExtensions.toString(value, CultureInfo.getInvariantCulture());
    }

    public static String toString_Int64(long value) {
        return Int64Extensions.toString(value, CultureInfo.getInvariantCulture());
    }

    public static String toString_Char(char value) {
        return Char.toString(value, CultureInfo.getInvariantCulture());
    }

    public static String toString_Bool(boolean value) {
        if (value) {
            return "true";
        }
        return "false";
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static String toString_SByte(byte value) {
        return SByteExtensions.toString(value, CultureInfo.getInvariantCulture());
    }

    public static String toString_Decimal(Decimal value) {
        return value.toString(CultureInfo.getInvariantCulture());
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static String toString_UInt64(long value) {
        return UInt64Extensions.toString(value, CultureInfo.getInvariantCulture());
    }

    public static String toString_TimeSpan(TimeSpan value) {
        if (TimeSpan.op_Equality(value, TimeSpan.Zero)) {
            return "PT0S";
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if (value.getTicks() < 0L) {
            if (TimeSpan.op_Equality(value, TimeSpan.MinValue)) {
                return "-P10675199DT2H48M5.4775808S";
            }
            msStringBuilder2.append('-');
            value.negate().CloneTo(value);
        }
        msStringBuilder2.append('P');
        if (value.getDays() > 0) {
            msStringBuilder2.append(value.getDays()).append('D');
        }
        long l2 = value.getTicks() % 10000L;
        if (value.getDays() > 0 || value.getHours() > 0 || value.getMinutes() > 0 || value.getSeconds() > 0 || value.getMilliseconds() > 0 || l2 > 0L) {
            msStringBuilder2.append('T');
            if (value.getHours() > 0) {
                msStringBuilder2.append(value.getHours()).append('H');
            }
            if (value.getMinutes() > 0) {
                msStringBuilder2.append(value.getMinutes()).append('M');
            }
            if (value.getSeconds() > 0 || value.getMilliseconds() > 0 || l2 > 0L) {
                msStringBuilder2.append(value.getSeconds());
                boolean bl2 = true;
                if (l2 > 0L) {
                    msStringBuilder2.append('.').appendFormat("{0:0000000}", value.getTicks() % 10000000L);
                } else if (value.getMilliseconds() > 0) {
                    msStringBuilder2.append('.').appendFormat("{0:000}", value.getMilliseconds());
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    while (msStringBuilder2.get_Char(msStringBuilder2.getLength() - 1) == '0') {
                        msStringBuilder2.remove(msStringBuilder2.getLength() - 1, 1);
                    }
                }
                msStringBuilder2.append('S');
            }
        }
        return msStringBuilder2.toString();
    }

    public static String toString_Double(double value) {
        if (DoubleExtensions.isNegativeInfinity(value)) {
            return "-INF";
        }
        if (DoubleExtensions.isPositiveInfinity(value)) {
            return "INF";
        }
        if (DoubleExtensions.isNaN(value)) {
            return "NaN";
        }
        return DoubleExtensions.toString(value, "R", CultureInfo.getInvariantCulture());
    }

    public static String toString_Float(float value) {
        if (SingleExtensions.isNegativeInfinity(value)) {
            return "-INF";
        }
        if (SingleExtensions.isPositiveInfinity(value)) {
            return "INF";
        }
        if (SingleExtensions.isNaN(value)) {
            return "NaN";
        }
        return SingleExtensions.toString(value, "R", CultureInfo.getInvariantCulture());
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static String toString_UInt32(long value) {
        return UInt32Extensions.toString(value, CultureInfo.getInvariantCulture());
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static String toString_UInt16(int value) {
        return UInt16Extensions.toString(value, CultureInfo.getInvariantCulture());
    }

    @Deprecated
    public static String toString_DateTime(DateTime value) {
        return value.toString("yyyy-MM-ddTHH:mm:ss.fffffffzzz", CultureInfo.getInvariantCulture());
    }

    public static String toString_DateTime(DateTime value, int mode) {
        switch (mode) {
            case 0: {
                return (DateTime.op_Equality(value, DateTime.MinValue) ? DateTime.MinValue : (DateTime.op_Equality(value, DateTime.MaxValue) ? value : value.toLocalTime())).toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz", CultureInfo.getInvariantCulture());
            }
            case 3: {
                return value.toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFK", CultureInfo.getInvariantCulture());
            }
            default: {
                return value.toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz", CultureInfo.getInvariantCulture());
            }
            case 1: {
                return (DateTime.op_Equality(value, DateTime.MinValue) ? DateTime.MinValue : (DateTime.op_Equality(value, DateTime.MaxValue) ? value : value.toUniversalTime())).toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFZ", CultureInfo.getInvariantCulture());
            }
            case 2: 
        }
        return value.toString("yyyy-MM-ddTHH:mm:ss.FFFFFFF", CultureInfo.getInvariantCulture());
    }

    public static String toString_DateTime(DateTime value, String format) {
        return value.toString(format, CultureInfo.getInvariantCulture());
    }

    public static TimeSpan toTimeSpan(String s2) {
        boolean bl2;
        if ((s2 = StringExtensions.trim(s2, XmlChar.WhitespaceChars)).length() == 0) {
            throw new FormatException("Invalid format string for duration schema datatype.");
        }
        int n2 = 0;
        if (s2.charAt(0) == '-') {
            n2 = 1;
        }
        boolean bl3 = bl2 = n2 == 1;
        if (s2.charAt(n2) != 'P') {
            throw new FormatException("Invalid format string for duration schema datatype.");
        }
        ++n2;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        long l2 = 0L;
        int n8 = 0;
        boolean bl5 = false;
        int n9 = n2;
        while (n9 < s2.length()) {
            if (s2.charAt(n9) == 'T') {
                bl4 = true;
                n3 = 4;
                n2 = ++n9;
                continue;
            }
            while (n9 < s2.length() && s2.charAt(n9) >= '0' && '9' >= s2.charAt(n9)) {
                ++n9;
            }
            if (n3 == 7) {
                n8 = n9 - n2;
            }
            int n10 = Int32Extensions.parse(StringExtensions.substring(s2, n2, n9 - n2), CultureInfo.getInvariantCulture());
            if (n3 == 7) {
                while (n8 > 7) {
                    n10 /= 10;
                    --n8;
                }
                while (n8 < 7) {
                    n10 *= 10;
                    ++n8;
                }
            }
            switch (s2.charAt(n9)) {
                case 'Y': {
                    n4 += n10 * 365;
                    if (n3 > 0) {
                        bl5 = true;
                        break;
                    }
                    n3 = 1;
                    break;
                }
                case 'M': {
                    if (n3 < 2) {
                        n4 += 365 * (n10 / 12) + 30 * (n10 % 12);
                        n3 = 2;
                        break;
                    }
                    if (bl4 && n3 < 6) {
                        n6 = n10;
                        n3 = 6;
                        break;
                    }
                    bl5 = true;
                    break;
                }
                case 'D': {
                    n4 += n10;
                    if (n3 > 2) {
                        bl5 = true;
                        break;
                    }
                    n3 = 3;
                    break;
                }
                case 'H': {
                    n5 = n10;
                    if (!bl4 || n3 > 4) {
                        bl5 = true;
                        break;
                    }
                    n3 = 5;
                    break;
                }
                case 'S': {
                    if (n3 == 7) {
                        l2 = n10;
                    } else {
                        n7 = n10;
                    }
                    if (!bl4 || n3 > 7) {
                        bl5 = true;
                        break;
                    }
                    n3 = 8;
                    break;
                }
                case '.': {
                    if (n3 > 7) {
                        bl5 = true;
                    }
                    n7 = n10;
                    n3 = 7;
                    break;
                }
                default: {
                    bl5 = true;
                }
            }
            if (bl5) break;
            n2 = ++n9;
        }
        if (bl5) {
            throw new FormatException("Invalid format string for duration schema datatype.");
        }
        TimeSpan timeSpan = new TimeSpan(n4, n5, n6, n7);
        if (bl2) {
            return TimeSpan.fromTicks(-(timeSpan.getTicks() + l2));
        }
        return TimeSpan.fromTicks(timeSpan.getTicks() + l2);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static int toUInt16(String s2) {
        return UInt16Extensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long toUInt32(String s2) {
        return UInt32Extensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long toUInt64(String s2) {
        return UInt64Extensions.parse(s2, 7, CultureInfo.getInvariantCulture());
    }

    public static String verifyName(String name) {
        if (name == null || name.length() == 0) {
            throw new ArgumentNullException("name");
        }
        if (!XmlChar.isName(name)) {
            throw new XmlException(StringExtensions.concat("'", name, "' is not a valid XML Name"));
        }
        return name;
    }

    public static String verifyNCName(String ncname) {
        if (ncname == null || ncname.length() == 0) {
            throw new ArgumentNullException("ncname");
        }
        if (!XmlChar.isNCName(ncname)) {
            throw new XmlException(StringExtensions.concat("'", ncname, "' is not a valid XML NCName"));
        }
        return ncname;
    }

    public static String verifyTOKEN(String name) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (name.length() == 0) {
            return name;
        }
        if (XmlChar.isWhitespace(name.charAt(0)) || XmlChar.isWhitespace(name.charAt(name.length() - 1))) {
            throw new XmlException("Whitespace characters (#xA, #xD, #x9, #x20) are not allowed as leading or trailing whitespaces of xs:token.");
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            if (!XmlChar.isWhitespace(name.charAt(i2)) || name.charAt(i2) == ' ') continue;
            throw new XmlException("Either #xA, #xD or #x9 are not allowed inside xs:token.");
        }
        return name;
    }

    public static String verifyNMTOKEN(String name) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (!XmlChar.isNmToken(name)) {
            throw new XmlException(StringExtensions.concat("'", name, "' is not a valid XML NMTOKEN"));
        }
        return name;
    }

    static byte[] fromBinHexString(String s2) {
        char[] cArray = StringExtensions.toCharArray(s2);
        byte[] byArray = new byte[cArray.length / 2 + cArray.length % 2];
        XmlConvert.fromBinHexString(cArray, 0, cArray.length, byArray);
        return byArray;
    }

    static int fromBinHexString(char[] chars, int offset, int charLength, byte[] buffer) {
        int n2 = offset;
        for (int i2 = 0; i2 < charLength - 1; i2 += 2) {
            buffer[n2] = chars[i2] > '9' ? Operators.castToByte(chars[i2] - 65 + 10, 9) : Operators.castToByte(chars[i2] - 48, 9);
            buffer[n2] = (byte)(Operators.castToInt32(buffer[n2], 6) << 4);
            buffer[n2] = (byte)(Operators.castToInt32(buffer[n2], 6) + Operators.castToInt32(chars[i2 + 1] > '9' ? Operators.castToByte(chars[i2 + 1] - 65 + 10, 9) : Operators.castToByte(chars[i2 + 1] - 48, 9), 6));
            ++n2;
        }
        if (charLength % 2 != 0) {
            buffer[n2++] = Operators.castToByte(Operators.castToInt32(chars[charLength - 1] > '9' ? Operators.castToByte(chars[charLength - 1] - 65 + 10, 9) : Operators.castToByte(chars[charLength - 1] - 48, 9), 6) << 4, 9);
        }
        return n2 - offset;
    }

    public static DateTimeOffset toDateTimeOffset(String s2) {
        return XmlConvert.toDateTimeOffset(s2, datetimeFormats);
    }

    public static DateTimeOffset toDateTimeOffset(String s2, String format) {
        return DateTimeOffset.parseExact(s2, format, (IFormatProvider)CultureInfo.getInvariantCulture(), 64);
    }

    public static DateTimeOffset toDateTimeOffset(String s2, String[] formats) {
        int n2 = 67;
        return DateTimeOffset.parseExact(s2, formats, (IFormatProvider)CultureInfo.getInvariantCulture(), n2);
    }

    public static String toString_DateTimeOffset(DateTimeOffset value) {
        return XmlConvert.toString_DateTimeOffset(value.Clone(), "yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz");
    }

    public static String toString_DateTimeOffset(DateTimeOffset value, String format) {
        return value.toString(format, CultureInfo.getInvariantCulture());
    }

    static Uri toUri(String s2) {
        return new Uri(s2, 0);
    }

    static Double toXPathDouble(Object o2) {
        String string = Operators.as(o2, String.class);
        if (string != null) {
            if ((string = XmlConvert.trimString(string)).length() != 0 && string.charAt(0) != '+') {
                double[] dArray = new double[1];
                if (DoubleExtensions.tryParse(string, 38, NumberFormatInfo.getInvariantInfo(), dArray)) {
                    return dArray[0];
                }
            }
            return Double.NaN;
        }
        if (o2 instanceof Double) {
            return (Double)o2;
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2 != false ? 1.0 : 0.0;
        }
        try {
            return Convert.toDouble(o2, (IFormatProvider)NumberFormatInfo.getInvariantInfo());
        }
        catch (FormatException formatException) {
        }
        catch (OverflowException overflowException) {
        }
        catch (ArgumentNullException argumentNullException) {
            // empty catch block
        }
        return Double.NaN;
    }

    static String trimString(String value) {
        return StringExtensions.trim(value, WhitespaceChars);
    }

    static {
        _defaultStyle = 3;
        int n2 = defaultDateTimeFormats.length;
        roundtripDateTimeFormats = new String[n2 * 2];
        localDateTimeFormats = new String[n2 * 2];
        utcDateTimeFormats = new String[n2 * 3];
        unspecifiedDateTimeFormats = new String[n2 * 5];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = defaultDateTimeFormats[i2];
            String string2 = StringExtensions.concat(string, Character.valueOf('Z'));
            XmlConvert.localDateTimeFormats[i2 * 2] = StringExtensions.concat(string, string.charAt(string.length() - 1) == 's' || string.charAt(string.length() - 1) == 'F' ? "zzz" : StringExtensions.Empty);
            XmlConvert.localDateTimeFormats[i2 * 2 + 1] = string2;
            XmlConvert.roundtripDateTimeFormats[i2 * 2] = StringExtensions.concat(string, Character.valueOf('K'));
            XmlConvert.roundtripDateTimeFormats[i2 * 2 + 1] = string2;
            XmlConvert.utcDateTimeFormats[i2 * 3] = string;
            XmlConvert.utcDateTimeFormats[i2 * 3 + 1] = string2;
            XmlConvert.utcDateTimeFormats[i2 * 3 + 2] = StringExtensions.concat(string, "zzz");
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5] = string;
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 1] = string2;
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 2] = localDateTimeFormats[i2];
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 3] = roundtripDateTimeFormats[i2];
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 4] = utcDateTimeFormats[i2];
        }
        d = new StringSwitchMap("1", "true", "0", "false");
        WhitespaceChars = new char[]{' ', '\t', '\n', '\r'};
    }
}

