/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StringWriter;
import com.aspose.html.internal.ms.System.IO.TextReader;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.Xml.IXmlLineInfo;
import com.aspose.html.internal.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.internal.ms.System.Xml.NameTable;
import com.aspose.html.internal.ms.System.Xml.SubtreeXmlReader;
import com.aspose.html.internal.ms.System.Xml.XQueryConvert;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlFilterReader;
import com.aspose.html.internal.ms.System.Xml.XmlNameTable;
import com.aspose.html.internal.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.internal.ms.System.Xml.XmlNodeType;
import com.aspose.html.internal.ms.System.Xml.XmlParserContext;
import com.aspose.html.internal.ms.System.Xml.XmlReaderBinarySupport;
import com.aspose.html.internal.ms.System.Xml.XmlReaderSettings;
import com.aspose.html.internal.ms.System.Xml.XmlTextReader;
import com.aspose.html.internal.ms.System.Xml.XmlTextWriter;
import com.aspose.html.internal.ms.lang.Operators;

public abstract class XmlReader
implements IDisposable {
    private msStringBuilder a;
    private XmlReaderBinarySupport b;
    private XmlReaderSettings c;

    protected XmlReader() {
    }

    public abstract int getAttributeCount();

    public abstract String getBaseURI();

    XmlReaderBinarySupport getBinary() {
        return this.b;
    }

    XmlReaderBinarySupport.CharGetter getBinaryCharGetter() {
        return this.b != null ? this.b.getGetter() : null;
    }

    void setBinaryCharGetter(XmlReaderBinarySupport.CharGetter value) {
        if (this.b == null) {
            this.b = new XmlReaderBinarySupport(this);
        }
        this.b.setGetter(value);
    }

    public boolean canReadBinaryContent() {
        return false;
    }

    public boolean canReadValueChunk() {
        return false;
    }

    public boolean canResolveEntity() {
        return false;
    }

    public abstract int getDepth();

    public abstract boolean getEOF();

    public boolean hasAttributes() {
        return this.getAttributeCount() > 0;
    }

    public abstract boolean hasValue();

    public abstract boolean isEmptyElement();

    public boolean isDefault() {
        return false;
    }

    public String get_Item(int i2) {
        return this.getAttribute(i2);
    }

    public String get_Item(String name) {
        return this.getAttribute(name);
    }

    public String get_Item(String name, String namespaceURI) {
        return this.getAttribute(name, namespaceURI);
    }

    public abstract String getLocalName();

    public String getName() {
        return this.getPrefix().length() > 0 ? StringExtensions.concat(this.getPrefix(), ":", this.getLocalName()) : this.getLocalName();
    }

    public abstract String getNamespaceURI();

    public abstract XmlNameTable getNameTable();

    public abstract int getNodeType();

    public abstract String getPrefix();

    public char getQuoteChar() {
        return '\"';
    }

    public abstract int getReadState();

    public IXmlSchemaInfo getSchemaInfo() {
        return null;
    }

    public XmlReaderSettings getSettings() {
        return this.c;
    }

    public abstract String getValue();

    public String getXmlLang() {
        return StringExtensions.Empty;
    }

    public int getXmlSpace() {
        return 0;
    }

    public abstract void close();

    private static XmlNameTable a(XmlReaderSettings xmlReaderSettings) {
        XmlNameTable xmlNameTable = xmlReaderSettings.getNameTable();
        if (xmlNameTable == null) {
            xmlNameTable = new NameTable();
        }
        return xmlNameTable;
    }

    private static XmlParserContext a(XmlReaderSettings xmlReaderSettings, String string) {
        XmlNameTable xmlNameTable = XmlReader.a(xmlReaderSettings);
        return new XmlParserContext(xmlNameTable, new XmlNamespaceManager(xmlNameTable), null, null, null, null, string, null, 0, null);
    }

    private static int b(XmlReaderSettings xmlReaderSettings) {
        int n2 = xmlReaderSettings != null ? xmlReaderSettings.getConformanceLevel() : 0;
        return n2 == 1 ? 1 : 9;
    }

    public static XmlReader create(Stream stream) {
        return XmlReader.create(stream, null);
    }

    public static XmlReader create(String url) {
        return XmlReader.create(url, null);
    }

    public static XmlReader create(TextReader reader) {
        return XmlReader.create(reader, null);
    }

    public static XmlReader create(String url, XmlReaderSettings settings) {
        return XmlReader.create(url, settings, null);
    }

    public static XmlReader create(Stream stream, XmlReaderSettings settings) {
        return XmlReader.create(stream, settings, StringExtensions.Empty);
    }

    public static XmlReader create(TextReader reader, XmlReaderSettings settings) {
        return XmlReader.create(reader, settings, StringExtensions.Empty);
    }

    static XmlReaderSettings populateSettings(XmlReaderSettings src) {
        if (src == null) {
            return new XmlReaderSettings();
        }
        return src.deepClone();
    }

    public static XmlReader create(Stream stream, XmlReaderSettings settings, String baseUri) {
        settings = XmlReader.populateSettings(settings);
        return XmlReader.create(stream, settings, XmlReader.a(settings, baseUri));
    }

    public static XmlReader create(TextReader reader, XmlReaderSettings settings, String baseUri) {
        settings = XmlReader.populateSettings(settings);
        return XmlReader.create(reader, settings, XmlReader.a(settings, baseUri));
    }

    public static XmlReader create(XmlReader reader, XmlReaderSettings settings) {
        settings = XmlReader.populateSettings(settings);
        XmlReader xmlReader = XmlReader.a(reader, settings);
        xmlReader.c = settings;
        return xmlReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlReader create(String url, XmlReaderSettings settings, XmlParserContext context) {
        settings = XmlReader.populateSettings(settings);
        boolean bl2 = settings.getCloseInput();
        try {
            XmlReader xmlReader;
            settings.setCloseInput(true);
            if (context == null) {
                context = XmlReader.a(settings, url);
            }
            XmlTextReader xmlTextReader = new XmlTextReader(false, settings.getXmlResolver(), url, XmlReader.b(settings), context);
            XmlReader xmlReader2 = xmlReader = XmlReader.a(xmlTextReader, settings);
            return xmlReader2;
        }
        finally {
            settings.setCloseInput(bl2);
        }
    }

    public static XmlReader create(Stream stream, XmlReaderSettings settings, XmlParserContext context) {
        settings = XmlReader.populateSettings(settings);
        if (context == null) {
            context = XmlReader.a(settings, StringExtensions.Empty);
        }
        return XmlReader.a(new XmlTextReader(stream, XmlReader.b(settings), context), settings);
    }

    public static XmlReader create(TextReader reader, XmlReaderSettings settings, XmlParserContext context) {
        settings = XmlReader.populateSettings(settings);
        if (context == null) {
            context = XmlReader.a(settings, StringExtensions.Empty);
        }
        return XmlReader.a(new XmlTextReader(context.getBaseURI(), reader, XmlReader.b(settings), context), settings);
    }

    private static XmlReader a(XmlTextReader xmlTextReader, XmlReaderSettings xmlReaderSettings) {
        xmlTextReader.setXmlResolver(xmlReaderSettings.getXmlResolver());
        xmlTextReader.setNormalization(true);
        xmlTextReader.setEntityHandling(1);
        if (xmlReaderSettings.getProhibitDtd()) {
            xmlTextReader.setProhibitDtd(true);
        }
        if (!xmlReaderSettings.getCheckCharacters()) {
            xmlTextReader.setCharacterChecking(false);
        }
        xmlTextReader.setCloseInput(xmlReaderSettings.getCloseInput());
        xmlTextReader.setConformance(xmlReaderSettings.getConformanceLevel());
        xmlTextReader.adjustLineInfoOffset(xmlReaderSettings.getLineNumberOffset(), xmlReaderSettings.getLinePositionOffset());
        if (xmlReaderSettings.getNameTable() != null) {
            xmlTextReader.setNameTable(xmlReaderSettings.getNameTable());
        }
        XmlReader xmlReader = XmlReader.a((XmlReader)xmlTextReader, xmlReaderSettings);
        xmlReader.c = xmlReaderSettings;
        return xmlReader;
    }

    private static XmlReader a(XmlReader xmlReader, XmlReaderSettings xmlReaderSettings) {
        int n2 = 0;
        n2 = xmlReader instanceof XmlTextReader ? ((XmlTextReader)xmlReader).getConformance() : (xmlReader.getSettings() != null ? xmlReader.getSettings().getConformanceLevel() : xmlReaderSettings.getConformanceLevel());
        if (xmlReaderSettings.getConformanceLevel() != 0 && n2 != xmlReaderSettings.getConformanceLevel()) {
            throw new InvalidOperationException(StringExtensions.format("ConformanceLevel cannot be overwritten by a wrapping XmlReader. The source reader has {0}, while {1} is specified.", n2, xmlReaderSettings.getConformanceLevel()));
        }
        xmlReaderSettings.setConformanceLevel(n2);
        xmlReader = XmlReader.b(xmlReader, xmlReaderSettings);
        if (xmlReaderSettings.getIgnoreComments() || xmlReaderSettings.getIgnoreProcessingInstructions() || xmlReaderSettings.getIgnoreWhitespace()) {
            return new XmlFilterReader(xmlReader, xmlReaderSettings);
        }
        xmlReader.c = xmlReaderSettings;
        return xmlReader;
    }

    private static XmlReader b(XmlReader xmlReader, XmlReaderSettings xmlReaderSettings) {
        return xmlReader;
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    protected void dispose(boolean disposing) {
        if (this.getReadState() != 4) {
            this.close();
        }
    }

    public abstract String getAttribute(int var1);

    public abstract String getAttribute(String var1);

    public abstract String getAttribute(String var1, String var2);

    public static boolean isName(String s2) {
        return s2 != null && XmlChar.isName(s2);
    }

    public static boolean isNameToken(String s2) {
        return s2 != null && XmlChar.isNmToken(s2);
    }

    public boolean isStartElement() {
        return this.moveToContent() == 1;
    }

    public boolean isStartElement(String name) {
        if (!this.isStartElement()) {
            return false;
        }
        return StringExtensions.equals(this.getName(), name);
    }

    public boolean isStartElement(String localName, String namespaceName) {
        if (!this.isStartElement()) {
            return false;
        }
        return StringExtensions.equals(this.getLocalName(), localName) && StringExtensions.equals(this.getNamespaceURI(), namespaceName);
    }

    public abstract String lookupNamespace(String var1);

    public void moveToAttribute(int i2) {
        if (i2 >= this.getAttributeCount()) {
            throw new ArgumentOutOfRangeException();
        }
        this.moveToFirstAttribute();
        for (int i3 = 0; i3 < i2; ++i3) {
            this.moveToNextAttribute();
        }
    }

    public abstract boolean moveToAttribute(String var1);

    public abstract boolean moveToAttribute(String var1, String var2);

    private boolean a(int n2) {
        switch (n2) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 1: {
                return true;
            }
            case 15: {
                return true;
            }
            case 5: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        return false;
    }

    public int moveToContent() {
        switch (this.getReadState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return this.getNodeType();
            }
        }
        if (this.getNodeType() == 2) {
            this.moveToElement();
        }
        do {
            if (this.a(this.getNodeType())) {
                return this.getNodeType();
            }
            this.read();
        } while (!this.getEOF());
        return 0;
    }

    public abstract boolean moveToElement();

    public abstract boolean moveToFirstAttribute();

    public abstract boolean moveToNextAttribute();

    public abstract boolean read();

    public abstract boolean readAttributeValue();

    public String readElementString() {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        String string = StringExtensions.Empty;
        if (!this.isEmptyElement()) {
            this.read();
            string = this.readString();
            if (this.getNodeType() != 15) {
                String string2 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
                throw this.a(string2);
            }
        }
        this.read();
        return string;
    }

    public String readElementString(String name) {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        if (!StringExtensions.equals(name, this.getName())) {
            String string = StringExtensions.format("The {0} tag from namespace {1} is expected.", this.getName(), this.getNamespaceURI());
            throw this.a(string);
        }
        String string = StringExtensions.Empty;
        if (!this.isEmptyElement()) {
            this.read();
            string = this.readString();
            if (this.getNodeType() != 15) {
                String string2 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
                throw this.a(string2);
            }
        }
        this.read();
        return string;
    }

    public String readElementString(String localName, String namespaceName) {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        if (!StringExtensions.equals(localName, this.getLocalName()) || !StringExtensions.equals(this.getNamespaceURI(), namespaceName)) {
            String string = StringExtensions.format("The {0} tag from namespace {1} is expected.", this.getLocalName(), this.getNamespaceURI());
            throw this.a(string);
        }
        String string = StringExtensions.Empty;
        if (!this.isEmptyElement()) {
            this.read();
            string = this.readString();
            if (this.getNodeType() != 15) {
                String string2 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
                throw this.a(string2);
            }
        }
        this.read();
        return string;
    }

    public void readEndElement() {
        if (this.moveToContent() != 15) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        this.read();
    }

    public String readInnerXml() {
        if (this.getReadState() != 1 || this.getNodeType() == 15) {
            return StringExtensions.Empty;
        }
        if (this.isEmptyElement()) {
            this.read();
            return StringExtensions.Empty;
        }
        StringWriter stringWriter = new StringWriter();
        XmlTextWriter xmlTextWriter = new XmlTextWriter(stringWriter);
        if (this.getNodeType() == 1) {
            int n2 = this.getDepth();
            this.read();
            while (n2 < this.getDepth()) {
                if (this.getReadState() != 1) {
                    throw this.a("Unexpected end of the XML reader.");
                }
                xmlTextWriter.writeNode(this, false);
            }
            this.read();
        } else {
            xmlTextWriter.writeNode(this, false);
        }
        return stringWriter.toString();
    }

    public String readOuterXml() {
        if (this.getReadState() != 1 || this.getNodeType() == 15) {
            return StringExtensions.Empty;
        }
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                StringWriter stringWriter = new StringWriter();
                XmlTextWriter xmlTextWriter = new XmlTextWriter(stringWriter);
                xmlTextWriter.writeNode(this, false);
                return stringWriter.toString();
            }
        }
        this.skip();
        return StringExtensions.Empty;
    }

    public void readStartElement() {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        this.read();
    }

    public void readStartElement(String name) {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        if (!StringExtensions.equals(name, this.getName())) {
            String string = StringExtensions.format("The {0} tag from namespace {1} is expected.", this.getName(), this.getNamespaceURI());
            throw this.a(string);
        }
        this.read();
    }

    public void readStartElement(String localName, String namespaceName) {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        if (!StringExtensions.equals(localName, this.getLocalName()) || !StringExtensions.equals(this.getNamespaceURI(), namespaceName)) {
            String string = StringExtensions.format("Expecting {0} tag from namespace {1}, got {2} and {3} instead", localName, namespaceName, this.getLocalName(), this.getNamespaceURI());
            throw this.a(string);
        }
        this.read();
    }

    public String readString() {
        if (this.a == null) {
            this.a = new msStringBuilder();
        }
        this.a.setLength(0);
        this.moveToElement();
        switch (this.getNodeType()) {
            default: {
                return StringExtensions.Empty;
            }
            case 1: {
                if (this.isEmptyElement()) {
                    return StringExtensions.Empty;
                }
                block10: while (true) {
                    this.read();
                    switch (this.getNodeType()) {
                        case 3: 
                        case 4: 
                        case 13: 
                        case 14: {
                            this.a.append(this.getValue());
                            continue block10;
                        }
                    }
                    break;
                }
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                block11: while (true) {
                    switch (this.getNodeType()) {
                        case 3: 
                        case 4: 
                        case 13: 
                        case 14: {
                            this.a.append(this.getValue());
                            this.read();
                            continue block11;
                        }
                    }
                    break;
                }
                break;
            }
        }
        String string = this.a.toString();
        this.a.setLength(0);
        return string;
    }

    public Type getValueType() {
        return Operators.typeOf(String.class);
    }

    public boolean readToDescendant(String name) {
        if (this.getReadState() == 0) {
            this.moveToContent();
            if (this.isStartElement(name)) {
                return true;
            }
        }
        if (this.getNodeType() != 1 || this.isEmptyElement()) {
            return false;
        }
        int n2 = this.getDepth();
        this.read();
        while (n2 < this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(name, this.getName())) {
                return true;
            }
            this.read();
        }
        return false;
    }

    public boolean readToDescendant(String localName, String namespaceURI) {
        if (this.getReadState() == 0) {
            this.moveToContent();
            if (this.isStartElement(localName, namespaceURI)) {
                return true;
            }
        }
        if (this.getNodeType() != 1 || this.isEmptyElement()) {
            return false;
        }
        int n2 = this.getDepth();
        this.read();
        while (n2 < this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(localName, this.getLocalName()) && StringExtensions.equals(namespaceURI, this.getNamespaceURI())) {
                return true;
            }
            this.read();
        }
        return false;
    }

    public boolean readToFollowing(String name) {
        while (this.read()) {
            if (this.getNodeType() != 1 || !StringExtensions.equals(name, this.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean readToFollowing(String localName, String namespaceURI) {
        while (this.read()) {
            if (this.getNodeType() != 1 || !StringExtensions.equals(localName, this.getLocalName()) || !StringExtensions.equals(namespaceURI, this.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    public boolean readToNextSibling(String name) {
        if (this.getReadState() != 1) {
            return false;
        }
        this.moveToElement();
        int n2 = this.getDepth();
        this.skip();
        while (!this.getEOF() && n2 <= this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(name, this.getName())) {
                return true;
            }
            this.skip();
        }
        return false;
    }

    public boolean readToNextSibling(String localName, String namespaceURI) {
        if (this.getReadState() != 1) {
            return false;
        }
        int n2 = this.getDepth();
        this.skip();
        while (!this.getEOF() && n2 <= this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(localName, this.getLocalName()) && StringExtensions.equals(namespaceURI, this.getNamespaceURI())) {
                return true;
            }
            this.skip();
        }
        return false;
    }

    public XmlReader readSubtree() {
        if (this.getNodeType() != 1) {
            throw new InvalidOperationException(StringExtensions.format("ReadSubtree() can be invoked only when the reader is positioned on an element. Current node is {0}. {1}", this.getNodeType(), this.b()));
        }
        return new SubtreeXmlReader(this);
    }

    private String a() {
        if (this.getNodeType() == 2 || this.getNodeType() != 1 && this.hasAttributes()) {
            return this.getValue();
        }
        return this.a(true);
    }

    private String a(boolean bl2) {
        if (bl2) {
            switch (this.getNodeType()) {
                case 3: 
                case 4: 
                case 13: 
                case 14: {
                    break;
                }
                case 1: {
                    throw new InvalidOperationException(StringExtensions.format("Node type {0} is not supported in this operation.{1}", this.getNodeType(), this.b()));
                }
                default: {
                    return StringExtensions.Empty;
                }
            }
        }
        String string = StringExtensions.Empty;
        do {
            switch (this.getNodeType()) {
                case 1: {
                    if (bl2) {
                        return string;
                    }
                    throw this.a("Child element is not expected in this operation.");
                }
                case 15: {
                    return string;
                }
                case 3: 
                case 4: 
                case 13: 
                case 14: {
                    string = StringExtensions.plusEqOperator(string, this.getValue());
                }
            }
        } while (this.read());
        throw this.a("Unexpected end of document.");
    }

    private String b() {
        IXmlLineInfo iXmlLineInfo = this instanceof IXmlLineInfo ? (IXmlLineInfo)((Object)this) : null;
        return iXmlLineInfo != null && iXmlLineInfo.hasLineInfo() ? StringExtensions.format(" {0} (line {1}, column {2})", this.getBaseURI(), iXmlLineInfo.getLineNumber(), iXmlLineInfo.getLinePosition()) : StringExtensions.Empty;
    }

    public boolean readElementContentAsBoolean() {
        try {
            return XQueryConvert.stringToBoolean(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public DateTime readElementContentAsDateTime() {
        try {
            return XQueryConvert.stringToDateTime(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public Decimal readElementContentAsDecimal() {
        try {
            return XQueryConvert.stringToDecimal(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public double readElementContentAsDouble() {
        try {
            return XQueryConvert.stringToDouble(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public float readElementContentAsFloat() {
        try {
            return XQueryConvert.stringToFloat(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public int readElementContentAsInt() {
        try {
            return XQueryConvert.stringToInt(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public long readElementContentAsLong() {
        try {
            return XQueryConvert.stringToInteger(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public String readElementContentAsString() {
        boolean bl2 = this.isEmptyElement();
        if (this.getNodeType() != 1) {
            throw new InvalidOperationException(StringExtensions.format("'{0}' is an element node.", this.getNodeType()));
        }
        this.readStartElement();
        if (bl2) {
            return StringExtensions.Empty;
        }
        String string = this.a(false);
        this.readEndElement();
        return string;
    }

    public boolean readElementContentAsBoolean(String localName, String namespaceURI) {
        try {
            return XQueryConvert.stringToBoolean(this.readElementContentAsString(localName, namespaceURI));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public DateTime readElementContentAsDateTime(String localName, String namespaceURI) {
        try {
            return XQueryConvert.stringToDateTime(this.readElementContentAsString(localName, namespaceURI));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public Decimal readElementContentAsDecimal(String localName, String namespaceURI) {
        try {
            return XQueryConvert.stringToDecimal(this.readElementContentAsString(localName, namespaceURI));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public double readElementContentAsDouble(String localName, String namespaceURI) {
        try {
            return XQueryConvert.stringToDouble(this.readElementContentAsString(localName, namespaceURI));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public float readElementContentAsFloat(String localName, String namespaceURI) {
        try {
            return XQueryConvert.stringToFloat(this.readElementContentAsString(localName, namespaceURI));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public int readElementContentAsInt(String localName, String namespaceURI) {
        try {
            return XQueryConvert.stringToInt(this.readElementContentAsString(localName, namespaceURI));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public long readElementContentAsLong(String localName, String namespaceURI) {
        try {
            return XQueryConvert.stringToInteger(this.readElementContentAsString(localName, namespaceURI));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public String readElementContentAsString(String localName, String namespaceURI) {
        boolean bl2 = this.isEmptyElement();
        if (this.getNodeType() != 1) {
            throw new InvalidOperationException(StringExtensions.format("'{0}' is an element node.", this.getNodeType()));
        }
        this.readStartElement(localName, namespaceURI);
        if (bl2) {
            return StringExtensions.Empty;
        }
        String string = this.a(false);
        this.readEndElement();
        return string;
    }

    public boolean readContentAsBoolean() {
        try {
            return XQueryConvert.stringToBoolean(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public DateTime readContentAsDateTime() {
        try {
            return XQueryConvert.stringToDateTime(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public Decimal readContentAsDecimal() {
        try {
            return XQueryConvert.stringToDecimal(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public double readContentAsDouble() {
        try {
            return XQueryConvert.stringToDouble(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public float readContentAsFloat() {
        try {
            return XQueryConvert.stringToFloat(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public int readContentAsInt() {
        try {
            return XQueryConvert.stringToInt(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public long readContentAsLong() {
        try {
            return XQueryConvert.stringToInteger(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public String readContentAsString() {
        return this.a();
    }

    public int readContentAsBase64(byte[] buffer, int offset, int length) {
        this.c();
        return this.b.readContentAsBase64(buffer, offset, length);
    }

    public int readContentAsBinHex(byte[] buffer, int offset, int length) {
        this.c();
        return this.b.readContentAsBinHex(buffer, offset, length);
    }

    public int readElementContentAsBase64(byte[] buffer, int offset, int length) {
        this.c();
        return this.b.readElementContentAsBase64(buffer, offset, length);
    }

    public int readElementContentAsBinHex(byte[] buffer, int offset, int length) {
        this.c();
        return this.b.readElementContentAsBinHex(buffer, offset, length);
    }

    private void c() {
        if (!this.canReadBinaryContent() || !this.canReadValueChunk()) {
            throw new NotSupportedException();
        }
        if (this.b == null) {
            this.b = new XmlReaderBinarySupport(this);
        }
    }

    public int readValueChunk(char[] buffer, int offset, int length) {
        if (!this.canReadValueChunk()) {
            throw new NotSupportedException();
        }
        if (this.b == null) {
            this.b = new XmlReaderBinarySupport(this);
        }
        return this.b.readValueChunk(buffer, offset, length);
    }

    public abstract void resolveEntity();

    public void skip() {
        if (this.getReadState() != 1) {
            return;
        }
        this.moveToElement();
        if (this.getNodeType() != 1 || this.isEmptyElement()) {
            this.read();
            return;
        }
        int n2 = this.getDepth();
        while (this.read() && n2 < this.getDepth()) {
        }
        if (this.getNodeType() == 15) {
            this.read();
        }
    }

    private XmlException a(String string) {
        return new XmlException(this instanceof IXmlLineInfo ? (IXmlLineInfo)((Object)this) : null, this.getBaseURI(), string);
    }

    private XmlException a(String string, Exception exception) {
        return new XmlException(this instanceof IXmlLineInfo ? (IXmlLineInfo)((Object)this) : null, this.getBaseURI(), string);
    }
}

