/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.SystemException;
import com.aspose.html.internal.ms.System.Xml.IXmlLineInfo;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;

@SerializableAttribute
public class XmlSchemaException
extends SystemException {
    private int a;
    private int b;
    private XmlSchemaObject c;
    private String d;

    public XmlSchemaException() {
        this("A schema error occurred.");
    }

    public XmlSchemaException(String message) {
        this(message, null);
    }

    public XmlSchemaException(String message, Exception innerException, int lineNumber, int linePosition) {
        this(message, lineNumber, linePosition, null, null, innerException);
    }

    public XmlSchemaException(String message, int lineNumber, int linePosition, XmlSchemaObject sourceObject, String sourceUri, Exception innerException) {
        super(XmlSchemaException.a(message, sourceUri, lineNumber, linePosition, sourceObject), innerException);
        this.a = lineNumber;
        this.b = linePosition;
        this.c = sourceObject;
        this.d = sourceUri;
    }

    public XmlSchemaException(String message, Object sender, String sourceUri, XmlSchemaObject sourceObject, Exception innerException) {
        super(XmlSchemaException.a(message, sourceUri, sender, sourceObject), innerException);
        IXmlLineInfo iXmlLineInfo;
        IXmlLineInfo iXmlLineInfo2 = iXmlLineInfo = sender instanceof IXmlLineInfo ? (IXmlLineInfo)sender : null;
        if (iXmlLineInfo != null && iXmlLineInfo.hasLineInfo()) {
            this.a = iXmlLineInfo.getLineNumber();
            this.b = iXmlLineInfo.getLinePosition();
        }
        this.c = sourceObject;
    }

    public XmlSchemaException(String message, XmlSchemaObject sourceObject, Exception innerException) {
        super(XmlSchemaException.a(message, null, 0, 0, sourceObject), innerException);
        this.a = sourceObject.getLineNumber();
        this.b = sourceObject.getLinePosition();
        this.c = sourceObject;
        this.d = sourceObject.getSourceUri();
    }

    public XmlSchemaException(String message, Exception innerException) {
        super(XmlSchemaException.a(message, null, 0, 0, null), innerException);
    }

    public int getLineNumber() {
        return this.a;
    }

    public int getLinePosition() {
        return this.b;
    }

    public XmlSchemaObject getSourceSchemaObject() {
        return this.c;
    }

    public String getSourceUri() {
        return this.d;
    }

    private static String a(String string, String string2, Object object, XmlSchemaObject xmlSchemaObject) {
        IXmlLineInfo iXmlLineInfo;
        IXmlLineInfo iXmlLineInfo2 = iXmlLineInfo = object instanceof IXmlLineInfo ? (IXmlLineInfo)object : null;
        if (iXmlLineInfo == null) {
            return XmlSchemaException.a(string, string2, 0, 0, xmlSchemaObject);
        }
        return XmlSchemaException.a(string, string2, iXmlLineInfo.getLineNumber(), iXmlLineInfo.getLinePosition(), xmlSchemaObject);
    }

    private static String a(String string, String string2, int n2, int n3, XmlSchemaObject xmlSchemaObject) {
        String string3 = StringExtensions.concat("XmlSchema error: ", string);
        if (n2 > 0) {
            string3 = StringExtensions.plusEqOperator(string3, StringExtensions.format(CultureInfo.getInvariantCulture(), " XML {0} Line {1}, Position {2}.", string2 != null && !"".equals(string2) ? StringExtensions.concat("URI: ", string2, " .") : "", n2, n3));
        }
        if (xmlSchemaObject != null) {
            string3 = StringExtensions.plusEqOperator(string3, StringExtensions.format(CultureInfo.getInvariantCulture(), " Related schema item SourceUri: {0}, Line {1}, Position {2}.", xmlSchemaObject.getSourceUri(), xmlSchemaObject.getLineNumber(), xmlSchemaObject.getLinePosition()));
        }
        return string3;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }
}

