/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.DictionaryEntry;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.Xml.IHasXmlParserContext;
import com.aspose.html.internal.ms.System.Xml.IXmlNamespaceResolver;
import com.aspose.html.internal.ms.System.Xml.TypeTranslator;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.System.Xml.XmlDocument;
import com.aspose.html.internal.ms.System.Xml.XmlParserContext;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlReader;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotated;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnyAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAttributeGroup;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAttributeGroupRef;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaComplexType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaDatatype;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaDerivationMethod;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObjectCollection;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObjectTable;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSet;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSimpleType;
import com.aspose.html.internal.ms.System.Xml.XsdAnySimpleType;
import com.aspose.html.internal.ms.System.Xml.XsdDecimal;
import com.aspose.html.internal.ms.System.Xml.XsdDouble;
import com.aspose.html.internal.ms.System.Xml.XsdFloat;
import com.aspose.html.internal.ms.System.Xml.XsdID;
import com.aspose.html.internal.ms.System.Xml.XsdIDRef;
import com.aspose.html.internal.ms.System.Xml.XsdInteger;
import com.aspose.html.internal.ms.System.Xml.XsdLanguage;
import com.aspose.html.internal.ms.System.Xml.XsdLong;
import com.aspose.html.internal.ms.System.Xml.XsdNMToken;
import com.aspose.html.internal.ms.System.Xml.XsdName;
import com.aspose.html.internal.ms.System.Xml.XsdNonNegativeInteger;
import com.aspose.html.internal.ms.System.Xml.XsdNonPositiveInteger;
import com.aspose.html.internal.ms.System.Xml.XsdPositiveInteger;
import com.aspose.html.internal.ms.System.Xml.XsdString;
import com.aspose.html.internal.ms.System.Xml.XsdUnsignedLong;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

class XmlSchemaUtil {
    static int FinalAllowed;
    static int ElementBlockAllowed;
    static int ComplexTypeBlockAllowed;
    static boolean StrictMsCompliant;
    private static final StringSwitchMap a;

    XmlSchemaUtil() {
    }

    public static void addToTable(XmlSchemaObjectTable table, XmlSchemaObject obj, XmlQualifiedName qname, ValidationEventHandler h2) {
        if (table.contains(qname)) {
            if (obj.isRedefineChild) {
                if (obj.redefinedObject != null) {
                    obj.error(h2, StringExtensions.format("Named item {0} was already contained in the schema object table.", qname));
                } else {
                    obj.redefinedObject = table.get_Item(qname);
                }
                table.set(qname, obj);
            } else {
                if (table.get_Item((XmlQualifiedName)qname).isRedefineChild) {
                    if (table.get_Item((XmlQualifiedName)qname).redefinedObject != null) {
                        obj.error(h2, StringExtensions.format("Named item {0} was already contained in the schema object table.", qname));
                    } else {
                        table.get_Item((XmlQualifiedName)qname).redefinedObject = obj;
                    }
                    return;
                }
                if (StrictMsCompliant) {
                    table.set(qname, obj);
                } else {
                    obj.error(h2, StringExtensions.format("Named item {0} was already contained in the schema object table. {1}", qname, ""));
                }
            }
        } else {
            table.set(qname, obj);
        }
    }

    public static void compileID(String id2, XmlSchemaObject xso, Hashtable idCollection, ValidationEventHandler h2) {
        if (id2 == null) {
            return;
        }
        if (!XmlSchemaUtil.checkNCName(id2)) {
            xso.error(h2, StringExtensions.concat(id2, " is not a valid id attribute"));
        } else if (idCollection.containsKey(id2)) {
            xso.error(h2, StringExtensions.concat("Duplicate id attribute ", id2));
        } else {
            idCollection.addItem(id2, xso);
        }
    }

    public static boolean checkAnyUri(String uri) {
        return !StringExtensions.startsWith(uri, "##");
    }

    public static boolean checkNormalizedString(String token) {
        return true;
    }

    public static boolean checkNCName(String name) {
        return XmlChar.isNCName(name);
    }

    public static boolean checkQName(XmlQualifiedName qname) {
        return true;
    }

    public static XmlParserContext getParserContext(XmlReader reader) {
        IHasXmlParserContext iHasXmlParserContext;
        IHasXmlParserContext iHasXmlParserContext2 = iHasXmlParserContext = reader instanceof IHasXmlParserContext ? (IHasXmlParserContext)((Object)reader) : null;
        if (iHasXmlParserContext != null) {
            return iHasXmlParserContext.getParserContext();
        }
        return null;
    }

    public static boolean isBuiltInDatatypeName(XmlQualifiedName qname) {
        if ("http://www.w3.org/2003/11/xpath-datatypes".equals(qname.getNamespace())) {
            switch (a.of(qname.getName())) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
        if (!"http://www.w3.org/2001/XMLSchema".equals(qname.getNamespace())) {
            return false;
        }
        switch (a.of(qname.getName())) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    public static boolean areSchemaDatatypeEqual(XmlSchemaSimpleType st1, Object v1, XmlSchemaSimpleType st2, Object v2) {
        String[] stringArray;
        XmlSchemaDatatype xmlSchemaDatatype = st1.getDatatype();
        if (xmlSchemaDatatype instanceof XsdAnySimpleType) {
            XmlSchemaDatatype xmlSchemaDatatype2 = st2.getDatatype();
            return XmlSchemaUtil.areSchemaDatatypeEqual((XsdAnySimpleType)xmlSchemaDatatype, v1, xmlSchemaDatatype2 instanceof XsdAnySimpleType ? (XsdAnySimpleType)xmlSchemaDatatype2 : null, v2);
        }
        String[] stringArray2 = v1 instanceof String[] ? (String[])v1 : null;
        String[] stringArray3 = stringArray = v2 instanceof String[] ? (String[])v2 : null;
        if (st1 != st2 || stringArray2 == null || stringArray == null || stringArray2.length != stringArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            if (StringExtensions.equals(stringArray2[i2], stringArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean areSchemaDatatypeEqual(XsdAnySimpleType st1, Object v1, XsdAnySimpleType st2, Object v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        if (st1 == null) {
            st1 = XmlSchemaSimpleType.getAnySimpleType();
        }
        if (st2 == null) {
            st2 = XmlSchemaSimpleType.getAnySimpleType();
        }
        Type type = ObjectExtensions.getType(st2);
        if (st1 instanceof XsdFloat) {
            return st2 instanceof XsdFloat && Convert.toSingle(v1) == Convert.toSingle(v2);
        }
        if (st1 instanceof XsdDouble) {
            return st2 instanceof XsdDouble && Convert.toDouble(v1) == Convert.toDouble(v2);
        }
        if (st1 instanceof XsdDecimal) {
            if (!(st2 instanceof XsdDecimal) || Decimal.op_Inequality(Convert.toDecimal(v1), Convert.toDecimal(v2))) {
                return false;
            }
            if (st1 instanceof XsdNonPositiveInteger) {
                return st2 instanceof XsdNonPositiveInteger || type == Operators.typeOf(XsdDecimal.class) || type == Operators.typeOf(XsdInteger.class);
            }
            if (st1 instanceof XsdPositiveInteger) {
                return st2 instanceof XsdPositiveInteger || type == Operators.typeOf(XsdDecimal.class) || type == Operators.typeOf(XsdInteger.class) || type == Operators.typeOf(XsdNonNegativeInteger.class);
            }
            if (st1 instanceof XsdUnsignedLong) {
                return st2 instanceof XsdUnsignedLong || type == Operators.typeOf(XsdDecimal.class) || type == Operators.typeOf(XsdInteger.class) || type == Operators.typeOf(XsdNonNegativeInteger.class);
            }
            if (st1 instanceof XsdNonNegativeInteger) {
                return st2 instanceof XsdNonNegativeInteger || type == Operators.typeOf(XsdDecimal.class) || type == Operators.typeOf(XsdInteger.class);
            }
            if (st1 instanceof XsdLong) {
                return st2 instanceof XsdLong || type == Operators.typeOf(XsdDecimal.class) || type == Operators.typeOf(XsdInteger.class);
            }
            return true;
        }
        if (!v1.equals(v2)) {
            return false;
        }
        if (st1 instanceof XsdString) {
            if (!(st2 instanceof XsdString)) {
                return false;
            }
            if (st1 instanceof XsdNMToken && (st2 instanceof XsdLanguage || st2 instanceof XsdName)) {
                return false;
            }
            if (st2 instanceof XsdNMToken && (st1 instanceof XsdLanguage || st1 instanceof XsdName)) {
                return false;
            }
            if (st1 instanceof XsdName && (st2 instanceof XsdLanguage || st2 instanceof XsdNMToken)) {
                return false;
            }
            if (st2 instanceof XsdName && (st1 instanceof XsdLanguage || st1 instanceof XsdNMToken)) {
                return false;
            }
            if (st1 instanceof XsdID && st2 instanceof XsdIDRef) {
                return false;
            }
            if (st1 instanceof XsdIDRef && st2 instanceof XsdID) {
                return false;
            }
        } else if (st1 != st2) {
            return false;
        }
        return true;
    }

    public static boolean isValidQName(String qname) {
        for (String string : StringExtensions.split(qname, new char[]{':'}, 2)) {
            if (XmlSchemaUtil.checkNCName(string)) continue;
            return false;
        }
        return true;
    }

    public static String[] splitList(String list) {
        Object object;
        if (list == null || StringExtensions.equals(list, StringExtensions.Empty)) {
            return new String[0];
        }
        ArrayList arrayList = null;
        int n2 = 0;
        boolean bl2 = true;
        block3: for (int i2 = 0; i2 < list.length(); ++i2) {
            switch (list.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!bl2) {
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.addItem(StringExtensions.substring(list, n2, i2 - n2));
                    }
                    bl2 = true;
                    continue block3;
                }
                default: {
                    if (!bl2) continue block3;
                    bl2 = false;
                    n2 = i2;
                }
            }
        }
        if (!bl2 && n2 == 0) {
            return new String[]{list};
        }
        if (!bl2 && n2 < list.length()) {
            arrayList.addItem(n2 == 0 ? list : StringExtensions.substring(list, n2));
        }
        return (object = Array.unboxing(arrayList.toArray(Operators.typeOf(String.class)))) instanceof String[] ? (String[])object : null;
    }

    public static void readUnhandledAttribute(XmlReader reader, XmlSchemaObject xso) {
        if ("xmlns".equals(reader.getPrefix())) {
            xso.getNamespaces().add(reader.getLocalName(), reader.getValue());
        } else if ("xmlns".equals(reader.getName())) {
            xso.getNamespaces().add("", reader.getValue());
        } else {
            if (xso.unhandledAttributeList == null) {
                xso.unhandledAttributeList = new ArrayList();
            }
            XmlAttribute xmlAttribute = new XmlDocument().createAttribute(reader.getLocalName(), reader.getNamespaceURI());
            xmlAttribute.setValue(reader.getValue());
            XmlSchemaUtil.parseWsdlArrayType(reader, xmlAttribute);
            xso.unhandledAttributeList.addItem(xmlAttribute);
        }
    }

    static void parseWsdlArrayType(XmlReader reader, XmlAttribute attr) {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(attr.getNamespaceURI()) && "arrayType".equals(attr.getLocalName())) {
            String string = "";
            String string2 = null;
            String string3 = null;
            String[] stringArray = new String[]{string2};
            String[] stringArray2 = new String[]{string};
            String[] stringArray3 = new String[]{string3};
            TypeTranslator.parseArrayType(attr.getValue(), stringArray, stringArray2, stringArray3);
            string2 = stringArray[0];
            string = stringArray2[0];
            string3 = stringArray3[0];
            if (!"".equals(string)) {
                string = StringExtensions.concat(reader.lookupNamespace(string), ":");
            }
            attr.setValue(StringExtensions.concat(string, string2, string3));
        }
    }

    public static boolean readBoolAttribute(XmlReader reader, Exception[] innerExcpetion) {
        innerExcpetion[0] = null;
        try {
            boolean bl2 = XmlConvert.toBoolean(reader.getValue());
            return bl2;
        }
        catch (Exception exception) {
            innerExcpetion[0] = exception;
            return false;
        }
    }

    public static Decimal readDecimalAttribute(XmlReader reader, Exception[] innerExcpetion) {
        innerExcpetion[0] = null;
        try {
            Decimal decimal = XmlConvert.toDecimal(reader.getValue());
            return decimal;
        }
        catch (Exception exception) {
            innerExcpetion[0] = exception;
            return Decimal.Zero.Clone();
        }
    }

    public static int readDerivationAttribute(XmlReader reader, Exception[] innerExcpetion, String name, int allowed) {
        innerExcpetion[0] = null;
        try {
            String string = reader.getValue();
            String string2 = "";
            int n2 = 0;
            if (StringExtensions.indexOf(string, "#all") != -1 && !"#all".equals(StringExtensions.trim(string))) {
                innerExcpetion[0] = new Exception(StringExtensions.concat(string, " is not a valid value for ", name, ". #all if present must be the only value"));
                return 255;
            }
            block11: for (String string3 : XmlSchemaUtil.splitList(string)) {
                switch (a.of(string3)) {
                    case 49: {
                        n2 = XmlSchemaUtil.a(n2, 0, allowed);
                        continue block11;
                    }
                    case 50: {
                        n2 = XmlSchemaUtil.a(n2, 255, allowed);
                        continue block11;
                    }
                    case 51: {
                        n2 = XmlSchemaUtil.a(n2, 1, allowed);
                        continue block11;
                    }
                    case 52: {
                        n2 = XmlSchemaUtil.a(n2, 2, allowed);
                        continue block11;
                    }
                    case 53: {
                        n2 = XmlSchemaUtil.a(n2, 4, allowed);
                        continue block11;
                    }
                    case 54: {
                        n2 = XmlSchemaUtil.a(n2, 8, allowed);
                        continue block11;
                    }
                    case 55: {
                        n2 = XmlSchemaUtil.a(n2, 16, allowed);
                        continue block11;
                    }
                    default: {
                        string2 = StringExtensions.plusEqOperator(string2, StringExtensions.concat(string3, " "));
                    }
                }
            }
            if (!"".equals(string2)) {
                innerExcpetion[0] = new Exception(StringExtensions.concat(string2, "is/are not valid values for ", name));
            }
            return n2;
        }
        catch (Exception exception) {
            innerExcpetion[0] = exception;
            return 256;
        }
    }

    private static int a(int n2, int n3, int n4) {
        if ((n3 & n4) == 0 && n4 != 255) {
            throw new ArgumentException(StringExtensions.concat(Enum.getName(XmlSchemaDerivationMethod.class, n3), " is not allowed in this attribute."));
        }
        if ((n2 & n3) != 0) {
            throw new ArgumentException(StringExtensions.concat(Enum.getName(XmlSchemaDerivationMethod.class, n3), " is already specified in this attribute."));
        }
        return n2 | n3;
    }

    public static int readFormAttribute(XmlReader reader, Exception[] innerExcpetion) {
        innerExcpetion[0] = null;
        int n2 = 0;
        switch (a.of(reader.getValue())) {
            case 56: {
                n2 = 1;
                break;
            }
            case 57: {
                n2 = 2;
                break;
            }
            default: {
                innerExcpetion[0] = new Exception("only qualified or unqulified is a valid value");
            }
        }
        return n2;
    }

    public static int readProcessingAttribute(XmlReader reader, Exception[] innerExcpetion) {
        innerExcpetion[0] = null;
        int n2 = 0;
        switch (a.of(reader.getValue())) {
            case 58: {
                n2 = 2;
                break;
            }
            case 59: {
                n2 = 3;
                break;
            }
            case 60: {
                n2 = 1;
                break;
            }
            default: {
                innerExcpetion[0] = new Exception("only lax , strict or skip are valid values for processContents");
            }
        }
        return n2;
    }

    public static int readUseAttribute(XmlReader reader, Exception[] innerExcpetion) {
        innerExcpetion[0] = null;
        int n2 = 0;
        switch (a.of(reader.getValue())) {
            case 61: {
                n2 = 1;
                break;
            }
            case 62: {
                n2 = 2;
                break;
            }
            case 63: {
                n2 = 3;
                break;
            }
            default: {
                innerExcpetion[0] = new Exception("only optional , prohibited or required are valid values for use");
            }
        }
        return n2;
    }

    public static XmlQualifiedName readQNameAttribute(XmlReader reader, Exception[] innerEx) {
        return XmlSchemaUtil.toQName(reader, reader.getValue(), innerEx);
    }

    public static XmlQualifiedName toQName(XmlReader reader, String qnamestr, Exception[] innerEx) {
        String string;
        String string2;
        innerEx[0] = null;
        if (!XmlSchemaUtil.isValidQName(qnamestr)) {
            innerEx[0] = new Exception(StringExtensions.concat(qnamestr, " is an invalid QName. Either name or namespace is not a NCName"));
            return XmlQualifiedName.Empty;
        }
        String[] stringArray = StringExtensions.split(qnamestr, new char[]{':'}, 2);
        if (stringArray.length == 2) {
            string2 = reader.lookupNamespace(stringArray[0]);
            if (string2 == null) {
                innerEx[0] = new Exception(StringExtensions.concat("Namespace Prefix '", stringArray[0], "could not be resolved"));
                return XmlQualifiedName.Empty;
            }
            string = stringArray[1];
        } else {
            string2 = reader.lookupNamespace("");
            string = stringArray[0];
        }
        XmlQualifiedName xmlQualifiedName = new XmlQualifiedName(string, string2);
        return xmlQualifiedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int validateAttributesResolved(XmlSchemaObjectTable attributesResolved, ValidationEventHandler h2, XmlSchema schema, XmlSchemaObjectCollection attributes, XmlSchemaAnyAttribute anyAttribute, XmlSchemaAnyAttribute[] anyAttributeUse, XmlSchemaAttributeGroup redefined, boolean skipEquivalent) {
        int n2 = 0;
        if (anyAttribute != null && anyAttributeUse[0] == null) {
            anyAttributeUse[0] = anyAttribute;
        }
        ArrayList arrayList = new ArrayList();
        for (XmlSchemaObject xmlSchemaObject : attributes) {
            XmlSchemaAnnotated xmlSchemaAnnotated;
            XmlSchemaAttributeGroupRef xmlSchemaAttributeGroupRef;
            XmlSchemaAttributeGroupRef xmlSchemaAttributeGroupRef2 = xmlSchemaAttributeGroupRef = xmlSchemaObject instanceof XmlSchemaAttributeGroupRef ? (XmlSchemaAttributeGroupRef)xmlSchemaObject : null;
            if (xmlSchemaAttributeGroupRef != null) {
                xmlSchemaAnnotated = null;
                xmlSchemaAnnotated = redefined != null && XmlQualifiedName.op_Equality(xmlSchemaAttributeGroupRef.getRefName(), redefined.getQualifiedName()) ? redefined : schema.findAttributeGroup(xmlSchemaAttributeGroupRef.getRefName());
                if (xmlSchemaAnnotated == null) {
                    if (schema.missedSubComponents) continue;
                    xmlSchemaAttributeGroupRef.error(h2, StringExtensions.concat("Referenced attribute group ", xmlSchemaAttributeGroupRef.getRefName(), " was not found in the corresponding schema."));
                    continue;
                }
                if (((XmlSchemaAttributeGroup)xmlSchemaAnnotated).AttributeGroupRecursionCheck) {
                    xmlSchemaAnnotated.error(h2, "Attribute group recursion was found: " + xmlSchemaAttributeGroupRef.getRefName());
                    continue;
                }
                try {
                    ((XmlSchemaAttributeGroup)xmlSchemaAnnotated).AttributeGroupRecursionCheck = true;
                    n2 += ((XmlSchemaAttributeGroup)xmlSchemaAnnotated).validate(h2, schema);
                }
                finally {
                    ((XmlSchemaAttributeGroup)xmlSchemaAnnotated).AttributeGroupRecursionCheck = false;
                }
                if (((XmlSchemaAttributeGroup)xmlSchemaAnnotated).getAnyAttributeUse() != null && anyAttribute == null) {
                    anyAttributeUse[0] = ((XmlSchemaAttributeGroup)xmlSchemaAnnotated).getAnyAttributeUse();
                }
                for (DictionaryEntry dictionaryEntry : ((XmlSchemaAttributeGroup)xmlSchemaAnnotated).getAttributeUses()) {
                    XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)dictionaryEntry.getValue();
                    if (StrictMsCompliant && xmlSchemaAttribute.getUse() == 2) continue;
                    if (!(xmlSchemaAttribute.getRefName() == null || !XmlQualifiedName.op_Inequality(xmlSchemaAttribute.getRefName(), XmlQualifiedName.Empty) || skipEquivalent && XmlSchemaUtil.areAttributesEqual(xmlSchemaAttribute, Operators.as(attributesResolved.get_Item(xmlSchemaAttribute.getRefName()), XmlSchemaAttribute.class)))) {
                        XmlSchemaUtil.addToTable(attributesResolved, xmlSchemaAttribute, xmlSchemaAttribute.getRefName(), h2);
                        continue;
                    }
                    if (skipEquivalent && XmlSchemaUtil.areAttributesEqual(xmlSchemaAttribute, Operators.as(attributesResolved.get_Item(xmlSchemaAttribute.getQualifiedName()), XmlSchemaAttribute.class))) continue;
                    XmlSchemaUtil.addToTable(attributesResolved, xmlSchemaAttribute, xmlSchemaAttribute.getQualifiedName(), h2);
                }
                continue;
            }
            XmlSchemaAnnotated xmlSchemaAnnotated2 = xmlSchemaAnnotated = xmlSchemaObject instanceof XmlSchemaAttribute ? (XmlSchemaAttribute)xmlSchemaObject : null;
            if (xmlSchemaAnnotated != null) {
                n2 += ((XmlSchemaAttribute)xmlSchemaAnnotated).validate(h2, schema);
                if (arrayList.contains(((XmlSchemaAttribute)xmlSchemaAnnotated).getQualifiedName())) {
                    xmlSchemaAnnotated.error(h2, StringExtensions.format("Duplicate attributes was found for '{0}'", ((XmlSchemaAttribute)xmlSchemaAnnotated).getQualifiedName()));
                }
                arrayList.addItem(((XmlSchemaAttribute)xmlSchemaAnnotated).getQualifiedName());
                if (StrictMsCompliant && ((XmlSchemaAttribute)xmlSchemaAnnotated).getUse() == 2) continue;
                if (!(((XmlSchemaAttribute)xmlSchemaAnnotated).getRefName() == null || !XmlQualifiedName.op_Inequality(((XmlSchemaAttribute)xmlSchemaAnnotated).getRefName(), XmlQualifiedName.Empty) || skipEquivalent && XmlSchemaUtil.areAttributesEqual((XmlSchemaAttribute)xmlSchemaAnnotated, Operators.as(attributesResolved.get_Item(((XmlSchemaAttribute)xmlSchemaAnnotated).getRefName()), XmlSchemaAttribute.class)))) {
                    XmlSchemaUtil.addToTable(attributesResolved, xmlSchemaAnnotated, ((XmlSchemaAttribute)xmlSchemaAnnotated).getRefName(), h2);
                    continue;
                }
                if (skipEquivalent && XmlSchemaUtil.areAttributesEqual((XmlSchemaAttribute)xmlSchemaAnnotated, Operators.as(attributesResolved.get_Item(((XmlSchemaAttribute)xmlSchemaAnnotated).getQualifiedName()), XmlSchemaAttribute.class))) continue;
                XmlSchemaUtil.addToTable(attributesResolved, xmlSchemaAnnotated, ((XmlSchemaAttribute)xmlSchemaAnnotated).getQualifiedName(), h2);
                continue;
            }
            if (anyAttribute == null) continue;
            anyAttributeUse[0] = (XmlSchemaAnyAttribute)xmlSchemaObject;
            anyAttribute.validate(h2, schema);
        }
        return n2;
    }

    static boolean areAttributesEqual(XmlSchemaAttribute one, XmlSchemaAttribute another) {
        if (one == null || another == null) {
            return false;
        }
        return one.getAttributeType() == another.getAttributeType() && one.getForm() == another.getForm() && one.getValidatedUse() == another.getValidatedUse() && StringExtensions.equals(one.getValidatedDefaultValue(), another.getValidatedDefaultValue()) && StringExtensions.equals(one.getValidatedFixedValue(), another.getValidatedFixedValue());
    }

    public static Object readTypedValue(XmlReader reader, Object type, IXmlNamespaceResolver nsResolver, msStringBuilder tmpBuilder) {
        XmlSchemaSimpleType xmlSchemaSimpleType;
        if (tmpBuilder == null) {
            tmpBuilder = new msStringBuilder();
        }
        XmlSchemaDatatype xmlSchemaDatatype = type instanceof XmlSchemaDatatype ? (XmlSchemaDatatype)type : null;
        XmlSchemaSimpleType xmlSchemaSimpleType2 = xmlSchemaSimpleType = type instanceof XmlSchemaSimpleType ? (XmlSchemaSimpleType)type : null;
        if (xmlSchemaSimpleType != null) {
            xmlSchemaDatatype = xmlSchemaSimpleType.getDatatype();
        }
        if (xmlSchemaDatatype == null) {
            return null;
        }
        switch (reader.getNodeType()) {
            case 1: {
                if (reader.isEmptyElement()) {
                    return null;
                }
                tmpBuilder.setLength(0);
                boolean bl2 = true;
                do {
                    reader.read();
                    switch (reader.getNodeType()) {
                        case 3: 
                        case 4: 
                        case 14: {
                            tmpBuilder.append(reader.getValue());
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            bl2 = false;
                        }
                    }
                } while (bl2 && !reader.getEOF() && reader.getReadState() == 1);
                return xmlSchemaDatatype.parseValue(tmpBuilder.toString(), reader.getNameTable(), nsResolver);
            }
            case 2: {
                return xmlSchemaDatatype.parseValue(reader.getValue(), reader.getNameTable(), nsResolver);
            }
        }
        return null;
    }

    public static XmlSchemaObject findAttributeDeclaration(String ns, XmlSchemaSet schemas, XmlSchemaComplexType cType, XmlQualifiedName qname) {
        XmlSchemaAttribute xmlSchemaAttribute;
        XmlSchemaObject xmlSchemaObject = cType.getAttributeUses().get_Item(qname);
        if (xmlSchemaObject != null) {
            return xmlSchemaObject;
        }
        if (cType.getAttributeWildcard() == null) {
            return null;
        }
        if (!XmlSchemaUtil.a(cType.getAttributeWildcard(), qname, ns)) {
            return null;
        }
        if (cType.getAttributeWildcard().getResolvedProcessContents() == 1) {
            return cType.getAttributeWildcard();
        }
        XmlSchemaObject xmlSchemaObject2 = schemas.getGlobalAttributes().get_Item(qname);
        XmlSchemaAttribute xmlSchemaAttribute2 = xmlSchemaAttribute = xmlSchemaObject2 instanceof XmlSchemaAttribute ? (XmlSchemaAttribute)xmlSchemaObject2 : null;
        if (xmlSchemaAttribute != null) {
            return xmlSchemaAttribute;
        }
        if (cType.getAttributeWildcard().getResolvedProcessContents() == 2) {
            return cType.getAttributeWildcard();
        }
        return null;
    }

    private static boolean a(XmlSchemaAnyAttribute xmlSchemaAnyAttribute, XmlQualifiedName xmlQualifiedName, String string) {
        if (xmlSchemaAnyAttribute.hasValueAny()) {
            return true;
        }
        if (xmlSchemaAnyAttribute.hasValueOther() && ("".equals(xmlSchemaAnyAttribute.getTargetNamespace()) || !StringExtensions.equals(string, xmlSchemaAnyAttribute.getTargetNamespace()))) {
            return true;
        }
        if (xmlSchemaAnyAttribute.hasValueTargetNamespace() && StringExtensions.equals(string, xmlSchemaAnyAttribute.getTargetNamespace())) {
            return true;
        }
        if (xmlSchemaAnyAttribute.hasValueLocal() && "".equals(string)) {
            return true;
        }
        for (int i2 = 0; i2 < xmlSchemaAnyAttribute.getResolvedNamespaces().size(); ++i2) {
            if (!StringExtensions.equals(xmlSchemaAnyAttribute.getResolvedNamespaces().get_Item(i2), string)) continue;
            return true;
        }
        return false;
    }

    static {
        StrictMsCompliant = true;
        ComplexTypeBlockAllowed = FinalAllowed = 6;
        ElementBlockAllowed = 1 | FinalAllowed;
        a = new StringSwitchMap("anyAtomicType", "untypedAtomic", "dayTimeDuration", "yearMonthDuration", "anySimpleType", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "boolean", "base64Binary", "hexBinary", "float", "double", "anyURI", "QName", "NOTATION", "string", "normalizedString", "token", "language", "Name", "NCName", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", "decimal", "integer", "nonPositiveInteger", "negativeInteger", "nonNegativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "positiveInteger", "long", "int", "short", "byte", "", "#all", "substitution", "extension", "restriction", "list", "union", "qualified", "unqualified", "lax", "strict", "skip", "optional", "prohibited", "required");
    }
}

