/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.ArithmeticException;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.CLSCompliantAttribute;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.MidpointRounding;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.UInt64Extensions;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class msMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static ThreadLocal<DecimalFormat> a = new ThreadLocal();

    private static DecimalFormat a() {
        if (a.get() == null) {
            a.set(new DecimalFormat("###.", new DecimalFormatSymbols(Locale.ENGLISH)));
        }
        return a.get();
    }

    public static void clearCurrentThreadLocals() {
        a.remove();
    }

    public static Decimal abs(Decimal value) {
        return Decimal.op_LessThan(value, Decimal.newDecimalFromInt(0)) ? Decimal.op_UnaryNegation(value) : value;
    }

    public static double abs(double value) {
        return value < 0.0 ? -value : value;
    }

    public static float abs(float value) {
        return value < 0.0f ? -value : value;
    }

    public static int abs(int value) {
        if (value == Integer.MIN_VALUE) {
            throw new OverflowException("Value is too small.");
        }
        return value < 0 ? -value : value;
    }

    public static long abs(long value) {
        if (value == Long.MIN_VALUE) {
            throw new OverflowException("Value is too small.");
        }
        return value < 0L ? -value : value;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static byte abs(byte value) {
        if (value == -128) {
            throw new OverflowException("Value is too small.");
        }
        return value < 0 ? -value : value;
    }

    public static short abs(short value) {
        if (value == Short.MIN_VALUE) {
            throw new OverflowException("Value is too small.");
        }
        return value < 0 ? -value : value;
    }

    public static Decimal ceiling(Decimal d2) {
        Decimal decimal = msMath.floor(d2);
        if (Decimal.op_Inequality(decimal, d2)) {
            decimal = Decimal.op_Increment(decimal);
        }
        return decimal;
    }

    public static double ceiling(double a2) {
        if (Double.isInfinite(a2) || Double.isNaN(a2)) {
            return a2;
        }
        double d2 = msMath.floor(a2);
        if (d2 != a2) {
            d2 += 1.0;
        }
        return d2;
    }

    public static double floor(double a2) {
        return Math.floor(a2);
    }

    public static long bigMul(int a2, int b2) {
        return (long)a2 * (long)b2;
    }

    public static int divRem(int a2, int b2, int[] result) {
        result[0] = a2 % b2;
        return a2 / b2;
    }

    public static long divRem(long a2, long b2, long[] result) {
        result[0] = a2 % b2;
        return a2 / b2;
    }

    public static double iEEERemainder(double x2, double y2) {
        if (y2 == 0.0) {
            return Double.NaN;
        }
        double d2 = x2 - y2 * (double)Math.round(x2 / y2);
        if (d2 != 0.0) {
            return d2;
        }
        return x2 > 0.0 ? 0.0 : BitConverter.int64BitsToDouble(Long.MIN_VALUE);
    }

    public static double log(double a2, double newBase) {
        if (newBase == 1.0) {
            return Double.NaN;
        }
        double d2 = msMath.log(a2) / msMath.log(newBase);
        return d2 == 0.0 ? 0.0 : d2;
    }

    public static byte max(byte val1, byte val2) {
        return (val1 & 0xFF) > (val2 & 0xFF) ? val1 : val2;
    }

    public static Decimal max(Decimal val1, Decimal val2) {
        return Decimal.op_GreaterThan(val1, val2) ? val1 : val2;
    }

    public static double max(double val1, double val2) {
        if (DoubleExtensions.isNaN(val1) || DoubleExtensions.isNaN(val2)) {
            return Double.NaN;
        }
        return val1 > val2 ? val1 : val2;
    }

    public static float max(float val1, float val2) {
        if (SingleExtensions.isNaN(val1) || SingleExtensions.isNaN(val2)) {
            return Float.NaN;
        }
        return val1 > val2 ? val1 : val2;
    }

    public static int max(int val1, int val2) {
        return val1 > val2 ? val1 : val2;
    }

    public static long max(long val1, long val2) {
        return val1 > val2 ? val1 : val2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static byte maxSByte(byte val1, byte val2) {
        return val1 > val2 ? val1 : val2;
    }

    public static short max(short val1, short val2) {
        return val1 > val2 ? val1 : val2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long maxUInt(long val1, long val2) {
        return (val1 & 0xFFFFFFFFL) > (val2 & 0xFFFFFFFFL) ? val1 & 0xFFFFFFFFL : val2 & 0xFFFFFFFFL;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long maxULong(long val1, long val2) {
        return UInt64Extensions.compareTo(val1, val2) > 0 ? val1 : val2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static int maxUShort(int val1, int val2) {
        return (val1 & 0xFFFF) > (val2 & 0xFFFF) ? val1 & 0xFFFF : val2 & 0xFFFF;
    }

    public static byte min(byte val1, byte val2) {
        return (val1 & 0xFF) < (val2 & 0xFF) ? val1 : val2;
    }

    public static Decimal min(Decimal val1, Decimal val2) {
        return Decimal.op_LessThan(val1, val2) ? val1 : val2;
    }

    public static double min(double val1, double val2) {
        if (DoubleExtensions.isNaN(val1) || DoubleExtensions.isNaN(val2)) {
            return Double.NaN;
        }
        return val1 < val2 ? val1 : val2;
    }

    public static float min(float val1, float val2) {
        if (SingleExtensions.isNaN(val1) || SingleExtensions.isNaN(val2)) {
            return Float.NaN;
        }
        return val1 < val2 ? val1 : val2;
    }

    public static int min(int val1, int val2) {
        return val1 < val2 ? val1 : val2;
    }

    public static long min(long val1, long val2) {
        return val1 < val2 ? val1 : val2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static byte minSByte(byte val1, byte val2) {
        return val1 < val2 ? val1 : val2;
    }

    public static short min(short val1, short val2) {
        return val1 < val2 ? val1 : val2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long minUInt(long val1, long val2) {
        return (val1 & 0xFFFFFFFFL) < (val2 & 0xFFFFFFFFL) ? val1 & 0xFFFFFFFFL : val2 & 0xFFFFFFFFL;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long minULong(long val1, long val2) {
        return UInt64Extensions.compareTo(val1, val2) < 0 ? val1 : val2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static int minUShort(int val1, int val2) {
        return (val1 & 0xFFFF) < (val2 & 0xFFFF) ? val1 & 0xFFFF : val2 & 0xFFFF;
    }

    public static Decimal round(Decimal d2) {
        Decimal decimal = Decimal.floor(d2);
        Decimal decimal2 = Decimal.op_Subtraction(d2, decimal);
        if (Decimal.op_Equality(decimal2, new Decimal("0.5")) && Decimal.op_Inequality(Decimal.op_Multiply(new Decimal("2.0"), Decimal.op_Subtraction(Decimal.op_Division(decimal, new Decimal("2.0")), Decimal.floor(Decimal.op_Division(decimal, new Decimal("2.0"))))), new Decimal("0.0")) || Decimal.op_GreaterThan(decimal2, new Decimal("0.5"))) {
            decimal = Decimal.op_Increment(decimal);
        }
        return decimal;
    }

    public static Decimal round(Decimal d2, int decimals) {
        return Decimal.round(d2, decimals);
    }

    public static Decimal round(Decimal d2, short mode) {
        if (mode != 0 && mode != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, mode), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (mode == 0) {
            return msMath.round(d2);
        }
        return msMath.a(d2);
    }

    static Decimal a(Decimal decimal) {
        Decimal decimal2 = Decimal.floor(decimal);
        Decimal decimal3 = Decimal.op_Subtraction(decimal, decimal2);
        if (Decimal.op_GreaterThanOrEqual(decimal2, Decimal.newDecimalFromInt(0)) && Decimal.op_GreaterThanOrEqual(decimal3, new Decimal("0.5"))) {
            decimal2 = Decimal.op_Increment(decimal2);
        } else if (Decimal.op_LessThan(decimal2, Decimal.newDecimalFromInt(0)) && Decimal.op_GreaterThan(decimal3, new Decimal("0.5"))) {
            decimal2 = Decimal.op_Increment(decimal2);
        }
        return decimal2;
    }

    public static Decimal round(Decimal d2, int decimals, short mode) {
        return Decimal.round(d2, decimals, mode);
    }

    public static double round(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return value;
        }
        if (value == 0.0) {
            return value;
        }
        double d2 = msMath.floor(value);
        double d3 = msMath.ceiling(value);
        if (msMath.abs(d3 - value) == msMath.abs(d2 - value)) {
            return msMath.abs(d2 % 2.0) == 1.0 ? d3 : d2;
        }
        return msMath.abs(d3 - value) > msMath.abs(d2 - value) ? d2 : d3;
    }

    public static double round(double value, int digits) {
        double d2;
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return value;
        }
        if (digits < 0 || digits > 15) {
            throw new ArgumentOutOfRangeException("Value is too small or too big.");
        }
        if (digits == 0) {
            return msMath.round(value);
        }
        if (digits == 2) {
            try {
                d2 = Double.parseDouble(msMath.a().format(value * 100.0)) / 100.0;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                d2 = msMath.a(value, digits, (short)0);
            }
            catch (NumberFormatException numberFormatException) {
                DecimalFormat decimalFormat = new DecimalFormat("###.");
                d2 = Double.parseDouble(decimalFormat.format(value * 100.0)) / 100.0;
            }
        } else {
            d2 = msMath.a(value, digits, (short)0);
        }
        return d2;
    }

    public static double round(double value, short mode) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return value;
        }
        if (mode != 0 && mode != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, mode), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (mode == 0) {
            return msMath.round(value);
        }
        if (value > 0.0) {
            return msMath.floor(value + 0.5);
        }
        return msMath.ceiling(value - 0.5);
    }

    public static double round(double value, int digits, short mode) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return value;
        }
        if (mode != 0 && mode != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, mode), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (digits == 0) {
            return msMath.round(value, mode);
        }
        return msMath.a(value, digits, mode);
    }

    private static double a(double d2, int n2, short s2) {
        Decimal decimal = Decimal.newDecimalFromDouble(d2);
        decimal = Decimal.round(decimal, n2, s2);
        return Decimal.to_DoubleFromDecimal(decimal);
    }

    public static double truncate(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return d2;
        }
        if (d2 > 0.0) {
            return msMath.floor(d2);
        }
        if (d2 < 0.0) {
            return msMath.ceiling(d2);
        }
        return d2;
    }

    public static Decimal truncate(Decimal d2) {
        return Decimal.truncate(d2);
    }

    public static Decimal floor(Decimal d2) {
        return Decimal.floor(d2);
    }

    public static int sign(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromInt(0))) {
            return 1;
        }
        return Decimal.op_Equality(value, Decimal.newDecimalFromInt(0)) ? 0 : -1;
    }

    public static int sign(double value) {
        if (DoubleExtensions.isNaN(value)) {
            throw new ArithmeticException("NAN");
        }
        if (value > 0.0) {
            return 1;
        }
        return value == 0.0 ? 0 : -1;
    }

    public static int sign(float value) {
        if (SingleExtensions.isNaN(value)) {
            throw new ArithmeticException("NAN");
        }
        if (value > 0.0f) {
            return 1;
        }
        return value == 0.0f ? 0 : -1;
    }

    public static int sign(int value) {
        if (value > 0) {
            return 1;
        }
        return value == 0 ? 0 : -1;
    }

    public static int sign(long value) {
        if (value > 0L) {
            return 1;
        }
        return value == 0L ? 0 : -1;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static int sign(byte value) {
        if (value > 0) {
            return 1;
        }
        return value == 0 ? 0 : -1;
    }

    public static int sign(short value) {
        if (value > 0) {
            return 1;
        }
        return value == 0 ? 0 : -1;
    }

    public static double sin(double value) {
        return Math.sin(value);
    }

    public static double cos(double value) {
        return Math.cos(value);
    }

    public static double tan(double value) {
        return Math.tan(value);
    }

    public static double sinh(double value) {
        return Math.sinh(value);
    }

    public static double cosh(double value) {
        return Math.cosh(value);
    }

    public static double tanh(double value) {
        return Math.tanh(value);
    }

    public static double acos(double value) {
        return Math.acos(value);
    }

    public static double asin(double value) {
        return Math.asin(value);
    }

    public static double atan(double value) {
        return Math.atan(value);
    }

    public static double atan2(double y2, double x2) {
        return Math.atan2(y2, x2);
    }

    public static double exp(double value) {
        return Math.exp(value);
    }

    public static double log(double value) {
        return Math.log(value);
    }

    public static double log10(double value) {
        return Math.log10(value);
    }

    public static double pow(double x2, double y2) {
        if (DoubleExtensions.isNaN(x2)) {
            return Double.NaN;
        }
        return Math.pow(x2, y2);
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }
}

