/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Reflection.MethodInfo;
import com.aspose.html.internal.ms.System.Reflection.ParameterInfo;
import com.aspose.html.internal.ms.System.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class ConversionUtils {
    private static boolean[][] a = new boolean[][]{{true, false, false, true, true, true, true}, {false, true, true, true, true, true, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, true, true, true}, {false, false, false, false, false, true, false}, {false, false, false, false, false, true, true}};

    public static boolean isCompatible(Method method, Class<?> ... params) {
        Class<?>[] classArray = method.getParameterTypes();
        if (params.length != classArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (ConversionUtils.isCompatible(params[i2], classArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatible(Method method, Object ... params) {
        Class<?>[] classArray = method.getParameterTypes();
        if (params.length != classArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (params[i2] == null) {
                return !classArray[i2].isPrimitive();
            }
            if (ConversionUtils.isCompatible(params[i2].getClass(), classArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatible(Constructor constructor, Class<?> ... params) {
        Class<?>[] classArray = constructor.getParameterTypes();
        if (params.length != classArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (ConversionUtils.isCompatible(params[i2], classArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatible(Constructor constructor, Object ... params) {
        Class<?>[] classArray = constructor.getParameterTypes();
        if (params.length != classArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (params[i2] == null) {
                return !classArray[i2].isPrimitive();
            }
            if (ConversionUtils.isCompatible(params[i2].getClass(), classArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSame(MethodInfo method, Type ... params) {
        ParameterInfo[] parameterInfoArray = method.getParameters();
        if (params.length != parameterInfoArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (ConversionUtils.isSame(params[i2].getJavaClass(), parameterInfoArray[i2].getParameterType().getJavaClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSame(Method method, Class<?> ... params) {
        Class<?>[] classArray = method.getParameterTypes();
        if (params.length != classArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (ConversionUtils.isSame(params[i2], classArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatible(Class<?> aClass, Class<?> bClass) {
        return bClass.isAssignableFrom(aClass) || aClass.isPrimitive() && bClass.isAssignableFrom(ConversionUtils.getBoxedClass(aClass)) || bClass.isPrimitive() && ConversionUtils.isBoxedTypeOf(aClass, bClass) || bClass.isArray() && Array.class.isAssignableFrom(aClass) || aClass.isArray() && Array.class.isAssignableFrom(bClass) || ConversionUtils.isConvertible(aClass, bClass);
    }

    private static byte a(Class<?> clazz) {
        if (clazz.equals(Character.TYPE)) {
            return 0;
        }
        if (clazz.equals(Byte.TYPE)) {
            return 1;
        }
        if (clazz.equals(Short.TYPE)) {
            return 2;
        }
        if (clazz.equals(Integer.TYPE)) {
            return 3;
        }
        if (clazz.equals(Long.TYPE)) {
            return 4;
        }
        if (clazz.equals(Double.TYPE)) {
            return 5;
        }
        if (clazz.equals(Float.TYPE)) {
            return 6;
        }
        return -1;
    }

    public static boolean isConvertible(Class<?> aClass, Class<?> bClass) {
        if (!bClass.isPrimitive()) {
            return bClass.equals(aClass);
        }
        if (!aClass.isPrimitive()) {
            aClass = ConversionUtils.getUnboxedClass(aClass);
        }
        if (aClass == null) {
            return false;
        }
        byte by2 = ConversionUtils.a(bClass);
        byte by3 = ConversionUtils.a(aClass);
        if (by2 == -1 || by3 == -1) {
            return false;
        }
        return a[by3][by2];
    }

    public static boolean isSame(Class<?> aClass, Class<?> bClass) {
        return ObjectExtensions.equals(aClass, bClass);
    }

    public static Class getBoxedClass(Class<?> primitive) {
        Class clazz = null;
        if (primitive.equals(Byte.TYPE)) {
            clazz = Byte.class;
        } else if (primitive.equals(Short.TYPE)) {
            clazz = Short.class;
        } else if (primitive.equals(Integer.TYPE)) {
            clazz = Integer.class;
        } else if (primitive.equals(Long.TYPE)) {
            clazz = Long.class;
        } else if (primitive.equals(Float.TYPE)) {
            clazz = Float.class;
        } else if (primitive.equals(Double.TYPE)) {
            clazz = Double.class;
        } else if (primitive.equals(Boolean.TYPE)) {
            clazz = Boolean.class;
        } else if (primitive.equals(Character.TYPE)) {
            clazz = Character.class;
        } else if (primitive.equals(Void.TYPE)) {
            clazz = Void.class;
        }
        return clazz;
    }

    public static Class getUnboxedClass(Class<?> aClass) {
        Class<Object> clazz = null;
        if (aClass.equals(Byte.class)) {
            clazz = Byte.TYPE;
        } else if (aClass.equals(Short.class)) {
            clazz = Short.TYPE;
        } else if (aClass.equals(Integer.class)) {
            clazz = Integer.TYPE;
        } else if (aClass.equals(Long.class)) {
            clazz = Long.TYPE;
        } else if (aClass.equals(Float.class)) {
            clazz = Float.TYPE;
        } else if (aClass.equals(Double.class)) {
            clazz = Double.TYPE;
        } else if (aClass.equals(Boolean.class)) {
            clazz = Boolean.TYPE;
        } else if (aClass.equals(Character.class)) {
            clazz = Character.TYPE;
        } else if (aClass.equals(Void.class)) {
            clazz = Void.TYPE;
        }
        return clazz;
    }

    public static boolean isBoxedTypeOf(Class<?> aClass, Class<?> primitive) {
        return ObjectExtensions.equals(aClass, ConversionUtils.getBoxedClass(primitive));
    }

    public static boolean isUnboxedTypeOf(Class<?> primitive, Class<?> bClass) {
        return ObjectExtensions.equals(primitive, ConversionUtils.getUnboxedClass(bClass));
    }
}

