/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.CMYKColor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccCmm;
import com.aspose.html.internal.ms.lang.Operators;

public class CMYKHelper {
    public static CMYKColor[] toCMYK(int[] pixels) {
        CMYKColor[] cMYKColorArray = (CMYKColor[])Array.unboxing(Array.createInstance(Operators.typeOf(CMYKColor.class), pixels.length));
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int n2 = msMath.min(msMath.min(255 - (ColorHelper.fromArgb(pixels[i2]).getBlue() & 0xFF), 255 - (ColorHelper.fromArgb(pixels[i2]).getGreen() & 0xFF)), 255 - (ColorHelper.fromArgb(pixels[i2]).getRed() & 0xFF));
            if (n2 < 255) {
                int n3 = 255 * (255 - (ColorHelper.fromArgb(pixels[i2]).getRed() & 0xFF) - n2) / (255 - n2);
                int n4 = 255 * (255 - (ColorHelper.fromArgb(pixels[i2]).getGreen() & 0xFF) - n2) / (255 - n2);
                int n5 = 255 * (255 - (ColorHelper.fromArgb(pixels[i2]).getBlue() & 0xFF) - n2) / (255 - n2);
                CMYKColor.fromParams(n3, n4, n5, n2).CloneTo(cMYKColorArray[i2]);
                continue;
            }
            CMYKColor.fromParams(0, 0, 0, n2).CloneTo(cMYKColorArray[i2]);
        }
        return cMYKColorArray;
    }

    public static CMYKColor toCMYK(int pixel) {
        int n2 = msMath.min(msMath.min(255 - (ColorHelper.fromArgb(pixel).getBlue() & 0xFF), 255 - (ColorHelper.fromArgb(pixel).getGreen() & 0xFF)), 255 - (ColorHelper.fromArgb(pixel).getRed() & 0xFF));
        if (n2 < 255) {
            int n3 = 255 * (255 - (ColorHelper.fromArgb(pixel).getRed() & 0xFF) - n2) / (255 - n2);
            int n4 = 255 * (255 - (ColorHelper.fromArgb(pixel).getGreen() & 0xFF) - n2) / (255 - n2);
            int n5 = 255 * (255 - (ColorHelper.fromArgb(pixel).getBlue() & 0xFF) - n2) / (255 - n2);
            return CMYKColor.fromParams(n3, n4, n5, n2);
        }
        return CMYKColor.fromParams(0, 0, 0, n2);
    }

    public static int[] toColor(CMYKColor[] pixels) {
        int[] nArray = new int[pixels.length];
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            nArray[i2] = ColorHelper.toArgb(ColorHelper.fromArgb((255 - (pixels[i2].getC() & 0xFF)) * (255 - (pixels[i2].getK() & 0xFF)) / 255, (255 - (pixels[i2].getM() & 0xFF)) * (255 - (pixels[i2].getK() & 0xFF)) / 255, (255 - (pixels[i2].getY() & 0xFF)) * (255 - (pixels[i2].getK() & 0xFF)) / 255));
        }
        return nArray;
    }

    public static int toColor(CMYKColor pixel) {
        int n2 = msMath.min(255, (pixel.getC() & 0xFF) + (pixel.getK() & 0xFF));
        int n3 = msMath.min(255, (pixel.getM() & 0xFF) + (pixel.getK() & 0xFF));
        int n4 = msMath.min(255, (pixel.getY() & 0xFF) + (pixel.getK() & 0xFF));
        return ColorHelper.toArgb(ColorHelper.fromArgb(255 - (pixel.getC() & 0xFF), 255 - (pixel.getM() & 0xFF), 255 - (pixel.getY() & 0xFF)));
    }

    public static int toColorIcc(CMYKColor cmykPixel, Stream cmykIccStream, Stream rgbIccStream) {
        IccCmm iccCmm = new IccCmm(cmykIccStream, rgbIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        long l2 = cmykPixel.toValue();
        dArray2[0] = (double)(l2 >> 24 & 0xFFL) / 255.0;
        dArray2[1] = (double)(l2 >> 16 & 0xFFL) / 255.0;
        dArray2[2] = (double)(l2 >> 8 & 0xFFL) / 255.0;
        dArray2[3] = (double)(l2 & 0xFFL) / 255.0;
        iccCmm.apply(dArray2, dArray);
        return ColorHelper.toArgb((byte)(dArray[0] * 255.0), (byte)(dArray[1] * 255.0), (byte)(dArray[2] * 255.0));
    }

    public static int[] toColorIcc(CMYKColor[] cmykPixels) {
        return CMYKHelper.toColorIcc(cmykPixels, IccProfileHelper.getDefaultCmykProfile().getStream(), IccProfileHelper.getDefaultRGBProfile().getStream());
    }

    public static int toColorIcc(CMYKColor cmykPixel) {
        return CMYKHelper.toColorIcc(cmykPixel.Clone(), IccProfileHelper.getDefaultCmykProfile().getStream(), IccProfileHelper.getDefaultRGBProfile().getStream());
    }

    public static int[] toColorIcc(CMYKColor[] cmykPixels, Stream cmykIccStream, Stream rgbIccStream) {
        IccCmm iccCmm = new IccCmm(cmykIccStream, rgbIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        int[] nArray = ArrayHelper.getColors(cmykPixels.length);
        for (int i2 = 0; i2 < cmykPixels.length; ++i2) {
            long l2 = cmykPixels[i2].toValue();
            dArray2[0] = (double)(l2 >> 24 & 0xFFL) / 255.0;
            dArray2[1] = (double)(l2 >> 16 & 0xFFL) / 255.0;
            dArray2[2] = (double)(l2 >> 8 & 0xFFL) / 255.0;
            dArray2[3] = (double)(l2 & 0xFFL) / 255.0;
            iccCmm.apply(dArray2, dArray);
            nArray[i2] = ColorHelper.toArgb((byte)(dArray[0] * 255.0), (byte)(dArray[1] * 255.0), (byte)(dArray[2] * 255.0));
        }
        return nArray;
    }

    public static CMYKColor[] toCMYKIcc(int[] pixels, Stream rgbIccStream, Stream cmykIccStream) {
        IccCmm iccCmm = new IccCmm(rgbIccStream, cmykIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        CMYKColor[] cMYKColorArray = (CMYKColor[])Array.unboxing(Array.createInstance(Operators.typeOf(CMYKColor.class), pixels.length));
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int n2 = pixels[i2];
            dArray[0] = (double)(n2 >> 16 & 0xFF) / 255.0;
            dArray[1] = (double)(n2 >> 8 & 0xFF) / 255.0;
            dArray[2] = (double)(n2 & 0xFF) / 255.0;
            iccCmm.apply(dArray, dArray2);
            cMYKColorArray[i2] = CMYKColor.fromParams((byte)(255.0 * dArray2[0]), (byte)(255.0 * dArray2[1]), (byte)(255.0 * dArray2[2]), (byte)(255.0 * dArray2[3]));
        }
        return cMYKColorArray;
    }

    public static CMYKColor[] toCMYKIcc(int[] pixels) {
        return CMYKHelper.toCMYKIcc(pixels, IccProfileHelper.getDefaultRGBProfile().getStream(), IccProfileHelper.getDefaultCmykProfile().getStream());
    }

    public static CMYKColor toCMYKIcc(int pixel) {
        return CMYKHelper.toCMYKIcc(pixel, IccProfileHelper.getDefaultRGBProfile().getStream(), IccProfileHelper.getDefaultCmykProfile().getStream());
    }

    public static CMYKColor toCMYKIcc(int pixel, Stream rgbIccStream, Stream cmykIccStream) {
        IccCmm iccCmm = new IccCmm(rgbIccStream, cmykIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        int n2 = pixel;
        dArray[0] = (double)(n2 >> 16 & 0xFF) / 255.0;
        dArray[1] = (double)(n2 >> 8 & 0xFF) / 255.0;
        dArray[2] = (double)(n2 & 0xFF) / 255.0;
        iccCmm.apply(dArray, dArray2);
        return CMYKColor.fromParams((byte)(255.0 * dArray2[0]), (byte)(255.0 * dArray2[1]), (byte)(255.0 * dArray2[2]), (byte)(255.0 * dArray2[3]));
    }
}

