/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.lang.Operators;

public final class FileStreamContainer
extends StreamContainer {
    private final boolean a;
    private final String b;
    private boolean c;

    private FileStreamContainer(FileStream stream, boolean isCreated, boolean isTemporal, boolean disposeStream) {
        super(stream, disposeStream);
        this.a = isCreated;
        this.c = isTemporal;
        this.b = stream.getName();
    }

    public boolean isTemporal() {
        this.verifyNotDisposed();
        return this.c;
    }

    public void isTemporal(boolean value) {
        this.verifyNotDisposed();
        this.a();
        this.c = value;
    }

    public boolean isCreated() {
        this.verifyNotDisposed();
        return this.a;
    }

    public String getFilePath() {
        this.verifyNotDisposed();
        return this.b;
    }

    public static Stream to_Stream(FileStreamContainer fileStreamContainer) {
        Stream stream = null;
        if (fileStreamContainer != null) {
            stream = fileStreamContainer.getStream();
        }
        return stream;
    }

    public static FileStream to_FileStream(FileStreamContainer fileStreamContainer) {
        FileStream fileStream = null;
        if (fileStreamContainer != null) {
            fileStream = (FileStream)fileStreamContainer.getStream();
        }
        return fileStream;
    }

    static FileStreamContainer createFileStream(String fileLocation, boolean isTemporal) {
        if (StringExtensions.isNullOrEmpty(fileLocation)) {
            throw new ArgumentNullException("fileLocation");
        }
        return new FileStreamContainer(File.create(fileLocation), true, isTemporal, true);
    }

    static FileStreamContainer openFileStream(String fileLocation) {
        if (StringExtensions.isNullOrEmpty(fileLocation)) {
            throw new ArgumentNullException("fileLocation");
        }
        return new FileStreamContainer(File.open(fileLocation, 3), false, false, true);
    }

    @Override
    protected void afterStreamDisposed() {
        if (this.a && this.c) {
            File.delete(this.b);
            this.c = false;
        }
        super.afterStreamDisposed();
    }

    @Override
    public void beforeSave(Stream destinationStream) {
        FileStream fileStream = Operators.as(destinationStream, FileStream.class);
        if (fileStream != null && StringExtensions.equals(StringExtensions.toLower(fileStream.getName()), StringExtensions.toLower(this.b))) {
            throw new ArgumentException("Saving to the same stream is not allowed.");
        }
        super.beforeSave(destinationStream);
    }

    private void a() {
        if (!this.a) {
            throw new IllegalStateException("The stream was not created explicitly and cannot be marked as temporal or persistent.");
        }
    }
}

