/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DataStreamSupporter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Size;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IObjectWithBounds;
import java.awt.Color;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds {
    private Image a;
    private boolean b = true;
    private IColorPalette c;

    protected Image() {
    }

    protected Image(IColorPalette colorPalette) {
        this.c = colorPalette;
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty().Clone(), this.getSize().Clone());
    }

    public Image getContainer() {
        return this.a;
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.c;
    }

    public void setPalette(IColorPalette value) {
        if (this.c != value) {
            IColorPalette iColorPalette = this.c;
            this.onPaletteChanging(iColorPalette, value);
            this.c = value;
            this.onPaletteChanged(iColorPalette, value);
        }
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    boolean isWatermarkPartlyVisible() {
        return this.b;
    }

    void isWatermarkPartlyVisible(boolean value) {
        this.b = value;
    }

    public boolean hasBackgroundColor() {
        return false;
    }

    public void setBackgroundColor(boolean value) {
    }

    public int getBackgroundColor() {
        return Color.WHITE.getRGB();
    }

    public void setBackgroundColor(int value) {
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int width, int height) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), new Rectangle(new Point(), new Size(msMath.abs(width), msMath.abs(height)))).Clone();
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] pixels, int width, int height) {
        if (pixels == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle.Clone(), width, height).Clone();
        if (pixels.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = StringExtensions.format("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", rectangle2.getWidth() * rectangle2.getHeight(), pixels.length);
            throw new ArgumentException(string);
        }
        return rectangle2;
    }

    public void resize(int newWidth, int newHeight) {
        this.resize(newWidth, newHeight, 1);
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void rotateFlip(int var1);

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public void setContainer(Image container) {
        this.a = container;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle.Clone(), this.getWidth(), this.getHeight());
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] pixels) {
        return Image.getFittingRectangle(rectangle.Clone(), pixels, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    protected void onPaletteChanging(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    @Override
    protected void releaseManagedResources() {
        this.a = null;
        this.c = null;
        super.releaseManagedResources();
    }
}

