/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PointF;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Size;
import com.aspose.html.internal.ms.lang.Struct;

@SerializableAttribute
public class SizeF
extends Struct<SizeF> {
    private static final SizeF a = new SizeF();
    private float b;
    private float c;

    public SizeF() {
    }

    public SizeF(SizeF size) {
        this.b = size.b;
        this.c = size.c;
    }

    public SizeF(PointF point) {
        this.b = point.getX();
        this.c = point.getY();
    }

    public SizeF(float width, float height) {
        this.b = width;
        this.c = height;
    }

    public static SizeF getEmpty() {
        return a;
    }

    public boolean isEmpty() {
        return this.b == 0.0f && this.c == 0.0f;
    }

    public float getWidth() {
        return this.b;
    }

    public void setWidth(float value) {
        this.b = value;
    }

    public float getHeight() {
        return this.c;
    }

    public void setHeight(float value) {
        this.c = value;
    }

    public static SizeF op_Addition(SizeF size1, SizeF size2) {
        return SizeF.add(size1.Clone(), size2.Clone());
    }

    public static SizeF op_Subtraction(SizeF size1, SizeF size2) {
        return SizeF.subtract(size1.Clone(), size2.Clone());
    }

    public static boolean op_Equality(SizeF size1, SizeF size2) {
        return size1.getWidth() == size2.getWidth() && size1.getHeight() == size2.getHeight();
    }

    public static boolean op_Inequality(SizeF size1, SizeF size2) {
        return !SizeF.op_Equality(size1, size2);
    }

    public static PointF to_PointF(SizeF size) {
        return new PointF(size.getWidth(), size.getHeight());
    }

    public static SizeF add(SizeF size1, SizeF size2) {
        return new SizeF(size1.getWidth() + size2.getWidth(), size1.getHeight() + size2.getHeight());
    }

    public static SizeF subtract(SizeF size1, SizeF size2) {
        return new SizeF(size1.getWidth() - size2.getWidth(), size1.getHeight() - size2.getHeight());
    }

    public PointF toPointF() {
        return SizeF.to_PointF(this);
    }

    public Size toSize() {
        return Size.truncate(this.Clone());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SizeF)) {
            return false;
        }
        SizeF sizeF = ((SizeF)obj).Clone();
        return sizeF.getWidth() == this.getWidth() && sizeF.getHeight() == this.getHeight() && ObjectExtensions.getType(sizeF).equals(ObjectExtensions.getType(this));
    }

    public int hashCode() {
        return (int)this.b ^ (int)this.c;
    }

    public String toString() {
        return StringExtensions.concat("{Width=", SingleExtensions.toString(this.b, CultureInfo.getCurrentCulture()), ", Height=", SingleExtensions.toString(this.c, CultureInfo.getCurrentCulture()), "}");
    }

    @Override
    public void CloneTo(SizeF that) {
        that.b = this.b;
        that.c = this.c;
    }

    @Override
    public SizeF Clone() {
        SizeF sizeF = new SizeF();
        this.CloneTo(sizeF);
        return sizeF;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(SizeF obj1, SizeF obj2) {
        return obj1.equals(obj2);
    }
}

