/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors;

import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.CRC32;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.ZlibEncoder;

public class DeflateCompressStream
extends Stream {
    protected int _bufferSize = 8192;
    protected byte[] _workingBuffer;
    protected Stream stream;
    private CRC32 a;
    private final boolean b;
    private final int c;
    private final boolean d;
    private boolean e;
    private ZlibEncoder f;

    public DeflateCompressStream(Stream stream, int level, boolean wantRfc1950Header, boolean leaveOpen) {
        this.stream = stream;
        this.b = leaveOpen;
        this.c = level;
        this.d = wantRfc1950Header;
    }

    @Override
    public boolean canRead() {
        return this.stream.canRead();
    }

    @Override
    public boolean canSeek() {
        return this.stream.canSeek();
    }

    @Override
    public boolean canWrite() {
        return this.stream.canWrite();
    }

    @Override
    public long getLength() {
        return this.stream.getLength();
    }

    @Override
    public long getPosition() {
        throw new NotImplementedException();
    }

    @Override
    public void setPosition(long value) {
        throw new NotImplementedException();
    }

    int getCrc32() {
        if (this.a == null) {
            return 0;
        }
        return this.a.getCrc32Result();
    }

    private ZlibEncoder a() {
        if (this.f == null) {
            this.f = new ZlibEncoder();
            this.f.Strategy = 0;
            this.f.initializeDeflate(this.c, this.d);
        }
        return this.f;
    }

    private byte[] b() {
        if (this._workingBuffer == null) {
            this._workingBuffer = new byte[this._bufferSize];
        }
        return this._workingBuffer;
    }

    @Override
    public void close() {
        if (this.stream == null) {
            return;
        }
        try {
            this.c();
        }
        finally {
            if (this.a() != null) {
                this.f.endDeflate();
            }
            if (!this.b) {
                this.stream.close();
            }
            this.stream = null;
        }
    }

    @Override
    public void flush() {
        this.stream.flush();
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        throw new NotImplementedException();
    }

    @Override
    public long seek(long offset, int origin) {
        throw new NotImplementedException();
    }

    @Override
    public void setLength(long value) {
        this.stream.setLength(value);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        boolean bl2;
        if (this.a != null) {
            this.a.slurpBlock(buffer, offset, count);
        }
        if (count == 0) {
            return;
        }
        this.a().InputBuffer = buffer;
        this.f.NextIn = offset;
        this.f.AvailableBytesIn = count;
        do {
            this.f.OutputBuffer = this.b();
            this.f.NextOut = 0;
            this.f.AvailableBytesOut = this._workingBuffer.length;
            int n2 = this.f.deflate(false);
            if (n2 != 0 && n2 != 1) {
                throw new InvalidOperationException(StringExtensions.format("CompressorException: deflating error.", new Object[0]));
            }
            this.stream.write(this._workingBuffer, 0, this._workingBuffer.length - this.f.AvailableBytesOut);
        } while (!(bl2 = this.f.AvailableBytesIn == 0 && this.f.AvailableBytesOut != 0));
    }

    @Override
    protected void dispose(boolean disposing) {
        if (!this.e) {
            if (disposing && this.stream != null) {
                this.close();
            }
            this.e = true;
        }
    }

    private void c() {
        boolean bl2;
        if (this.f == null) {
            return;
        }
        do {
            this.f.OutputBuffer = this.b();
            this.f.NextOut = 0;
            this.f.AvailableBytesOut = this._workingBuffer.length;
            int n2 = this.f.deflate(true);
            if (n2 != 1 && n2 != 0) {
                throw new InvalidOperationException(StringExtensions.format("CompressorException: deflating error.", new Object[0]));
            }
            if (this._workingBuffer.length - this.f.AvailableBytesOut <= 0) continue;
            this.stream.write(this._workingBuffer, 0, this._workingBuffer.length - this.f.AvailableBytesOut);
        } while (!(bl2 = this.f.AvailableBytesIn == 0 && this.f.AvailableBytesOut != 0));
        this.flush();
    }
}

