/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.makernoteparser;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.makernoteparser.IMakerNoteParser;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffBigEndianStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.loaders.TiffLoader;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

class OlympusParser
implements IMakerNoteParser {
    private static final StringSwitchMap a = new StringSwitchMap("OLYMP\u0000", "PENT");

    OlympusParser() {
    }

    @Override
    public boolean parse(byte[] data, boolean isBigEndian, List<TiffDataType>[] result) {
        try {
            String string = Encoding.getASCII().getString(data, 0, data.length);
            int n2 = 0;
            switch (a.of(string)) {
                case 0: {
                    n2 = 8;
                    break;
                }
                case 1: {
                    string = Encoding.getUTF8().getString(data, 0, 8);
                    if (!"OLYMPUS\u0000II".equals(string)) break;
                    n2 = 12;
                    break;
                }
                default: {
                    return false;
                }
            }
            result[0].addRange(Array.toGenericList(isBigEndian ? TiffLoader.readDirectoryEntry(new TiffBigEndianStream(new MemoryStream(data, n2, data.length - n2))) : TiffLoader.readDirectoryEntry(new TiffStream(new MemoryStream(data, n2, data.length - n2)))));
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

