/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.internal;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;

public class ImageCorrection {
    public static void gammaCorrection(int[] image, float gammaR, float gammaG, float gammaB) {
        int n2;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            byArray[n2] = Operators.castToByte(msMath.min(255, Operators.castToInt32(255.0 * msMath.pow((double)n2 / 255.0, 1.0 / (double)gammaR) + 0.5, 14)), 9);
            byArray2[n2] = Operators.castToByte(msMath.min(255, Operators.castToInt32(255.0 * msMath.pow((double)n2 / 255.0, 1.0 / (double)gammaG) + 0.5, 14)), 9);
            byArray3[n2] = Operators.castToByte(msMath.min(255, Operators.castToInt32(255.0 * msMath.pow((double)n2 / 255.0, 1.0 / (double)gammaB) + 0.5, 14)), 9);
        }
        for (n2 = 0; n2 < image.length; ++n2) {
            int n3 = image[n2];
            int n4 = n3 >> 24 & 0xFF;
            int n5 = n3 >> 16 & 0xFF;
            int n6 = n3 >> 8 & 0xFF;
            int n7 = n3 & 0xFF;
            image[n2] = n4 << 24 | Operators.castToInt32(byArray[n5], 6) << 16 | Operators.castToInt32(byArray2[n6], 6) << 8 | Operators.castToInt32(byArray3[n7], 6);
        }
    }

    public static void correctBrightness(int[] image, int brightness) {
        if (brightness < -255) {
            brightness = -255;
        }
        if (brightness > 255) {
            brightness = 255;
        }
        for (int i2 = 0; i2 < image.length; ++i2) {
            int n2;
            int n3;
            int n4 = image[i2];
            int n5 = n4 >> 24 & 0xFF;
            int n6 = n4 >> 16 & 0xFF;
            int n7 = n4 >> 8 & 0xFF;
            int n8 = n4 & 0xFF;
            int n9 = n6 + brightness;
            if (n9 < 0) {
                n9 = 0;
            }
            if (n9 > 255) {
                n9 = 255;
            }
            if ((n3 = n7 + brightness) < 0) {
                n3 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            if ((n2 = n8 + brightness) < 0) {
                n2 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            image[i2] = n5 << 24 | n9 << 16 | n3 << 8 | n2;
        }
    }

    public static void correctContrast(int[] image, float contrast) {
        if (contrast < -100.0f) {
            contrast = -100.0f;
        }
        if (contrast > 100.0f) {
            contrast = 100.0f;
        }
        contrast = (100.0f + contrast) / 100.0f;
        contrast *= contrast;
        for (int i2 = 0; i2 < image.length; ++i2) {
            int n2 = image[i2];
            int n3 = n2 >> 24 & 0xFF;
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            float f2 = (float)n4 / 255.0f;
            float f3 = (float)n5 / 255.0f;
            float f4 = (float)n6 / 255.0f;
            f2 = ((f2 - 0.5f) * contrast + 0.5f) * 255.0f;
            f3 = ((f3 - 0.5f) * contrast + 0.5f) * 255.0f;
            f4 = ((f4 - 0.5f) * contrast + 0.5f) * 255.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 255.0f) {
                f2 = 255.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            if (f3 > 255.0f) {
                f3 = 255.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            if (f4 > 255.0f) {
                f4 = 255.0f;
            }
            image[i2] = n3 << 24 | Operators.castToInt32(Operators.castToByte(Float.valueOf(f2), 13), 6) << 16 | Operators.castToInt32(Operators.castToByte(Float.valueOf(f3), 13), 6) << 8 | Operators.castToInt32(Operators.castToByte(Float.valueOf(f4), 13), 6);
        }
    }

    public static byte getThresholdOtsuMethod(int[] colors) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = new int[256];
        int[] nArray2 = colors;
        int n7 = nArray2.length;
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = nArray2[n6];
            n4 = n5 >> 16 & 0xFF;
            int n8 = n5 >> 8 & 0xFF;
            n3 = n5 & 0xFF;
            int n9 = n2 = Operators.castToInt32(0.2126 * (double)n4 + 0.7152 * (double)n8 + 0.0722 * (double)n3, 14);
            nArray[n9] = nArray[n9] + 1;
        }
        int n10 = colors.length;
        float f2 = 0.0f;
        for (n6 = 0; n6 < 256; ++n6) {
            f2 += (float)(n6 * nArray[n6]);
        }
        float f3 = 0.0f;
        n5 = 0;
        float f4 = 0.0f;
        n3 = 0;
        for (n2 = 0; n2 < 256; ++n2) {
            if ((n5 += nArray[n2]) == 0) continue;
            n4 = n10 - n5;
            if (n4 == 0) break;
            float f5 = (f3 += (float)(n2 * nArray[n2])) / (float)n5;
            float f6 = (f2 - f3) / (float)n4;
            float f7 = Operators.castToFloat(n5, 9) * (float)n4 * (f5 - f6) * (f5 - f6);
            if (!(f7 > f4)) continue;
            f4 = f7;
            n3 = n2;
        }
        return Operators.castToByte(n3, 9);
    }
}

