/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;

class ColorFromRGB24Converter
implements IPartialRawDataLoader {
    private final IPartialArgb32PixelLoader a;

    public ColorFromRGB24Converter(IPartialArgb32PixelLoader loader) {
        this.a = loader;
    }

    @Override
    public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
        if (data.length % 3 != 0) {
            throw new ArgumentException("Data must contain 3 bytes for each pixel.");
        }
        int[] nArray = new int[data.length / 3];
        int n2 = 0;
        for (int i2 = 0; i2 < data.length; i2 += 3) {
            nArray[n2++] = 0xFF000000 | (data[i2 + 2] & 0xFF) << 16 | (data[i2 + 1] & 0xFF) << 8 | data[i2] & 0xFF;
        }
        this.a.process(rectangle.Clone(), nArray, start.Clone(), end.Clone());
    }

    @Override
    public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
        throw new NotImplementedException();
    }
}

