/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png;

import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.PngImageException;
import com.aspose.html.internal.ms.lang.Operators;

public class PngStream
extends StreamContainer {
    public PngStream(Stream stream) {
        super(stream);
    }

    PngStream(Stream stream, boolean disposeStream) {
        super(stream, disposeStream);
    }

    public int read2Bytes() {
        byte[] byArray = new byte[2];
        int n2 = this.read(byArray, 0, byArray.length);
        if (n2 < byArray.length) {
            throw new PngImageException("Could not read data.");
        }
        return Operators.castToUInt16((Operators.castToInt32(byArray[0], 6) << 8) + Operators.castToInt32(byArray[1], 6), 9);
    }

    public int read4Bytes() {
        byte[] byArray = new byte[4];
        int n2 = this.read(byArray, 0, byArray.length);
        if (n2 < byArray.length) {
            throw new PngImageException("Could not read data.");
        }
        return (Operators.castToInt32(byArray[0], 6) << 24) + (Operators.castToInt32(byArray[1], 6) << 16) + (Operators.castToInt32(byArray[2], 6) << 8) + Operators.castToInt32(byArray[3], 6);
    }

    public void write2Bytes(int data) {
        byte[] byArray = new byte[]{Operators.castToByte(Operators.castToUInt16(data, 8) >> 8 & 0xFF, 9), Operators.castToByte(Operators.castToInt32(data, 8) & 0xFF, 9)};
        this.write(byArray, 0, byArray.length);
    }

    public void write4Bytes(long data) {
        byte[] byArray = new byte[]{Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(data, 10) >> 24, 10) & 0xFFL, 10), 10), Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(data, 10) >> 16, 10) & 0xFFL, 10), 10), Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(data, 10) >> 8, 10) & 0xFFL, 10), 10), Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(data, 10) & 0xFFL, 10), 10)};
        this.write(byArray, 0, byArray.length);
    }
}

