/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccCurve;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccInvalidProfileException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccProfileReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccUtil;

class IccTagParametricCurve
extends IccCurve {
    private int a;
    private int b;

    IccTagParametricCurve() {
    }

    @Override
    public void read(IccProfileReader reader) {
        int n2;
        this._sig = (int)(reader.read32() & 0xFFFFFFFFL);
        this.verifyTagSignature();
        this._reserved = reader.read32();
        this.b = reader.read16();
        this.a = reader.read16();
        switch (this.b) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 7;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if ((n2 & 0xFFFF) != 0) {
            this._data = reader.read32fArray(n2 & 0xFFFF);
        }
    }

    @Override
    protected void verifyTagSignature() {
        if (this._sig != 1885434465) {
            throw new IccInvalidProfileException();
        }
    }

    @Override
    public boolean isIdentity() {
        switch (this.b) {
            case 0: {
                return IccUtil.isUnity(this._data[0]);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    @Override
    public float apply(float x2) {
        if ((double)x2 < 0.0) {
            x2 = 0.0f;
        }
        if ((double)x2 > 1.0) {
            x2 = 1.0f;
        }
        float f2 = 0.0f;
        switch (this.b) {
            case 0: {
                return (float)msMath.pow(x2, this._data[0]);
            }
            case 1: {
                if (x2 >= -this._data[2] / this._data[1]) {
                    f2 = (float)msMath.pow(this._data[1] * x2 + this._data[2], this._data[0]);
                    break;
                }
                return 0.0f;
            }
            case 2: {
                if (x2 >= -this._data[2] / this._data[1]) {
                    f2 = (float)msMath.pow((double)this._data[1] * (double)x2 + (double)this._data[2], this._data[0]) + this._data[3];
                    break;
                }
                f2 = this._data[3];
                break;
            }
            case 3: {
                if (x2 >= this._data[4]) {
                    f2 = (float)msMath.pow((double)this._data[1] * (double)x2 + (double)this._data[2], this._data[0]);
                    break;
                }
                f2 = this._data[3] * x2;
                break;
            }
            case 4: {
                if (x2 >= this._data[4]) {
                    f2 = (float)msMath.pow((double)this._data[1] * (double)x2 + (double)this._data[2], this._data[0]) + this._data[5];
                    break;
                }
                f2 = this._data[3] * x2 + this._data[6];
                break;
            }
            default: {
                return x2;
            }
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }
}

