/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.gif;

import com.aspose.html.internal.ms.System.Collections.Generic.List;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;

public class PaletteBuilder {
    protected static final int MAXLEVEL = 8;
    protected RenderedImage src;
    protected ColorModel srcColorModel;
    protected Raster srcRaster;
    protected int requiredSize;
    protected ColorNode root;
    protected int numNodes;
    protected int maxNodes;
    protected int currLevel;
    protected int currSize;
    protected ColorNode[] reduceList;
    protected ColorNode[] palette;
    protected int transparency;
    protected ColorNode transColor;

    public static RenderedImage createIndexedImage(RenderedImage src) {
        int n2 = src.getWidth() * src.getHeight();
        if (n2 < 256) {
            int n3 = -1;
            List<Color> list = new List<Color>();
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < src.getHeight(); ++i2) {
                for (int i3 = 0; i3 < src.getWidth(); ++i3) {
                    int n4 = ((BufferedImage)src).getRGB(i3, i2);
                    Color color = new Color(n4, true);
                    int n5 = i3 + i2 * src.getWidth();
                    if (!list.contains(color)) {
                        if (color.getAlpha() == 0) {
                            n3 = list.size();
                        }
                        nArray[n5] = list.size();
                        list.addItem(color);
                        continue;
                    }
                    nArray[n5] = list.indexOf(color);
                }
            }
            n2 = list.size();
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            for (int i4 = 0; i4 < n2; ++i4) {
                byArray[i4] = (byte)((Color)list.get_Item(i4)).getRed();
                byArray2[i4] = (byte)((Color)list.get_Item(i4)).getGreen();
                byArray3[i4] = (byte)((Color)list.get_Item(i4)).getBlue();
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, n2, byArray, byArray2, byArray3, n3);
            BufferedImage bufferedImage = new BufferedImage(src.getWidth(), src.getHeight(), 13, indexColorModel);
            for (int i5 = 0; i5 < src.getHeight(); ++i5) {
                for (int i6 = 0; i6 < src.getWidth(); ++i6) {
                    int n6 = i6 + i5 * src.getWidth();
                    bufferedImage.setRGB(i6, i5, ((BufferedImage)src).getRGB(i6, i5));
                }
            }
            return bufferedImage;
        }
        PaletteBuilder paletteBuilder = new PaletteBuilder(src);
        paletteBuilder.buildPalette();
        return paletteBuilder.getIndexedImage();
    }

    public static IndexColorModel createIndexColorModel(RenderedImage img) {
        PaletteBuilder paletteBuilder = new PaletteBuilder(img);
        paletteBuilder.buildPalette();
        return paletteBuilder.getIndexColorModel();
    }

    public static boolean canCreatePalette(ImageTypeSpecifier type) {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        return true;
    }

    public static boolean canCreatePalette(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(image);
        return PaletteBuilder.canCreatePalette(imageTypeSpecifier);
    }

    protected RenderedImage getIndexedImage() {
        IndexColorModel indexColorModel = this.getIndexColorModel();
        BufferedImage bufferedImage = new BufferedImage(this.src.getWidth(), this.src.getHeight(), 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bufferedImage.getWidth(); ++i3) {
                Color color = this.a(i3, i2);
                writableRaster.setSample(i3, i2, 0, this.findColorIndex(this.root, color));
            }
        }
        return bufferedImage;
    }

    protected PaletteBuilder(RenderedImage src) {
        this(src, Math.min(256, src.getHeight() * src.getWidth()));
    }

    protected PaletteBuilder(RenderedImage src, int size) {
        this.src = src;
        this.srcColorModel = src.getColorModel();
        this.srcRaster = src.getData();
        this.transparency = this.srcColorModel.getTransparency();
        if (this.transparency != 1) {
            this.requiredSize = size - 1;
            this.transColor = new ColorNode();
            this.transColor.isLeaf = true;
        } else {
            this.requiredSize = size;
        }
    }

    private Color a(int n2, int n3) {
        int n4 = this.srcColorModel.getRGB(this.srcRaster.getDataElements(n2, n3, null));
        return new Color(n4, this.transparency != 1);
    }

    protected int findColorIndex(ColorNode aNode, Color aColor) {
        if (this.transparency != 1 && aColor.getAlpha() != 255) {
            return 0;
        }
        if (aNode.isLeaf) {
            return aNode.paletteIndex;
        }
        int n2 = this.getBranchIndex(aColor, aNode.level);
        return this.findColorIndex(aNode.children[n2], aColor);
    }

    protected void buildPalette() {
        int n2;
        this.reduceList = new ColorNode[9];
        for (n2 = 0; n2 < this.reduceList.length; ++n2) {
            this.reduceList[n2] = null;
        }
        this.numNodes = 0;
        this.maxNodes = 0;
        this.root = null;
        this.currSize = 0;
        this.currLevel = 8;
        n2 = 0;
        int n3 = this.src.getWidth();
        int n4 = this.src.getHeight();
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Color color = this.a(n3 - i3 - 1, n4 - i2 - 1);
                if (this.transparency != 1 && color.getAlpha() != 255) {
                    if (n2 == 0) {
                        this.root = this.insertNode(this.root, color, 0);
                        n2 = 1;
                    }
                    this.transColor = this.insertNode(this.transColor, color, 0);
                } else {
                    this.root = this.insertNode(this.root, color, 0);
                }
                if (this.currSize <= this.requiredSize) continue;
                this.reduceTree();
            }
        }
    }

    protected ColorNode insertNode(ColorNode aNode, Color aColor, int aLevel) {
        if (aNode == null) {
            aNode = new ColorNode();
            ++this.numNodes;
            if (this.numNodes > this.maxNodes) {
                this.maxNodes = this.numNodes;
            }
            aNode.level = aLevel;
            boolean bl2 = aNode.isLeaf = aLevel > 8;
            if (aNode.isLeaf) {
                ++this.currSize;
            }
        }
        ++aNode.colorCount;
        aNode.red += (long)aColor.getRed();
        aNode.green += (long)aColor.getGreen();
        aNode.blue += (long)aColor.getBlue();
        if (!aNode.isLeaf) {
            int n2 = this.getBranchIndex(aColor, aLevel);
            if (aNode.children[n2] == null) {
                ++aNode.childCount;
                if (aNode.childCount == 2) {
                    aNode.nextReducible = this.reduceList[aLevel];
                    this.reduceList[aLevel] = aNode;
                }
            }
            aNode.children[n2] = this.insertNode(aNode.children[n2], aColor, aLevel + 1);
        }
        return aNode;
    }

    protected IndexColorModel getIndexColorModel() {
        int n2 = this.currSize;
        if (this.transparency == 2) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        this.palette = new ColorNode[n2];
        if (this.transparency == 2) {
            ++n3;
        }
        int n4 = this.findPaletteEntry(this.root, n3, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = null;
        indexColorModel = this.transparency == 2 ? new IndexColorModel(8, n2, byArray, byArray2, byArray3, 0) : new IndexColorModel(8, this.currSize, byArray, byArray2, byArray3);
        return indexColorModel;
    }

    protected int findPaletteEntry(ColorNode aNode, int index, byte[] red, byte[] green, byte[] blue) {
        if (aNode.isLeaf) {
            red[index] = (byte)(aNode.red / (long)aNode.colorCount);
            green[index] = (byte)(aNode.green / (long)aNode.colorCount);
            blue[index] = (byte)(aNode.blue / (long)aNode.colorCount);
            aNode.paletteIndex = index;
            this.palette[index] = aNode;
            ++index;
        } else {
            for (int i2 = 0; i2 < 8; ++i2) {
                if (aNode.children[i2] == null) continue;
                index = this.findPaletteEntry(aNode.children[i2], index, red, green, blue);
            }
        }
        return index;
    }

    protected int getBranchIndex(Color aColor, int aLevel) {
        if (aLevel > 8 || aLevel < 0) {
            throw new IllegalArgumentException("Invalid octree node depth: " + aLevel);
        }
        int n2 = 8 - aLevel;
        int n3 = 1 & (0xFF & aColor.getRed()) >> n2;
        int n4 = 1 & (0xFF & aColor.getGreen()) >> n2;
        int n5 = 1 & (0xFF & aColor.getBlue()) >> n2;
        int n6 = n3 << 2 | n4 << 1 | n5;
        return n6;
    }

    protected void reduceTree() {
        int n2;
        for (n2 = this.reduceList.length - 1; this.reduceList[n2] == null && n2 >= 0; --n2) {
        }
        ColorNode colorNode = this.reduceList[n2];
        if (colorNode == null) {
            return;
        }
        ColorNode colorNode2 = colorNode;
        int n3 = colorNode2.colorCount;
        int n4 = 1;
        while (colorNode2.nextReducible != null) {
            if (n3 > colorNode2.nextReducible.colorCount) {
                colorNode = colorNode2;
                n3 = colorNode2.colorCount;
            }
            colorNode2 = colorNode2.nextReducible;
            ++n4;
        }
        if (colorNode == this.reduceList[n2]) {
            this.reduceList[n2] = colorNode.nextReducible;
        } else {
            colorNode2 = colorNode.nextReducible;
            colorNode.nextReducible = colorNode2.nextReducible;
            colorNode = colorNode2;
        }
        if (colorNode.isLeaf) {
            return;
        }
        int n5 = colorNode.getLeafChildCount();
        colorNode.isLeaf = true;
        this.currSize -= n5 - 1;
        int n6 = colorNode.level;
        for (int i2 = 0; i2 < 8; ++i2) {
            colorNode.children[i2] = this.freeTree(colorNode.children[i2]);
        }
        colorNode.childCount = 0;
    }

    protected ColorNode freeTree(ColorNode aNode) {
        if (aNode == null) {
            return null;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            aNode.children[i2] = this.freeTree(aNode.children[i2]);
        }
        --this.numNodes;
        return null;
    }

    protected class ColorNode {
        public boolean isLeaf = false;
        public int childCount = 0;
        ColorNode[] children = new ColorNode[8];
        public int colorCount;
        public long red;
        public long blue;
        public long green;
        public int paletteIndex;
        public int level = 0;
        ColorNode nextReducible;

        public ColorNode() {
            for (int i2 = 0; i2 < 8; ++i2) {
                this.children[i2] = null;
            }
            this.colorCount = 0;
            this.blue = 0L;
            this.green = 0L;
            this.red = 0L;
            this.paletteIndex = 0;
        }

        public int getLeafChildCount() {
            if (this.isLeaf) {
                return 0;
            }
            int n2 = 0;
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                if (this.children[i2] == null) continue;
                if (this.children[i2].isLeaf) {
                    ++n2;
                    continue;
                }
                n2 += this.children[i2].getLeafChildCount();
            }
            return n2;
        }

        public int getRGB() {
            int n2 = (int)this.red / this.colorCount;
            int n3 = (int)this.green / this.colorCount;
            int n4 = (int)this.blue / this.colorCount;
            int n5 = 0xFF000000 | (0xFF & n2) << 16 | (0xFF & n3) << 8 | 0xFF & n4;
            return n5;
        }
    }
}

