/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLine;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkPLTE;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTRNS;

public class ImageLineHelper {
    private static final double a = 8.988465674311579E307;
    private static final double b = -8.988465674311579E307;

    public static int[] palette2rgb(ImageLine line, PngChunkPLTE pal, PngChunkTRNS trns, int[] buf) {
        boolean bl2 = trns != null;
        int n2 = bl2 ? 4 : 3;
        int n3 = line.imgInfo.cols * n2;
        if (buf == null || buf.length < n3) {
            buf = new int[n3];
        }
        if (!line.samplesUnpacked) {
            line = line.unpackToNewImageLine();
        }
        boolean bl3 = line.sampleType == ImageLine.SampleType.BYTE;
        int n4 = trns != null ? trns.getPalletteAlpha().length : 0;
        for (int i2 = 0; i2 < line.imgInfo.cols; ++i2) {
            int n5;
            int n6 = bl3 ? line.scanlineb[i2] & 0xFF : line.scanline[i2];
            pal.getEntryRgb(n6, buf, i2 * n2);
            if (!bl2) continue;
            buf[i2 * n2 + 3] = n5 = n6 < n4 ? trns.getPalletteAlpha()[n6] : 255;
        }
        return buf;
    }

    public static int[] palette2rgb(ImageLine line, PngChunkPLTE pal, int[] buf) {
        return ImageLineHelper.palette2rgb(line, pal, null, buf);
    }

    public static String infoFirstLastPixels(ImageLine line) {
        return line.imgInfo.channels == 1 ? String.format("first=(%d) last=(%d)", line.scanline[0], line.scanline[line.scanline.length - 1]) : String.format("first=(%d %d %d) last=(%d %d %d)", line.scanline[0], line.scanline[1], line.scanline[2], line.scanline[line.scanline.length - line.imgInfo.channels], line.scanline[line.scanline.length - line.imgInfo.channels + 1], line.scanline[line.scanline.length - line.imgInfo.channels + 2]);
    }

    public static String infoFull(ImageLine line) {
        ImageLineStats imageLineStats = new ImageLineStats(line);
        return "row=" + line.getRown() + " " + imageLineStats.toString() + "\n  " + ImageLineHelper.infoFirstLastPixels(line);
    }

    public static int getPixelRGB8(ImageLine line, int column) {
        int n2 = column * line.channels;
        return (line.scanline[n2] << 16) + (line.scanline[n2 + 1] << 8) + line.scanline[n2 + 2];
    }

    public static int getPixelRGB16(ImageLine line, int column) {
        int n2 = column * line.channels;
        int n3 = line.scanline[n2] >> 8 & 0xFF;
        int n4 = line.scanline[n2 + 1] >> 8 & 0xFF;
        int n5 = line.scanline[n2 + 2] >> 8 & 0xFF;
        return (n3 << 16) + (n4 << 8) + n5;
    }

    public static int getPixelARGB8(ImageLine line, int column) {
        int n2 = column * line.channels;
        return (line.scanline[n2 + 3] << 24) + (line.scanline[n2] << 16) + (line.scanline[n2 + 1] << 8) + line.scanline[n2 + 2];
    }

    public static int getPixelARGB16(ImageLine line, int column) {
        int n2 = column * line.channels;
        int n3 = line.scanline[n2] >> 8 & 0xFF;
        int n4 = line.scanline[n2 + 1] >> 8 & 0xFF;
        int n5 = line.scanline[n2 + 2] >> 8 & 0xFF;
        int n6 = line.scanline[n2 + 3] >> 8 & 0xFF;
        return (n6 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public static void setPixelsRGB8(ImageLine line, int[] rgb) {
        int n2 = 0;
        for (int i2 = 0; i2 < line.imgInfo.cols; ++i2) {
            line.scanline[n2++] = rgb[i2] >> 16 & 0xFF;
            line.scanline[n2++] = rgb[i2] >> 8 & 0xFF;
            line.scanline[n2++] = rgb[i2] & 0xFF;
        }
    }

    public static void setPixelRGB8(ImageLine line, int col, int r2, int g2, int b2) {
        col *= line.channels;
        line.scanline[col++] = r2;
        line.scanline[col++] = g2;
        line.scanline[col] = b2;
    }

    public static void setPixelRGB8(ImageLine line, int col, int rgb) {
        ImageLineHelper.setPixelRGB8(line, col, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static void setPixelsRGBA8(ImageLine line, int[] rgb) {
        int n2 = 0;
        for (int i2 = 0; i2 < line.imgInfo.cols; ++i2) {
            line.scanline[n2++] = rgb[i2] >> 16 & 0xFF;
            line.scanline[n2++] = rgb[i2] >> 8 & 0xFF;
            line.scanline[n2++] = rgb[i2] & 0xFF;
            line.scanline[n2++] = rgb[i2] >> 24 & 0xFF;
        }
    }

    public static void setPixelRGBA8(ImageLine line, int col, int r2, int g2, int b2, int a2) {
        col *= line.channels;
        line.scanline[col++] = r2;
        line.scanline[col++] = g2;
        line.scanline[col++] = b2;
        line.scanline[col] = a2;
    }

    public static void setPixelRGBA8(ImageLine line, int col, int rgb) {
        ImageLineHelper.setPixelRGBA8(line, col, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgb >> 24 & 0xFF);
    }

    public static void setValD(ImageLine line, int i2, double d2) {
        line.scanline[i2] = ImageLineHelper.double2int(line, d2);
    }

    public static int interpol(int a2, int b2, int c2, int d2, double dx2, double dy2) {
        double d3 = (double)a2 * (1.0 - dx2) + (double)b2 * dx2;
        double d4 = (double)c2 * (1.0 - dx2) + (double)d2 * dx2;
        return (int)(d3 * (1.0 - dy2) + d4 * dy2 + 0.5);
    }

    public static double int2double(ImageLine line, int p2) {
        return line.bitDepth == 16 ? (double)p2 / 65535.0 : (double)p2 / 255.0;
    }

    public static double int2doubleClamped(ImageLine line, int p2) {
        double d2;
        double d3 = d2 = line.bitDepth == 16 ? (double)p2 / 65535.0 : (double)p2 / 255.0;
        return d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
    }

    public static int double2int(ImageLine line, double d2) {
        d2 = d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
        return line.bitDepth == 16 ? (int)(d2 * 65535.0 + 0.5) : (int)(d2 * 255.0 + 0.5);
    }

    public static int double2intClamped(ImageLine line, double d2) {
        d2 = d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
        return line.bitDepth == 16 ? (int)(d2 * 65535.0 + 0.5) : (int)(d2 * 255.0 + 0.5);
    }

    public static int clampTo_0_255(int i2) {
        return i2 > 255 ? 255 : (i2 < 0 ? 0 : i2);
    }

    public static int clampTo_0_65535(int i2) {
        return i2 > 65535 ? 65535 : (i2 < 0 ? 0 : i2);
    }

    public static int clampTo_128_127(int x2) {
        return x2 > 127 ? 127 : (x2 < -128 ? -128 : x2);
    }

    public static int[] unpack(ImageInfo imgInfo, int[] src, int[] dst, boolean scale) {
        int n2 = imgInfo.samplesPerRow;
        int n3 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < n2) {
            dst = new int[n2];
        }
        if (imgInfo.packed) {
            ImageLine.unpackInplaceInt(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, n3);
        }
        return dst;
    }

    public static byte[] unpack(ImageInfo imgInfo, byte[] src, byte[] dst, boolean scale) {
        int n2 = imgInfo.samplesPerRow;
        int n3 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < n2) {
            dst = new byte[n2];
        }
        if (imgInfo.packed) {
            ImageLine.unpackInplaceByte(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, n3);
        }
        return dst;
    }

    public static int[] pack(ImageInfo imgInfo, int[] src, int[] dst, boolean scale) {
        int n2 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < n2) {
            dst = new int[n2];
        }
        if (imgInfo.packed) {
            ImageLine.packInplaceInt(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, n2);
        }
        return dst;
    }

    public static byte[] pack(ImageInfo imgInfo, byte[] src, byte[] dst, boolean scale) {
        int n2 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < n2) {
            dst = new byte[n2];
        }
        if (imgInfo.packed) {
            ImageLine.packInplaceByte(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, n2);
        }
        return dst;
    }

    static int getMaskForPackedFormats(int bitDepth) {
        if (bitDepth == 4) {
            return 240;
        }
        if (bitDepth == 2) {
            return 192;
        }
        return 128;
    }

    static int getMaskForPackedFormatsLs(int bitDepth) {
        if (bitDepth == 4) {
            return 15;
        }
        if (bitDepth == 2) {
            return 3;
        }
        return 1;
    }

    static class ImageLineStats {
        public double[] prom = new double[]{0.0, 0.0, 0.0, 0.0};
        public double[] maxv = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307};
        public double[] minv = new double[]{8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307};
        public double promlum = 0.0;
        public double maxlum = -8.988465674311579E307;
        public double minlum = 8.988465674311579E307;
        public double[] maxdif = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, 8.988465674311579E307};
        public final int channels;

        public String toString() {
            return this.channels == 3 ? String.format("prom=%.1f (%.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.minlum, this.minv[0], this.minv[1], this.minv[2]) + String.format(" maxdif=(%.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2]) : String.format("prom=%.1f (%.1f %.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.prom[3], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.maxv[3], this.minlum, this.minv[0], this.minv[1], this.minv[2], this.minv[3]) + String.format(" maxdif=(%.1f %.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2], this.maxdif[3]);
        }

        public ImageLineStats(ImageLine line) {
            this.channels = line.channels;
            if (line.channels < 3) {
                throw new PngjException("ImageLineStats only works for RGB - RGBA");
            }
            int n2 = 0;
            for (int i2 = 0; i2 < line.imgInfo.cols; ++i2) {
                double d2 = 0.0;
                for (n2 = this.channels - 1; n2 >= 0; --n2) {
                    double d3;
                    double d4 = ImageLineHelper.int2double(line, line.scanline[i2 * this.channels]);
                    if (n2 < 3) {
                        d2 += d4;
                    }
                    int n3 = n2;
                    this.prom[n3] = this.prom[n3] + d4;
                    if (d4 > this.maxv[n2]) {
                        this.maxv[n2] = d4;
                    }
                    if (d4 < this.minv[n2]) {
                        this.minv[n2] = d4;
                    }
                    if (i2 < this.channels || !((d3 = Math.abs(d4 - ImageLineHelper.int2double(line, line.scanline[i2 - this.channels]))) > this.maxdif[n2])) continue;
                    this.maxdif[n2] = d3;
                }
                this.promlum += d2;
                if (d2 > this.maxlum) {
                    this.maxlum = d2;
                }
                if (!(d2 < this.minlum)) continue;
                this.minlum = d2;
            }
            n2 = 0;
            while (n2 < this.channels) {
                int n4 = n2++;
                this.prom[n4] = this.prom[n4] / (double)line.imgInfo.cols;
            }
            this.promlum /= (double)line.imgInfo.cols * 3.0;
            this.maxlum /= 3.0;
            this.minlum /= 3.0;
        }
    }
}

