/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

public class PngChunkHIST
extends PngChunkSingle {
    public static final String ID = "hIST";
    private int[] a = new int[0];

    public PngChunkHIST(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    public void parseFromRaw(ChunkRaw c2) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        int n2 = c2.data.length / 2;
        this.a = new int[n2];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = PngHelperInternal.readInt2fromBytes(c2.data, i2 * 2);
        }
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(this.a.length * 2, true);
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            PngHelperInternal.writeInt2tobytes(this.a[i2], chunkRaw.data, i2 * 2);
        }
        return chunkRaw;
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkHIST pngChunkHIST = (PngChunkHIST)other;
        this.a = new int[pngChunkHIST.a.length];
        System.arraycopy(pngChunkHIST.a, 0, this.a, 0, pngChunkHIST.a.length);
    }

    public int[] getHist() {
        return this.a;
    }

    public void setHist(int[] hist) {
        this.a = hist;
    }
}

