/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

public class PngChunkPLTE
extends PngChunkSingle {
    public static final String ID = "PLTE";
    private int a = 0;
    private int[] b;

    public PngChunkPLTE(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    public ChunkRaw createRawChunk() {
        int n2 = 3 * this.a;
        int[] nArray = new int[3];
        ChunkRaw chunkRaw = this.createEmptyChunk(n2, true);
        int n3 = 0;
        for (int i2 = 0; i2 < this.a; ++i2) {
            this.getEntryRgb(i2, nArray);
            chunkRaw.data[n3++] = (byte)nArray[0];
            chunkRaw.data[n3++] = (byte)nArray[1];
            chunkRaw.data[n3++] = (byte)nArray[2];
        }
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunk) {
        this.setNentries(chunk.len / 3);
        int n2 = 0;
        for (int i2 = 0; i2 < this.a; ++i2) {
            this.setEntry(i2, chunk.data[n2++] & 0xFF, chunk.data[n2++] & 0xFF, chunk.data[n2++] & 0xFF);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkPLTE pngChunkPLTE = (PngChunkPLTE)other;
        this.setNentries(pngChunkPLTE.getNentries());
        System.arraycopy(pngChunkPLTE.b, 0, this.b, 0, this.a);
    }

    public void setNentries(int n2) {
        this.a = n2;
        if (this.a < 1 || this.a > 256) {
            throw new PngjException("invalid pallette - nentries=" + this.a);
        }
        if (this.b == null || this.b.length != this.a) {
            this.b = new int[this.a];
        }
    }

    public int getNentries() {
        return this.a;
    }

    public void setEntry(int n2, int r2, int g2, int b2) {
        this.b[n2] = r2 << 16 | g2 << 8 | b2;
    }

    public int getEntry(int n2) {
        return this.b[n2];
    }

    public void getEntryRgb(int n2, int[] rgb) {
        this.getEntryRgb(n2, rgb, 0);
    }

    public void getEntryRgb(int n2, int[] rgb, int offset) {
        int n3 = this.b[n2];
        rgb[offset + 0] = (n3 & 0xFF0000) >> 16;
        rgb[offset + 1] = (n3 & 0xFF00) >> 8;
        rgb[offset + 2] = n3 & 0xFF;
    }

    public void setEntryRgb(int[] rgb) {
        this.b = rgb;
    }

    public int minBitDepth() {
        if (this.a <= 2) {
            return 1;
        }
        if (this.a <= 4) {
            return 2;
        }
        if (this.a <= 16) {
            return 4;
        }
        return 8;
    }

    public byte[][] getColors() {
        int[] nArray = new int[3];
        byte[][] byArray = new byte[3][this.a];
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.a; ++i2) {
            this.getEntryRgb(i2, nArray);
            byArray[0][i2] = (byte)nArray[0];
            byArray[1][i2] = (byte)nArray[1];
            byArray[2][i2] = (byte)nArray[2];
        }
        return byArray;
    }
}

