/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1GeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.DEROutputStream;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AttributeCertificate;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AttributeCertificateInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate;
import com.aspose.html.internal.ms.core.bc.asn1.x509.CertificateList;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.asn1.x509.ExtensionsGenerator;
import com.aspose.html.internal.ms.core.bc.asn1.x509.TBSCertList;
import com.aspose.html.internal.ms.core.bc.asn1.x509.TBSCertificate;
import com.aspose.html.internal.ms.core.bc.cert.CertIOException;
import com.aspose.html.internal.ms.core.bc.cert.X509AttributeCertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509CRLHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CertUtils {
    private static Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static List EMPTY_LIST = Collections.unmodifiableList(new ArrayList());

    CertUtils() {
    }

    static ASN1Primitive parseNonEmptyASN1(byte[] encoding) throws IOException {
        ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(encoding);
        if (aSN1Primitive == null) {
            throw new IOException("no content found");
        }
        return aSN1Primitive;
    }

    static X509CertificateHolder generateFullCert(ContentSigner signer, TBSCertificate tbsCert) {
        try {
            return new X509CertificateHolder(CertUtils.generateStructure(tbsCert, signer.getAlgorithmIdentifier(), CertUtils.generateSig(signer, tbsCert)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certificate signature");
        }
    }

    static X509AttributeCertificateHolder generateFullAttrCert(ContentSigner signer, AttributeCertificateInfo attrInfo) {
        try {
            return new X509AttributeCertificateHolder(CertUtils.generateAttrStructure(attrInfo, signer.getAlgorithmIdentifier(), CertUtils.generateSig(signer, attrInfo)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce attribute certificate signature");
        }
    }

    static X509CRLHolder generateFullCRL(ContentSigner signer, TBSCertList tbsCertList) {
        try {
            return new X509CRLHolder(CertUtils.generateCRLStructure(tbsCertList, signer.getAlgorithmIdentifier(), CertUtils.generateSig(signer, tbsCertList)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certificate signature");
        }
    }

    private static byte[] generateSig(ContentSigner signer, ASN1Encodable tbsObj) throws IOException {
        OutputStream outputStream = signer.getOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(outputStream);
        dEROutputStream.writeObject(tbsObj);
        outputStream.close();
        return signer.getSignature();
    }

    private static Certificate generateStructure(TBSCertificate tbsCert, AlgorithmIdentifier sigAlgId, byte[] signature) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(tbsCert);
        aSN1EncodableVector.add(sigAlgId);
        aSN1EncodableVector.add(new DERBitString(signature));
        return Certificate.getInstance(new DERSequence(aSN1EncodableVector));
    }

    private static AttributeCertificate generateAttrStructure(AttributeCertificateInfo attrInfo, AlgorithmIdentifier sigAlgId, byte[] signature) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(attrInfo);
        aSN1EncodableVector.add(sigAlgId);
        aSN1EncodableVector.add(new DERBitString(signature));
        return AttributeCertificate.getInstance(new DERSequence(aSN1EncodableVector));
    }

    private static CertificateList generateCRLStructure(TBSCertList tbsCertList, AlgorithmIdentifier sigAlgId, byte[] signature) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(tbsCertList);
        aSN1EncodableVector.add(sigAlgId);
        aSN1EncodableVector.add(new DERBitString(signature));
        return CertificateList.getInstance(new DERSequence(aSN1EncodableVector));
    }

    static Set getCriticalExtensionOIDs(Extensions extensions) {
        if (extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(extensions.getCriticalExtensionOIDs())));
    }

    static Set getNonCriticalExtensionOIDs(Extensions extensions) {
        if (extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(extensions.getNonCriticalExtensionOIDs())));
    }

    static List getExtensionOIDs(Extensions extensions) {
        if (extensions == null) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(extensions.getExtensionOIDs()));
    }

    static void addExtension(ExtensionsGenerator extGenerator, ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws CertIOException {
        try {
            extGenerator.addExtension(oid, isCritical, value);
        }
        catch (IOException iOException) {
            throw new CertIOException("cannot encode extension: " + iOException.getMessage(), iOException);
        }
    }

    static DERBitString booleanToBitString(boolean[] id2) {
        int n2;
        byte[] byArray = new byte[(id2.length + 7) / 8];
        for (n2 = 0; n2 != id2.length; ++n2) {
            int n3 = n2 / 8;
            byArray[n3] = (byte)(byArray[n3] | (id2[n2] ? 1 << 7 - n2 % 8 : 0));
        }
        n2 = id2.length % 8;
        if (n2 == 0) {
            return new DERBitString(byArray);
        }
        return new DERBitString(byArray, 8 - n2);
    }

    static boolean[] bitStringToBoolean(DERBitString bitString) {
        if (bitString != null) {
            byte[] byArray = bitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - bitString.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    static Date recoverDate(ASN1GeneralizedTime time) {
        try {
            return time.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("unable to recover date: " + parseException.getMessage());
        }
    }

    static boolean isAlgIdEqual(AlgorithmIdentifier id1, AlgorithmIdentifier id2) {
        if (!id1.getAlgorithm().equals(id2.getAlgorithm())) {
            return false;
        }
        if (id1.getParameters() == null) {
            return id2.getParameters() == null || id2.getParameters().equals(DERNull.INSTANCE);
        }
        if (id2.getParameters() == null) {
            return id1.getParameters() == null || id1.getParameters().equals(DERNull.INSTANCE);
        }
        return id1.getParameters().equals(id2.getParameters());
    }

    static ExtensionsGenerator doReplaceExtension(ExtensionsGenerator extGenerator, Extension ext) {
        boolean bl2 = false;
        Extensions extensions = extGenerator.generate();
        extGenerator = new ExtensionsGenerator();
        Enumeration enumeration = extensions.oids();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            if (aSN1ObjectIdentifier.equals(ext.getExtnId())) {
                bl2 = true;
                extGenerator.addExtension(ext);
                continue;
            }
            extGenerator.addExtension(extensions.getExtension(aSN1ObjectIdentifier));
        }
        if (!bl2) {
            throw new IllegalArgumentException("replace - original extension (OID = " + ext.getExtnId() + ") not found");
        }
        return extGenerator;
    }

    static ExtensionsGenerator doRemoveExtension(ExtensionsGenerator extGenerator, ASN1ObjectIdentifier oid) {
        boolean bl2 = false;
        Extensions extensions = extGenerator.generate();
        extGenerator = new ExtensionsGenerator();
        Enumeration enumeration = extensions.oids();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            if (aSN1ObjectIdentifier.equals(oid)) {
                bl2 = true;
                continue;
            }
            extGenerator.addExtension(extensions.getExtension(aSN1ObjectIdentifier));
        }
        if (!bl2) {
            throw new IllegalArgumentException("remove - extension (OID = " + oid + ") not found");
        }
        return extGenerator;
    }
}

