/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.cmp.PBMParameter;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.PKMACValue;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACBuilder;
import com.aspose.html.internal.ms.core.bc.operator.MacCalculator;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(password);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(keyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), value.getValue().getBytes());
    }
}

