/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertRequest;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.PKMACValue;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.POPOSigningKey;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.POPOSigningKeyInput;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFUtil;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACValueGenerator;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;

public class ProofOfPossessionSigningKeyBuilder {
    private CertRequest certRequest;
    private SubjectPublicKeyInfo pubKeyInfo;
    private GeneralName name;
    private PKMACValue publicKeyMAC;

    public ProofOfPossessionSigningKeyBuilder(CertRequest certRequest) {
        this.certRequest = certRequest;
    }

    public ProofOfPossessionSigningKeyBuilder(SubjectPublicKeyInfo pubKeyInfo) {
        this.pubKeyInfo = pubKeyInfo;
    }

    public ProofOfPossessionSigningKeyBuilder setSender(GeneralName name) {
        this.name = name;
        return this;
    }

    public ProofOfPossessionSigningKeyBuilder setPublicKeyMac(PKMACValueGenerator generator, char[] password) throws CRMFException {
        this.publicKeyMAC = generator.generate(password, this.pubKeyInfo);
        return this;
    }

    public POPOSigningKey build(ContentSigner signer) {
        POPOSigningKeyInput pOPOSigningKeyInput;
        if (this.name != null && this.publicKeyMAC != null) {
            throw new IllegalStateException("name and publicKeyMAC cannot both be set.");
        }
        if (this.certRequest != null) {
            pOPOSigningKeyInput = null;
            CRMFUtil.derEncodeToStream(this.certRequest, signer.getOutputStream());
        } else if (this.name != null) {
            pOPOSigningKeyInput = new POPOSigningKeyInput(this.name, this.pubKeyInfo);
            CRMFUtil.derEncodeToStream(pOPOSigningKeyInput, signer.getOutputStream());
        } else {
            pOPOSigningKeyInput = new POPOSigningKeyInput(this.publicKeyMAC, this.pubKeyInfo);
            CRMFUtil.derEncodeToStream(pOPOSigningKeyInput, signer.getOutputStream());
        }
        return new POPOSigningKey(pOPOSigningKeyInput, signer.getAlgorithmIdentifier(), new DERBitString(signer.getSignature()));
    }
}

