/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.ocsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Exception;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OutputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.OCSPRequest;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.Request;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.cert.CertIOException;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPException;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPUtils;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.Req;
import com.aspose.html.internal.ms.core.bc.operator.ContentVerifier;
import com.aspose.html.internal.ms.core.bc.operator.ContentVerifierProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;

public class OCSPReq {
    private static final X509CertificateHolder[] EMPTY_CERTS = new X509CertificateHolder[0];
    private OCSPRequest req;
    private Extensions extensions;

    public OCSPReq(OCSPRequest req) {
        this.req = req;
        this.extensions = req.getTbsRequest().getRequestExtensions();
    }

    public OCSPReq(byte[] req) throws IOException {
        this(new ASN1InputStream(req));
    }

    private OCSPReq(ASN1InputStream aIn) throws IOException {
        try {
            this.req = OCSPRequest.getInstance(aIn.readObject());
            if (this.req == null) {
                throw new CertIOException("malformed request: no request data found");
            }
            this.extensions = this.req.getTbsRequest().getRequestExtensions();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed request: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed request: " + classCastException.getMessage(), classCastException);
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertIOException("malformed request: " + aSN1Exception.getMessage(), aSN1Exception);
        }
    }

    public int getVersionNumber() {
        return this.req.getTbsRequest().getVersion().getValue().intValue() + 1;
    }

    public GeneralName getRequestorName() {
        return GeneralName.getInstance(this.req.getTbsRequest().getRequestorName());
    }

    public Req[] getRequestList() {
        ASN1Sequence aSN1Sequence = this.req.getTbsRequest().getRequestList();
        Req[] reqArray = new Req[aSN1Sequence.size()];
        for (int i2 = 0; i2 != reqArray.length; ++i2) {
            reqArray[i2] = new Req(Request.getInstance(aSN1Sequence.getObjectAt(i2)));
        }
        return reqArray;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return OCSPUtils.getExtensionOIDs(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return OCSPUtils.getCriticalExtensionOIDs(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return OCSPUtils.getNonCriticalExtensionOIDs(this.extensions);
    }

    public ASN1ObjectIdentifier getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignatureAlgorithm().getAlgorithm();
    }

    public byte[] getSignature() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignature().getOctets();
    }

    public X509CertificateHolder[] getCerts() {
        if (this.req.getOptionalSignature() != null) {
            ASN1Sequence aSN1Sequence = this.req.getOptionalSignature().getCerts();
            if (aSN1Sequence != null) {
                X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[aSN1Sequence.size()];
                for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                    x509CertificateHolderArray[i2] = new X509CertificateHolder(Certificate.getInstance(aSN1Sequence.getObjectAt(i2)));
                }
                return x509CertificateHolderArray;
            }
            return EMPTY_CERTS;
        }
        return EMPTY_CERTS;
    }

    public boolean isSigned() {
        return this.req.getOptionalSignature() != null;
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws OCSPException {
        if (!this.isSigned()) {
            throw new OCSPException("attempt to verify signature on unsigned object");
        }
        try {
            ContentVerifier contentVerifier = verifierProvider.get(this.req.getOptionalSignature().getSignatureAlgorithm());
            OutputStream outputStream = contentVerifier.getOutputStream();
            outputStream.write(this.req.getTbsRequest().getEncoded("DER"));
            return contentVerifier.verify(this.getSignature());
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing signature: " + exception, exception);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this.req);
        return byteArrayOutputStream.toByteArray();
    }
}

