/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.path.validations;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.PolicyConstraints;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidation;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationContext;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationException;
import com.aspose.html.internal.ms.core.bc.cert.path.validations.ValidationUtils;
import com.aspose.html.internal.ms.core.bc.util.Memoable;
import java.math.BigInteger;

public class CertificatePoliciesValidation
implements CertPathValidation {
    private int explicitPolicy;
    private int policyMapping;
    private int inhibitAnyPolicy;

    CertificatePoliciesValidation(int pathLength) {
        this(pathLength, false, false, false);
    }

    CertificatePoliciesValidation(int pathLength, boolean isExplicitPolicyRequired, boolean isAnyPolicyInhibited, boolean isPolicyMappingInhibited) {
        this.explicitPolicy = isExplicitPolicyRequired ? 0 : pathLength + 1;
        this.inhibitAnyPolicy = isAnyPolicyInhibited ? 0 : pathLength + 1;
        this.policyMapping = isPolicyMappingInhibited ? 0 : pathLength + 1;
    }

    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        context.addHandledExtension(Extension.policyConstraints);
        context.addHandledExtension(Extension.inhibitAnyPolicy);
        if (!context.isEndEntity() && !ValidationUtils.isSelfIssued(certificate)) {
            int n2;
            Object object;
            this.explicitPolicy = this.countDown(this.explicitPolicy);
            this.policyMapping = this.countDown(this.policyMapping);
            this.inhibitAnyPolicy = this.countDown(this.inhibitAnyPolicy);
            PolicyConstraints policyConstraints = PolicyConstraints.fromExtensions(certificate.getExtensions());
            if (policyConstraints != null) {
                BigInteger bigInteger;
                object = policyConstraints.getRequireExplicitPolicyMapping();
                if (object != null && ((BigInteger)object).intValue() < this.explicitPolicy) {
                    this.explicitPolicy = ((BigInteger)object).intValue();
                }
                if ((bigInteger = policyConstraints.getInhibitPolicyMapping()) != null && bigInteger.intValue() < this.policyMapping) {
                    this.policyMapping = bigInteger.intValue();
                }
            }
            if ((object = certificate.getExtension(Extension.inhibitAnyPolicy)) != null && (n2 = ASN1Integer.getInstance(((Extension)object).getParsedValue()).getValue().intValue()) < this.inhibitAnyPolicy) {
                this.inhibitAnyPolicy = n2;
            }
        }
    }

    private int countDown(int policyCounter) {
        if (policyCounter != 0) {
            return policyCounter - 1;
        }
        return 0;
    }

    public Memoable copy() {
        return new CertificatePoliciesValidation(0);
    }

    public void reset(Memoable other) {
        CertificatePoliciesValidation certificatePoliciesValidation = (CertificatePoliciesValidation)other;
    }
}

