/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.internal.ms.core.bc.asn1.BERSequenceGenerator;
import com.aspose.html.internal.ms.core.bc.asn1.BERSet;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.DERTaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.cms.AttributeTable;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CMSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cms.EnvelopedData;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cms.CMSEnvelopedGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSUtils;
import com.aspose.html.internal.ms.core.bc.cms.RecipientInfoGenerator;
import com.aspose.html.internal.ms.core.bc.operator.GenericKey;
import com.aspose.html.internal.ms.core.bc.operator.OutputEncryptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class CMSEnvelopedDataStreamGenerator
extends CMSEnvelopedGenerator {
    private ASN1Set _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean berEncodeRecipientSet) {
        this._berEncodeRecipientSet = berEncodeRecipientSet;
    }

    private ASN1Integer getVersion() {
        if (this.originatorInfo != null || this._unprotectedAttributes != null) {
            return new ASN1Integer(2L);
        }
        return new ASN1Integer(0L);
    }

    private OutputStream doOpen(ASN1ObjectIdentifier dataType, OutputStream out, OutputEncryptor encryptor) throws IOException, CMSException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        GenericKey genericKey = encryptor.getKey();
        for (RecipientInfoGenerator recipientInfoGenerator : this.recipientInfoGenerators) {
            aSN1EncodableVector.add(recipientInfoGenerator.generate(genericKey));
        }
        return this.open(dataType, out, aSN1EncodableVector, encryptor);
    }

    protected OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, ASN1EncodableVector recipientInfos, OutputEncryptor encryptor) throws IOException {
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(out);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.envelopedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(this.getVersion());
        if (this.originatorInfo != null) {
            bERSequenceGenerator2.addObject(new DERTaggedObject(false, 0, this.originatorInfo));
        }
        if (this._berEncodeRecipientSet) {
            bERSequenceGenerator2.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
        } else {
            bERSequenceGenerator2.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
        }
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(dataType);
        AlgorithmIdentifier algorithmIdentifier = encryptor.getAlgorithmIdentifier();
        bERSequenceGenerator3.getRawOutputStream().write(algorithmIdentifier.getEncoded());
        OutputStream outputStream = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, false, this._bufferSize);
        OutputStream outputStream2 = encryptor.getOutputStream(outputStream);
        return new CmsEnvelopedDataOutputStream(outputStream2, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    protected OutputStream open(OutputStream out, ASN1EncodableVector recipientInfos, OutputEncryptor encryptor) throws CMSException {
        try {
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(out);
            bERSequenceGenerator.addObject(CMSObjectIdentifiers.envelopedData);
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            ASN1Set aSN1Set = this._berEncodeRecipientSet ? new BERSet(recipientInfos) : new DERSet(recipientInfos);
            bERSequenceGenerator2.addObject(new ASN1Integer(EnvelopedData.calculateVersion(this.originatorInfo, aSN1Set, this._unprotectedAttributes)));
            if (this.originatorInfo != null) {
                bERSequenceGenerator2.addObject(new DERTaggedObject(false, 0, this.originatorInfo));
            }
            bERSequenceGenerator2.getRawOutputStream().write(aSN1Set.getEncoded());
            BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
            bERSequenceGenerator3.addObject(CMSObjectIdentifiers.data);
            AlgorithmIdentifier algorithmIdentifier = encryptor.getAlgorithmIdentifier();
            bERSequenceGenerator3.getRawOutputStream().write(algorithmIdentifier.getEncoded());
            OutputStream outputStream = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, false, this._bufferSize);
            return new CmsEnvelopedDataOutputStream(encryptor.getOutputStream(outputStream), bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    public OutputStream open(OutputStream out, OutputEncryptor encryptor) throws CMSException, IOException {
        return this.doOpen(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), out, encryptor);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, OutputEncryptor encryptor) throws CMSException, IOException {
        return this.doOpen(dataType, out, encryptor);
    }

    private class CmsEnvelopedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _envGen;
        private BERSequenceGenerator _eiGen;

        public CmsEnvelopedDataOutputStream(OutputStream out, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._cGen = cGen;
            this._envGen = envGen;
            this._eiGen = eiGen;
        }

        public void write(int b2) throws IOException {
            this._out.write(b2);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            if (CMSEnvelopedDataStreamGenerator.this.unprotectedAttributeGenerator != null) {
                AttributeTable attributeTable = CMSEnvelopedDataStreamGenerator.this.unprotectedAttributeGenerator.getAttributes(new HashMap());
                BERSet bERSet = new BERSet(attributeTable.toASN1EncodableVector());
                this._envGen.addObject(new DERTaggedObject(false, 1, bERSet));
            }
            this._envGen.close();
            this._cGen.close();
        }
    }
}

