/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.util.io.Streams;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSTypedStream {
    private static final int BUF_SIZ = 32768;
    private final ASN1ObjectIdentifier _oid;
    protected InputStream _in;

    public CMSTypedStream(InputStream in2) {
        this(PKCSObjectIdentifiers.data.getId(), in2, 32768);
    }

    public CMSTypedStream(String oid, InputStream in2) {
        this(new ASN1ObjectIdentifier(oid), in2, 32768);
    }

    public CMSTypedStream(String oid, InputStream in2, int bufSize) {
        this(new ASN1ObjectIdentifier(oid), in2, bufSize);
    }

    public CMSTypedStream(ASN1ObjectIdentifier oid, InputStream in2) {
        this(oid, in2, 32768);
    }

    public CMSTypedStream(ASN1ObjectIdentifier oid, InputStream in2, int bufSize) {
        this._oid = oid;
        this._in = new FullReaderStream(new BufferedInputStream(in2, bufSize));
    }

    protected CMSTypedStream(ASN1ObjectIdentifier oid) {
        this._oid = oid;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this._oid;
    }

    public InputStream getContentStream() {
        return this._in;
    }

    public void drain() throws IOException {
        Streams.drain(this._in);
        this._in.close();
    }

    private static class FullReaderStream
    extends FilterInputStream {
        FullReaderStream(InputStream in2) {
            super(in2);
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int n2 = Streams.readFully(this.in, buf, off, len);
            return n2 > 0 ? n2 : -1;
        }
    }
}

