/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.cms.IssuerAndSerialNumber;
import com.aspose.html.internal.ms.core.bc.asn1.cms.SignerIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cms.CMSAttributeTableGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignatureEncryptionAlgorithmFinder;
import com.aspose.html.internal.ms.core.bc.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import com.aspose.html.internal.ms.core.bc.cms.DefaultSignedAttributeTableGenerator;
import com.aspose.html.internal.ms.core.bc.cms.SignerInfoGenerator;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculatorProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;

public class SignerInfoGeneratorBuilder {
    private DigestCalculatorProvider digestProvider;
    private boolean directSignature;
    private CMSAttributeTableGenerator signedGen;
    private CMSAttributeTableGenerator unsignedGen;
    private CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder;

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider) {
        this(digestProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider, CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder) {
        this.digestProvider = digestProvider;
        this.sigEncAlgFinder = sigEncAlgFinder;
    }

    public SignerInfoGeneratorBuilder setDirectSignature(boolean hasNoSignedAttributes) {
        this.directSignature = hasNoSignedAttributes;
        return this;
    }

    public SignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator signedGen) {
        this.signedGen = signedGen;
        return this;
    }

    public SignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedGen) {
        this.unsignedGen = unsignedGen;
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder certHolder) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(certHolder.toASN1Structure()));
        SignerInfoGenerator signerInfoGenerator = this.createGenerator(contentSigner, signerIdentifier);
        signerInfoGenerator.setAssociatedCertificate(certHolder);
        return signerInfoGenerator;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] subjectKeyIdentifier) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new DEROctetString(subjectKeyIdentifier));
        return this.createGenerator(contentSigner, signerIdentifier);
    }

    private SignerInfoGenerator createGenerator(ContentSigner contentSigner, SignerIdentifier sigId) throws OperatorCreationException {
        if (this.directSignature) {
            return new SignerInfoGenerator(sigId, contentSigner, this.digestProvider, this.sigEncAlgFinder, true);
        }
        if (this.signedGen != null || this.unsignedGen != null) {
            if (this.signedGen == null) {
                this.signedGen = new DefaultSignedAttributeTableGenerator();
            }
            return new SignerInfoGenerator(sigId, contentSigner, this.digestProvider, this.sigEncAlgFinder, this.signedGen, this.unsignedGen);
        }
        return new SignerInfoGenerator(sigId, contentSigner, this.digestProvider, this.sigEncAlgFinder);
    }
}

