/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.ElGamalParameter;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.DHParameter;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x9.DomainParameters;
import com.aspose.html.internal.ms.core.bc.asn1.x9.ValidationParams;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDHKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DHDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DHValidationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Permissions;
import java.io.IOException;
import java.math.BigInteger;

public final class AsymmetricDHPrivateKey
extends AsymmetricDHKey
implements AsymmetricPrivateKey {
    private final int hashCode;
    private BigInteger x;

    public AsymmetricDHPrivateKey(Algorithm algorithm, DHDomainParameters dHDomainParameters, BigInteger bigInteger) {
        super(algorithm, dHDomainParameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDHPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricDHPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricDHPrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey()).getValue();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + iOException.getMessage(), iOException);
        }
    }

    public final byte[] getEncoded() {
        DHDomainParameters dHDomainParameters = this.getDomainParameters();
        if (dHDomainParameters.getQ() == null) {
            if (this.getAlgorithm().getName().startsWith("ELGAMAL")) {
                return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(dHDomainParameters.getP(), dHDomainParameters.getG())), new ASN1Integer(this.getX()));
            }
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getL())), new ASN1Integer(this.getX()));
        }
        DHValidationParameters dHValidationParameters = dHDomainParameters.getValidationParameters();
        if (dHValidationParameters != null) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), new ValidationParams(new DERBitString(dHValidationParameters.getSeed()), new ASN1Integer(dHValidationParameters.getCounter())))), new ASN1Integer(this.getX()));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), null)), new ASN1Integer(this.getX()));
    }

    public BigInteger getX() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return this.x;
    }

    private void zeroize() {
        this.x = null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.x.hashCode();
        n2 = 31 * n2 + this.getDomainParameters().hashCode();
        return n2;
    }

    protected void finalize() throws Throwable {
        this.zeroize();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDHPrivateKey)) {
            return false;
        }
        AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)object;
        return this.x.equals(asymmetricDHPrivateKey.x) && this.getDomainParameters().equals(asymmetricDHPrivateKey.getDomainParameters());
    }
}

