/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ua.DSTU4145NamedCurves;
import com.aspose.html.internal.ms.core.bc.asn1.ua.DSTU4145Params;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.util.Arrays;

public final class DSTU4145Parameters {
    private final byte[] dke;
    private final ECDomainParameters domainParameters;

    public DSTU4145Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this(aSN1ObjectIdentifier, DSTU4145Params.getDefaultDKE());
    }

    public DSTU4145Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        this(DSTU4145Parameters.getDomainParameters(aSN1ObjectIdentifier), byArray);
    }

    public DSTU4145Parameters(ECDomainParameters eCDomainParameters) {
        this(eCDomainParameters, DSTU4145Params.getDefaultDKE());
    }

    public DSTU4145Parameters(ECDomainParameters eCDomainParameters, byte[] byArray) {
        this.domainParameters = eCDomainParameters;
        this.dke = Arrays.clone(byArray);
    }

    public byte[] getDKE() {
        return Arrays.clone(this.dke);
    }

    public ECDomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    private static ECDomainParameters getDomainParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        ECDomainParameters eCDomainParameters = DSTU4145NamedCurves.getByOID(aSN1ObjectIdentifier);
        return new NamedECDomainParameters(aSN1ObjectIdentifier, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DSTU4145Parameters) {
            return this.domainParameters.equals(((DSTU4145Parameters)object).domainParameters) && Arrays.areEqual(this.dke, ((DSTU4145Parameters)object).dke);
        }
        return false;
    }

    public int hashCode() {
        return this.domainParameters.hashCode() + 37 * Arrays.hashCode(this.dke);
    }
}

