/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X962Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ECParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricRSAKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DHDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECImplicitDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsDRBG;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSecureRandom;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.math.internal.Primes;
import com.aspose.html.internal.ms.core.bc.util.Pack;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.math.BigInteger;
import java.security.Permission;
import java.security.SecureRandom;

class KeyUtils {
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    KeyUtils() {
    }

    static BigInteger validated(DHDomainParameters dHDomainParameters, BigInteger bigInteger) {
        if (bigInteger.compareTo(TWO) < 0 || bigInteger.compareTo(dHDomainParameters.getP().subtract(TWO)) > 0) {
            throw new IllegalArgumentException("Y value is out of range");
        }
        if (dHDomainParameters.getQ() != null) {
            if (BigInteger.ONE.equals(bigInteger.modPow(dHDomainParameters.getQ(), dHDomainParameters.getP()))) {
                return bigInteger;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return bigInteger;
    }

    static BigInteger validated(DSADomainParameters dSADomainParameters, BigInteger bigInteger) {
        if (dSADomainParameters != null) {
            if (TWO.compareTo(bigInteger) <= 0 && dSADomainParameters.getP().subtract(TWO).compareTo(bigInteger) >= 0 && BigInteger.ONE.equals(bigInteger.modPow(dSADomainParameters.getQ(), dSADomainParameters.getP()))) {
                return bigInteger;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return bigInteger;
    }

    static BigInteger validated(BigInteger bigInteger, BigInteger bigInteger2) {
        if ((bigInteger2.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA publicExponent is even");
        }
        return KeyUtils.validatedModulus(bigInteger);
    }

    static BigInteger validatedModulus(BigInteger bigInteger) {
        if (!AsymmetricRSAKey.isAlreadySeen(bigInteger)) {
            if ((bigInteger.intValue() & 1) == 0) {
                throw new IllegalArgumentException("RSA modulus is even");
            }
            if (!bigInteger.gcd(new BigInteger("1451887755777639901511587432083070202422614380984889313550570919659315177065956574359078912654149167643992684236991305777574330831666511589145701059710742276692757882915756220901998212975756543223550490431013061082131040808010565293748926901442915057819663730454818359472391642885328171302299245556663073719855")).equals(BigInteger.ONE)) {
                throw new IllegalArgumentException("RSA modulus has a small prime factor");
            }
            int n2 = bigInteger.bitLength();
            int n3 = n2 >= 1536 ? 3 : (n2 >= 1024 ? 4 : (n2 >= 512 ? 7 : 50));
            FipsSecureRandom fipsSecureRandom = FipsDRBG.SHA256.fromEntropySource(new SecureRandom(), false).build(Pack.longToBigEndian(System.currentTimeMillis()), false, Strings.toByteArray(Thread.currentThread().toString()));
            Primes.MROutput mROutput = Primes.enhancedMRProbablePrimeTest(bigInteger, fipsSecureRandom, n3);
            if (!mROutput.isProvablyComposite()) {
                throw new IllegalArgumentException("RSA modulus is not composite");
            }
            if (!mROutput.isNotPrimePower()) {
                throw new IllegalArgumentException("RSA modulus is a power of a prime");
            }
        }
        return bigInteger;
    }

    static ECPoint validated(ECPoint eCPoint) {
        if (eCPoint == null) {
            throw new IllegalArgumentException("Point has null value");
        }
        if (eCPoint.isInfinity()) {
            throw new IllegalArgumentException("Point at infinity");
        }
        if (!(eCPoint = eCPoint.normalize()).isValid()) {
            throw new IllegalArgumentException("Point not on curve");
        }
        return eCPoint;
    }

    static boolean isNotNull(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable.toASN1Primitive());
    }

    static X962Parameters buildCurveParameters(ECDomainParameters eCDomainParameters) {
        X962Parameters x962Parameters;
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            x962Parameters = new X962Parameters(((NamedECDomainParameters)eCDomainParameters).getID());
        } else if (eCDomainParameters instanceof ECImplicitDomainParameters) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
        } else {
            X9ECParameters x9ECParameters = new X9ECParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        return x962Parameters;
    }

    static int getOrderBitLength(ECDomainParameters eCDomainParameters) {
        return eCDomainParameters.getN().bitLength();
    }

    static boolean isDHPKCSParam(ASN1Encodable aSN1Encodable) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Encodable);
        if (aSN1Sequence.size() == 2) {
            return true;
        }
        if (aSN1Sequence.size() > 3) {
            return false;
        }
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2));
        ASN1Integer aSN1Integer2 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        return aSN1Integer.getValue().compareTo(BigInteger.valueOf(aSN1Integer2.getValue().bitLength())) <= 0;
    }

    static byte[] getEncodedInfo(ASN1Object aSN1Object) {
        try {
            return aSN1Object.getEncoded("DER");
        }
        catch (Exception exception) {
            return null;
        }
    }

    static byte[] getEncodedSubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, aSN1Encodable.toASN1Primitive());
            return KeyUtils.getEncodedInfo(subjectPublicKeyInfo);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static byte[] getEncodedPrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, aSN1Encodable.toASN1Primitive());
            return KeyUtils.getEncodedInfo(privateKeyInfo);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

