/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DhParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DhPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DhPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.MqvPrivateParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.MqvPublicParameters;
import java.math.BigInteger;

class MqvBasicAgreement
implements BasicAgreement {
    MqvPrivateParameters privParams;

    MqvBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.privParams = (MqvPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        MqvPublicParameters mqvPublicParameters = (MqvPublicParameters)cipherParameters;
        DhPrivateKeyParameters dhPrivateKeyParameters = this.privParams.getStaticPrivateKey();
        if (!this.privParams.getStaticPrivateKey().getParameters().equals(mqvPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalKeyException("MQV public key components have wrong domain parameters");
        }
        if (this.privParams.getStaticPrivateKey().getParameters().getQ() == null) {
            throw new IllegalKeyException("MQV key domain parameters do not have Q set");
        }
        BigInteger bigInteger = this.calculateMqvAgreement(dhPrivateKeyParameters.getParameters(), dhPrivateKeyParameters, mqvPublicParameters.getStaticPublicKey(), this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), mqvPublicParameters.getEphemeralPublicKey());
        if (bigInteger.equals(BigInteger.ONE)) {
            throw new IllegalStateException("1 is not a valid agreement value for MQV");
        }
        return bigInteger;
    }

    private BigInteger calculateMqvAgreement(DhParameters dhParameters, DhPrivateKeyParameters dhPrivateKeyParameters, DhPublicKeyParameters dhPublicKeyParameters, DhPrivateKeyParameters dhPrivateKeyParameters2, DhPublicKeyParameters dhPublicKeyParameters2, DhPublicKeyParameters dhPublicKeyParameters3) {
        BigInteger bigInteger = dhParameters.getQ();
        int n2 = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = BigInteger.valueOf(2L).pow(n2);
        BigInteger bigInteger3 = dhPublicKeyParameters2.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger4 = dhPrivateKeyParameters2.getX().add(bigInteger3.multiply(dhPrivateKeyParameters.getX())).mod(bigInteger);
        BigInteger bigInteger5 = dhPublicKeyParameters3.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger6 = dhPublicKeyParameters3.getY().multiply(dhPublicKeyParameters.getY().modPow(bigInteger5, dhParameters.getP())).modPow(bigInteger4, dhParameters.getP());
        return bigInteger6;
    }
}

