/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.OutputSignerUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDSAPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DSAValidationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsDSA;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputSigner;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.general.DsaKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.DsaParametersGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.DsaSigner;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedAsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSignatureOperatorUsingSecureRandomFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.HMacDsaKCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.general.NullDigest;
import com.aspose.html.internal.ms.core.bc.crypto.general.RandomDsaKCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.general.Register;
import com.aspose.html.internal.ms.core.bc.crypto.general.SelfTestExecutor;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.AsymmetricCipherKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.PrimeCertaintyCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaKeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaParameterGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaValidationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.internal.ms.core.bc.crypto.internal.test.ConsistencyTest;
import com.aspose.html.internal.ms.core.bc.util.Properties;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public final class DSA {
    public static final Algorithm ALGORITHM = FipsDSA.ALGORITHM;
    public static final Parameters DSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DSA), FipsSHS.Algorithm.SHA1);
    public static final Parameters DDSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DDSA), FipsSHS.Algorithm.SHA1);

    private DSA() {
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate(ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DsaSigner dsaSigner = new DsaSigner(new RandomDsaKCalculator());
                dsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = dsaSigner.generateSignature(byArray);
                dsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                dsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                return dsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    private static DsaParameters getDomainParams(DSADomainParameters dSADomainParameters) {
        return new DsaParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG());
    }

    private static DsaPrivateKeyParameters getLwKey(final AsymmetricDSAPrivateKey asymmetricDSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DsaPrivateKeyParameters>(){

            @Override
            public DsaPrivateKeyParameters run() {
                return new DsaPrivateKeyParameters(asymmetricDSAPrivateKey.getX(), com.aspose.html.internal.ms.core.bc.crypto.general.DSA.getDomainParams(asymmetricDSAPrivateKey.getDomainParameters()));
            }
        });
    }

    public static final class DomainGenParameters
    extends GeneralParameters {
        private final int strength;
        private final int certainty;

        public DomainGenParameters(int n2) {
            this(n2, PrimeCertaintyCalculator.getDefaultCertainty(n2));
        }

        public DomainGenParameters(int n2, int n3) {
            super(ALGORITHM);
            this.strength = n2;
            this.certainty = n3;
        }
    }

    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;

        public DomainParametersGenerator(DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved generator in approved only mode.");
            }
            this.parameters = domainGenParameters;
            this.random = secureRandom;
        }

        public DSADomainParameters generateDomainParameters() {
            DsaParametersGenerator dsaParametersGenerator = this.parameters.strength <= 1024 ? new DsaParametersGenerator() : new DsaParametersGenerator(Register.createDigest(FipsSHS.Algorithm.SHA256));
            if (this.parameters.strength == 1024) {
                if (Properties.isOverrideSet("com.aspose.html.internal.ms.core.bc.dsa.FIPS186-2for1024bits")) {
                    dsaParametersGenerator.init(this.parameters.strength, this.parameters.certainty, this.random);
                } else {
                    DsaParameterGenerationParameters dsaParameterGenerationParameters = new DsaParameterGenerationParameters(1024, 160, this.parameters.certainty, this.random);
                    dsaParametersGenerator.init(dsaParameterGenerationParameters);
                }
            } else if (this.parameters.strength > 1024) {
                DsaParameterGenerationParameters dsaParameterGenerationParameters = new DsaParameterGenerationParameters(this.parameters.strength, 256, this.parameters.certainty, this.random);
                dsaParametersGenerator.init(dsaParameterGenerationParameters);
            } else {
                dsaParametersGenerator.init(this.parameters.strength, this.parameters.certainty, this.random);
            }
            DsaParameters dsaParameters = dsaParametersGenerator.generateParameters();
            DsaValidationParameters dsaValidationParameters = dsaParameters.getValidationParameters();
            return new DSADomainParameters(dsaParameters.getP(), dsaParameters.getQ(), dsaParameters.getG(), new DSAValidationParameters(dsaValidationParameters.getSeed(), dsaValidationParameters.getCounter(), dsaValidationParameters.getUsageIndex()));
        }
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private final DSADomainParameters domainParameters;

        public KeyGenParameters(Parameters parameters, DSADomainParameters dSADomainParameters) {
            super(parameters.getAlgorithm());
            this.domainParameters = dSADomainParameters;
        }

        public KeyGenParameters(DSADomainParameters dSADomainParameters) {
            super(ALGORITHM);
            this.domainParameters = dSADomainParameters;
        }

        public DSADomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> {
        private final DsaKeyPairGenerator engine = new DsaKeyPairGenerator();
        private final DSADomainParameters domainParameters;
        private final DsaKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.param = new DsaKeyGenerationParameters(secureRandom, com.aspose.html.internal.ms.core.bc.crypto.general.DSA.getDomainParams(this.domainParameters));
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            com.aspose.html.internal.ms.core.bc.crypto.general.DSA.validateKeyPair(asymmetricCipherKeyPair);
            DsaPublicKeyParameters dsaPublicKeyParameters = (DsaPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            DsaPrivateKeyParameters dsaPrivateKeyParameters = (DsaPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t2 = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey>(new AsymmetricDSAPublicKey((Algorithm)t2, this.domainParameters, dsaPublicKeyParameters.getY()), new AsymmetricDSAPrivateKey((Algorithm)t2, this.domainParameters, dsaPrivateKeyParameters.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSignatureOperatorUsingSecureRandomFactory<Parameters> {
        @Override
        protected OutputSignerUsingSecureRandom<Parameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)asymmetricPrivateKey;
            final DsaPrivateKeyParameters dsaPrivateKeyParameters = com.aspose.html.internal.ms.core.bc.crypto.general.DSA.getLwKey(asymmetricDSAPrivateKey);
            return new DSAOutputSigner<Parameters>(dsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                public void initialize(com.aspose.html.internal.ms.core.bc.crypto.internal.DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(dsaPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        protected OutputVerifier<Parameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)asymmetricPublicKey;
            DsaPublicKeyParameters dsaPublicKeyParameters = new DsaPublicKeyParameters(asymmetricDSAPublicKey.getY(), com.aspose.html.internal.ms.core.bc.crypto.general.DSA.getDomainParams(asymmetricDSAPublicKey.getDomainParameters()));
            dsaSigner.init(false, dsaPublicKeyParameters);
            return new DSAOutputVerifier<Parameters>(dsaSigner, digest, parameters);
        }
    }

    public static final class Parameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        Parameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            if (generalAlgorithm.basicVariation() == Variations.DDSA && digestAlgorithm == null) {
                throw new IllegalArgumentException("DDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public Parameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        DSA,
        DDSA;

    }
}

