/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.CipherOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.InputDecryptor;
import com.aspose.html.internal.ms.core.bc.crypto.OperatorUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.OutputDecryptor;
import com.aspose.html.internal.ms.core.bc.crypto.OutputEncryptor;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.internal.StreamCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.CipherInputStream;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.CipherOutputStreamImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedSymmetricStreamOperatorFactory<T extends Parameters>
implements SymmetricOperatorFactory<T> {
    GuardedSymmetricStreamOperatorFactory() {
        if (!FipsStatus.isReady()) {
            throw new FipsUnapprovedOperationError("Module has not entered the ready state.");
        }
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved mode");
        }
    }

    @Override
    public final OutputEncryptor<T> createOutputEncryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", t2.getAlgorithm());
        }
        return new OutEncryptor(this, symmetricKey, t2, null);
    }

    @Override
    public OutputDecryptor<T> createOutputDecryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", t2.getAlgorithm());
        }
        final StreamCipher streamCipher = this.createCipher(false, symmetricKey, t2, null);
        return new OutputDecryptor<T>((Parameters)t2){
            final /* synthetic */ Parameters val$parameters;
            {
                this.val$parameters = parameters;
            }

            @Override
            public CipherOutputStreamImpl getDecryptingStream(OutputStream outputStream) {
                return new CipherOutputStreamImpl(outputStream, streamCipher);
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMaxOutputSize(int n2) {
                return n2;
            }

            @Override
            public int getUpdateOutputSize(int n2) {
                return n2;
            }
        };
    }

    @Override
    public final InputDecryptor<T> createInputDecryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", t2.getAlgorithm());
        }
        StreamCipher streamCipher = this.createCipher(false, symmetricKey, t2, null);
        return new InputDecryptor<T>((Parameters)t2, streamCipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ StreamCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = streamCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public InputStream getDecryptingStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, this.val$cipher);
            }
        };
    }

    protected abstract StreamCipher createCipher(boolean var1, SymmetricKey var2, T var3, SecureRandom var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutEncryptor
    implements OperatorUsingSecureRandom<OutputEncryptor<T>>,
    OutputEncryptor<T> {
        private final T parameters;
        private final SymmetricKey key;
        private final StreamCipher cipher;
        final /* synthetic */ GuardedSymmetricStreamOperatorFactory this$0;

        public OutEncryptor(SymmetricKey symmetricKey, T t2, SecureRandom secureRandom) {
            this.this$0 = var1_1;
            this.key = symmetricKey;
            this.parameters = t2;
            this.cipher = var1_1.createCipher(true, symmetricKey, t2, secureRandom);
        }

        @Override
        public CipherOutputStream getEncryptingStream(OutputStream outputStream) {
            return new CipherOutputStreamImpl(outputStream, this.cipher);
        }

        @Override
        public OutputEncryptor<T> withSecureRandom(SecureRandom secureRandom) {
            return new OutEncryptor(this.this$0, this.key, this.parameters, secureRandom);
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getMaxOutputSize(int n2) {
            return n2;
        }

        @Override
        public int getUpdateOutputSize(int n2) {
            return n2;
        }
    }
}

