/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordBasedDeriverFactory;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedPasswordBasedDeriverFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.OpenSSLPBEParametersGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.PKCS12ParametersGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.PKCS5S1ParametersGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.PKCS5S2ParametersGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.Register;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class PBKD {
    private static final GeneralAlgorithm ALGORITHM_PBKDF2 = new GeneralAlgorithm("PBKDF2");
    private static final GeneralAlgorithm ALGORITHM_PBKDF1 = new GeneralAlgorithm("PBKDF1");
    private static final GeneralAlgorithm ALGORITHM_PKCS12 = new GeneralAlgorithm("PKCS12");
    private static final GeneralAlgorithm ALGORITHM_OpenSSL = new GeneralAlgorithm("OpenSSL");
    public static final ParametersBuilder PBKDF1 = new ParametersBuilder(ALGORITHM_PBKDF1, FipsSHS.Algorithm.SHA1);
    public static final ParametersBuilder PBKDF2 = new ParametersBuilder(ALGORITHM_PBKDF2, FipsSHS.Algorithm.SHA1_HMAC);
    public static final ParametersBuilder PKCS12 = new ParametersBuilder(ALGORITHM_PKCS12, FipsSHS.Algorithm.SHA1);
    public static final OpenSSLParametersBuilder OpenSSL = new OpenSSLParametersBuilder();
    private static Map<Algorithm, PasswordBasedDeriverFactory<Parameters>> deriverTable = new HashMap<Algorithm, PasswordBasedDeriverFactory<Parameters>>();

    private PBKD() {
    }

    static {
        deriverTable.put(ALGORITHM_PBKDF2, new PBKDF2DeriverFactory());
        deriverTable.put(ALGORITHM_PBKDF1, new PBKDF1DeriverFactory());
        deriverTable.put(ALGORITHM_PKCS12, new PKCS12DeriverFactory());
        deriverTable.put(ALGORITHM_OpenSSL, new OpenSSLDeriverFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(Parameters parameters) {
            return ((PasswordBasedDeriverFactory)deriverTable.get(parameters.getAlgorithm())).createDeriver(parameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OpenSSLDeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private OpenSSLDeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            if (parameters.getPRF() != SecureHash.Algorithm.MD5) {
                throw new IllegalArgumentException("OpenSSL PBKDF only defined for MD5");
            }
            final OpenSSLPBEParametersGenerator<Parameters> openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator<Parameters>(parameters);
            openSSLPBEParametersGenerator.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return openSSLPBEParametersGenerator.deriveKey(keyType, n2);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return openSSLPBEParametersGenerator.deriveKeyAndIV(keyType, n2, n3);
                }
            };
        }
    }

    public static final class OpenSSLParametersBuilder
    extends GeneralParameters {
        OpenSSLParametersBuilder() {
            super(ALGORITHM_OpenSSL);
        }

        public Parameters using(byte[] byArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), SecureHash.Algorithm.MD5, null, Arrays.clone(byArray), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), SecureHash.Algorithm.MD5, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PBKDF1DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PBKDF1DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S1ParametersGenerator<Parameters> pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator<Parameters>(parameters, Register.createDigest(parameters.getPRF()));
            pKCS5S1ParametersGenerator.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return pKCS5S1ParametersGenerator.deriveKey(keyType, n2);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return pKCS5S1ParametersGenerator.deriveKeyAndIV(keyType, n2, n3);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PBKDF2DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PBKDF2DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S2ParametersGenerator<Parameters> pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator<Parameters>(parameters, Register.createHMac(parameters.getPRF()));
            pKCS5S2ParametersGenerator.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return pKCS5S2ParametersGenerator.deriveKey(keyType, n2);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return pKCS5S2ParametersGenerator.deriveKeyAndIV(keyType, n2, n3);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS12DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PKCS12DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS12ParametersGenerator<Parameters> pKCS12ParametersGenerator = new PKCS12ParametersGenerator<Parameters>(parameters, Register.createDigest(parameters.getPRF()));
            pKCS12ParametersGenerator.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return pKCS12ParametersGenerator.deriveKey(keyType, n2);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return pKCS12ParametersGenerator.deriveKeyAndIV(keyType, n2, n3);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParameters<Algorithm> {
        private final DigestAlgorithm digestAlgorithm;
        private final PasswordConverter converter;
        private final byte[] password;
        private final byte[] salt;
        private final int iterationCount;

        private Parameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm, PasswordConverter passwordConverter, byte[] byArray, int n2, byte[] byArray2) {
            super(generalAlgorithm);
            this.digestAlgorithm = digestAlgorithm;
            this.converter = passwordConverter;
            this.password = byArray;
            this.iterationCount = n2;
            this.salt = byArray2;
        }

        private Parameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            this(generalAlgorithm, digestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }

        public Parameters withSalt(byte[] byArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.digestAlgorithm, this.converter, this.getPassword(), this.iterationCount, Arrays.clone(byArray));
        }

        public Parameters withIterationCount(int n2) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.digestAlgorithm, this.converter, this.getPassword(), n2, this.salt);
        }

        byte[] getPassword() {
            return Arrays.clone(this.password);
        }

        public DigestAlgorithm getPRF() {
            return this.digestAlgorithm;
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public PasswordConverter getConverter() {
            return this.converter;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Arrays.fill(this.password, (byte)0);
        }
    }

    public static final class ParametersBuilder
    extends GeneralParameters {
        private final DigestAlgorithm defaultPrf;

        ParametersBuilder(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            this.defaultPrf = digestAlgorithm;
        }

        public Parameters using(byte[] byArray) {
            return this.using(this.defaultPrf, byArray);
        }

        public Parameters using(DigestAlgorithm digestAlgorithm, byte[] byArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm, null, Arrays.clone(byArray), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.defaultPrf, passwordConverter, cArray);
        }

        public Parameters using(DigestAlgorithm digestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }
    }
}

