/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.io;

import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.InvalidCipherTextException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BufferedBlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.SkippingCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.StreamCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.StreamIOException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream
extends FilterInputStream {
    private static final int INPUT_BUF_SIZE = 2048;
    private final String algorithmName;
    private final boolean isApprovedMode;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private byte[] buf;
    private byte[] markBuf;
    private final byte[] inBuf = new byte[2048];
    private int bufOff;
    private int maxBuf;
    private boolean finalized;
    private long markPosition;
    private int markBufOff;

    public CipherInputStream(InputStream inputStream, BufferedBlockCipher bufferedBlockCipher) {
        super(inputStream);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = bufferedBlockCipher.getUnderlyingCipher().getAlgorithmName();
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherInputStream(InputStream inputStream, StreamCipher streamCipher) {
        super(inputStream);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = streamCipher.getAlgorithmName();
        this.streamCipher = streamCipher;
    }

    public CipherInputStream(InputStream inputStream, AEADBlockCipher aEADBlockCipher) {
        super(inputStream);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = aEADBlockCipher.getAlgorithmName();
        this.aeadBlockCipher = aEADBlockCipher;
    }

    private int nextChunk() throws IOException {
        if (this.finalized) {
            return -1;
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        while (this.maxBuf == 0) {
            int n2 = this.in.read(this.inBuf);
            if (n2 == -1) {
                this.finaliseCipher();
                if (this.maxBuf == 0) {
                    return -1;
                }
                return this.maxBuf;
            }
            try {
                this.ensureCapacity(n2, false);
                if (this.bufferedBlockCipher != null) {
                    this.maxBuf = this.bufferedBlockCipher.processBytes(this.inBuf, 0, n2, this.buf, 0);
                    continue;
                }
                if (this.aeadBlockCipher != null) {
                    this.maxBuf = this.aeadBlockCipher.processBytes(this.inBuf, 0, n2, this.buf, 0);
                    continue;
                }
                this.streamCipher.processBytes(this.inBuf, 0, n2, this.buf, 0);
                this.maxBuf = n2;
            }
            catch (Exception exception) {
                throw new StreamIOException("Error processing stream ", exception);
            }
        }
        return this.maxBuf;
    }

    private void finaliseCipher() throws IOException {
        try {
            this.finalized = true;
            this.ensureCapacity(0, true);
            this.maxBuf = this.bufferedBlockCipher != null ? this.bufferedBlockCipher.doFinal(this.buf, 0) : (this.aeadBlockCipher != null ? this.aeadBlockCipher.doFinal(this.buf, 0) : 0);
        }
        catch (com.aspose.html.internal.ms.core.bc.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidCipherTextException("Error finalising cipher", invalidCipherTextException);
        }
        catch (Exception exception) {
            throw new IOException("Error finalising cipher " + exception);
        }
    }

    public int read() throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n4 = Math.min(n3, this.available());
        System.arraycopy(this.buf, this.bufOff, byArray, n2, n4);
        this.bufOff += n4;
        return n4;
    }

    public long skip(long l2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (l2 <= 0L) {
            return 0L;
        }
        if (this.streamCipher instanceof SkippingCipher) {
            long l3;
            int n2 = this.available();
            if (l2 <= (long)n2) {
                this.bufOff = (int)((long)this.bufOff + l2);
                return l2;
            }
            this.bufOff = this.maxBuf;
            long l4 = this.in.skip(l2 - (long)n2);
            if (l4 != (l3 = ((SkippingCipher)((Object)this.streamCipher)).skip(l4))) {
                throw new IOException("Unable to skip cipher " + l4 + " bytes.");
            }
            return l4 + (long)n2;
        }
        int n3 = (int)Math.min(l2, (long)this.available());
        this.bufOff += n3;
        return n3;
    }

    public int available() throws IOException {
        return this.maxBuf - this.bufOff;
    }

    private void ensureCapacity(int n2, boolean bl2) {
        int n3 = n2;
        if (bl2) {
            if (this.bufferedBlockCipher != null) {
                n3 = this.bufferedBlockCipher.getOutputSize(n2);
            } else if (this.aeadBlockCipher != null) {
                n3 = this.aeadBlockCipher.getOutputSize(n2);
            }
        } else if (this.bufferedBlockCipher != null) {
            n3 = this.bufferedBlockCipher.getUpdateOutputSize(n2);
        } else if (this.aeadBlockCipher != null) {
            n3 = this.aeadBlockCipher.getUpdateOutputSize(n2);
        }
        if (this.buf == null || this.buf.length < n3) {
            this.buf = new byte[n3];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        try {
            this.in.close();
        }
        finally {
            if (!this.finalized) {
                this.finaliseCipher();
            }
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        this.markBufOff = 0;
        this.markPosition = 0L;
        if (this.markBuf != null) {
            Arrays.fill(this.markBuf, (byte)0);
            this.markBuf = null;
        }
        if (this.buf != null) {
            Arrays.fill(this.buf, (byte)0);
            this.buf = null;
        }
        Arrays.fill(this.inBuf, (byte)0);
    }

    public void mark(int n2) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.in.mark(n2);
        if (this.streamCipher instanceof SkippingCipher) {
            SkippingCipher skippingCipher = (SkippingCipher)((Object)this.streamCipher);
            this.markPosition = skippingCipher.getPosition();
        }
        if (this.buf != null) {
            this.markBuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, this.markBuf, 0, this.buf.length);
        }
        this.markBufOff = this.bufOff;
    }

    public void reset() throws IOException {
        if (!(this.streamCipher instanceof SkippingCipher)) {
            throw new IOException("cipher must implement SkippingCipher to be used with reset()");
        }
        this.in.reset();
        SkippingCipher skippingCipher = (SkippingCipher)((Object)this.streamCipher);
        skippingCipher.seekTo(this.markPosition);
        if (this.markBuf != null) {
            this.buf = this.markBuf;
        }
        this.bufOff = this.markBufOff;
    }

    public boolean markSupported() {
        if (this.streamCipher instanceof SkippingCipher) {
            return this.in.markSupported();
        }
        return false;
    }
}

