/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.cms.GCMParameters;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GcmSpecUtil;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.MacParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.AEADParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthParametersCreator<T extends AuthenticationParametersWithIV>
implements MacParametersCreator,
ParametersCreator {
    private final AuthenticationParametersWithIV<AuthenticationParametersWithIV> baseParameters;

    AuthParametersCreator(AuthenticationParametersWithIV authenticationParametersWithIV) {
        this.baseParameters = authenticationParametersWithIV;
    }

    public AuthenticationParameters getBaseParameters() {
        return this.baseParameters;
    }

    public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            AEADParameterSpec aEADParameterSpec = (AEADParameterSpec)algorithmParameterSpec;
            return (AuthenticationParameters)((AuthenticationParametersWithIV)this.baseParameters.withIV(aEADParameterSpec.getNonce())).withMACSize(aEADParameterSpec.getMacSizeInBits());
        }
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            return (AuthenticationParameters)this.baseParameters.withIV(((IvParameterSpec)algorithmParameterSpec).getIV());
        }
        if (GcmSpecUtil.isGcmSpec(algorithmParameterSpec)) {
            try {
                GCMParameters gCMParameters = GcmSpecUtil.extractGcmParameters(algorithmParameterSpec);
                return (AuthenticationParameters)((AuthenticationParametersWithIV)this.baseParameters.withIV(gCMParameters.getNonce())).withMACSize(gCMParameters.getIcvLen() * 8);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec: " + exception.getMessage(), exception);
            }
        }
        if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            return (AuthenticationParameters)this.baseParameters.withIV(((RC2ParameterSpec)algorithmParameterSpec).getIV());
        }
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Unknown AlgorithmParameterSpec found: " + algorithmParameterSpec.getClass().getName());
        }
        if (bl2 && this.baseParameters.getAlgorithm().requiresAlgorithmParameters()) {
            return (AuthenticationParameters)this.baseParameters.withIV(secureRandom);
        }
        return this.baseParameters;
    }
}

