/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.JavaLangSystem;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.internal.ms.core.bc.asn1.BEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.BEROutputStream;
import com.aspose.html.internal.ms.core.bc.asn1.DERBMPString;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DEROutputStream;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.GOST28147Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.AuthenticatedSafe;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.CertBag;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.EncryptedData;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.MacData;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBES2Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBKDF2Params;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCS12PBEParams;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.Pfx;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.SafeBag;
import com.aspose.html.internal.ms.core.bc.asn1.util.ASN1Dump;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AuthorityKeyIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DigestInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectKeyIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.X509ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsOutputDigestCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.PBKD;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.internal.ms.core.bc.jcajce.ConsistentKeyPair;
import com.aspose.html.internal.ms.core.bc.jcajce.PKCS12KeyWithParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.PKCS12StoreParameter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AsymmetricAlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseCipher;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.KeyIvSizeProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvIOException;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.GOST28147ParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.PBKDF2KeySpec;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class MSBC_PKCS12
extends AsymmetricAlgorithmProvider {
    private static final KeyIvSizeProvider sizeProvider = new KeyIvSizeProvider();
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.pkcs12.";

    @Override
    public void configure(BouncyCastleFipsProvider provider) {
        JavaLangSystem.out.println("MS - config");
        JavaLangSystem.out.println("MS - com.aspose.ms.core.bc.jcajce.provider.keystore.pkcs12.");
    }

    public static class BCPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore3DES(BouncyCastleFipsProvider fipsProvider) {
            super(fipsProvider, fipsProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private static class PKCS12KeyStoreSpi
    extends KeyStoreSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private static final int SALT_SIZE = 20;
        private static final int MIN_ITERATIONS = 1024;
        private IgnoresCaseHashtable privateKeyCache = new IgnoresCaseHashtable();
        private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
        private Hashtable localIds = new Hashtable();
        private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
        private Hashtable chainCerts = new Hashtable();
        private Hashtable keyCerts = new Hashtable();
        private boolean wrongPKCS12Zero = false;
        static final int NULL = 0;
        static final int CERTIFICATE = 1;
        static final int KEY = 2;
        static final int SECRET = 3;
        static final int SEALED = 4;
        static final int KEY_PRIVATE = 0;
        static final int KEY_PUBLIC = 1;
        static final int KEY_SECRET = 2;
        protected final SecureRandom random;
        private CertificateFactory certFact;
        private BouncyCastleFipsProvider fipsProvider;
        private ASN1ObjectIdentifier keyAlgorithm;
        private ASN1ObjectIdentifier certAlgorithm;

        public PKCS12KeyStoreSpi(BouncyCastleFipsProvider fipsProvider, Provider certProvider, ASN1ObjectIdentifier keyAlgorithm, ASN1ObjectIdentifier certAlgorithm) {
            this.fipsProvider = fipsProvider;
            this.keyAlgorithm = keyAlgorithm;
            this.certAlgorithm = certAlgorithm;
            this.random = fipsProvider.getDefaultSecureRandom();
            try {
                this.certFact = certProvider != null ? CertificateFactory.getInstance("X.509", certProvider) : CertificateFactory.getInstance("X.509");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
            }
        }

        private SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) throws IOException {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(pubKey.getEncoded()));
            return new SubjectKeyIdentifier(this.getDigest(subjectPublicKeyInfo));
        }

        private byte[] getDigest(SubjectPublicKeyInfo spki) {
            FipsOutputDigestCalculator<FipsSHS.Parameters> fipsOutputDigestCalculator = new FipsSHS.OperatorFactory<FipsSHS.Parameters>().createOutputDigestCalculator(FipsSHS.SHA1);
            fipsOutputDigestCalculator.getDigestStream().update(spki.getPublicKeyData().getBytes());
            return fipsOutputDigestCalculator.getDigest();
        }

        public Enumeration engineAliases() {
            Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
            Enumeration enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                hashtable.put(enumeration.nextElement(), "cert");
            }
            enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (hashtable.get(string) != null) continue;
                hashtable.put(string, "key");
            }
            return hashtable.keys();
        }

        @Override
        public boolean engineContainsAlias(String alias) {
            if (alias == null) {
                throw new NullPointerException("alias value is null");
            }
            return this.certs.get(alias) != null || this.keys.get(alias) != null;
        }

        @Override
        public void engineDeleteEntry(String alias) throws KeyStoreException {
            Key key = (Key)this.keys.remove(alias);
            this.privateKeyCache.remove(alias);
            Certificate certificate = (Certificate)this.certs.remove(alias);
            if (certificate != null) {
                this.removeChainCert(certificate);
            }
            if (key != null) {
                String string = (String)this.localIds.remove(alias);
                if (string != null) {
                    certificate = (Certificate)this.keyCerts.remove(string);
                }
                if (certificate != null) {
                    this.removeChainCert(certificate);
                }
            }
        }

        private void removeChainCert(Certificate c2) throws KeyStoreException {
            try {
                this.chainCerts.remove(new CertId(c2.getPublicKey()));
            }
            catch (IOException iOException) {
                throw new KeyStoreException("Exception: " + iOException.getMessage(), iOException);
            }
        }

        @Override
        public Certificate engineGetCertificate(String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("null alias passed to getCertificate.");
            }
            Certificate certificate = (Certificate)this.certs.get(alias);
            if (certificate == null) {
                String string = (String)this.localIds.get(alias);
                certificate = string != null ? (Certificate)this.keyCerts.get(string) : (Certificate)this.keyCerts.get(alias);
            }
            return certificate;
        }

        @Override
        public String engineGetCertificateAlias(Certificate cert) {
            String string;
            Certificate certificate;
            Enumeration enumeration = this.certs.elements();
            Enumeration enumeration2 = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                certificate = (Certificate)enumeration.nextElement();
                string = (String)enumeration2.nextElement();
                if (!certificate.equals(cert)) continue;
                return string;
            }
            enumeration = this.keyCerts.elements();
            enumeration2 = this.keyCerts.keys();
            while (enumeration.hasMoreElements()) {
                certificate = (Certificate)enumeration.nextElement();
                string = (String)enumeration2.nextElement();
                if (!certificate.equals(cert)) continue;
                return string;
            }
            return null;
        }

        @Override
        public Certificate[] engineGetCertificateChain(String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("null alias passed to getCertificateChain.");
            }
            if (!this.engineIsKeyEntry(alias)) {
                return null;
            }
            Certificate certificate = this.engineGetCertificate(alias);
            if (certificate != null) {
                Certificate[] certificateArray;
                Vector<Certificate> vector = new Vector<Certificate>();
                while (certificate != null) {
                    Object object;
                    Object object2;
                    certificateArray = (Certificate[])certificate;
                    Certificate certificate2 = null;
                    byte[] byArray = certificateArray.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                    if (byArray != null && ((AuthorityKeyIdentifier)(object2 = AuthorityKeyIdentifier.getInstance(object = ASN1OctetString.getInstance(byArray).getOctets()))).getKeyIdentifier() != null) {
                        certificate2 = (Certificate)this.chainCerts.get(new CertId(((AuthorityKeyIdentifier)object2).getKeyIdentifier()));
                    }
                    if (certificate2 == null && !(object = (Object)certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                        Enumeration enumeration = this.chainCerts.keys();
                        while (enumeration.hasMoreElements()) {
                            X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(enumeration.nextElement());
                            Principal principal = x509Certificate.getSubjectDN();
                            if (!principal.equals(object)) continue;
                            try {
                                certificateArray.verify(x509Certificate.getPublicKey());
                                certificate2 = x509Certificate;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    if (vector.contains(certificate)) {
                        certificate = null;
                        continue;
                    }
                    vector.addElement(certificate);
                    if (certificate2 != certificate) {
                        certificate = certificate2;
                        continue;
                    }
                    certificate = null;
                }
                certificateArray = new Certificate[vector.size()];
                for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                    certificateArray[i2] = (Certificate)vector.elementAt(i2);
                }
                return certificateArray;
            }
            return null;
        }

        @Override
        public Date engineGetCreationDate(String alias) {
            if (alias == null) {
                throw new NullPointerException("alias == null");
            }
            if (this.keys.get(alias) == null && this.certs.get(alias) == null) {
                return null;
            }
            return new Date();
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            if (alias == null) {
                throw new IllegalArgumentException("null alias passed to getKey.");
            }
            Key key = (Key)this.keys.get(alias);
            try {
                if (key instanceof PrivateKey) {
                    if (this.privateKeyCache.get(alias) != null) {
                        return key;
                    }
                    Certificate certificate = this.engineGetCertificate(alias);
                    if (certificate != null) {
                        new ConsistentKeyPair(certificate.getPublicKey(), (PrivateKey)key);
                        this.privateKeyCache.put(alias, key);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnrecoverableKeyException(illegalArgumentException.getMessage());
            }
            return key;
        }

        @Override
        public boolean engineIsCertificateEntry(String alias) {
            return this.certs.get(alias) != null && this.keys.get(alias) == null;
        }

        @Override
        public boolean engineIsKeyEntry(String alias) {
            return this.keys.get(alias) != null;
        }

        @Override
        public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
            if (this.keys.get(alias) != null) {
                throw new KeyStoreException("There is a key entry with the name " + alias + ".");
            }
            this.certs.put(alias, cert);
            this.putChainCert(cert);
        }

        @Override
        public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
            throw new KeyStoreException("operation not supported");
        }

        @Override
        public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
            if (!(key instanceof PrivateKey)) {
                throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
            }
            if (chain == null) {
                throw new KeyStoreException("no certificate chain for private key");
            }
            if (this.keys.get(alias) != null) {
                this.engineDeleteEntry(alias);
            }
            try {
                new ConsistentKeyPair(chain[0].getPublicKey(), (PrivateKey)key);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KeyStoreException(illegalArgumentException.getMessage());
            }
            this.keys.put(alias, key);
            this.privateKeyCache.put(alias, key);
            this.certs.put(alias, chain[0]);
            for (int i2 = 0; i2 != chain.length; ++i2) {
                this.putChainCert(chain[i2]);
            }
        }

        private void putChainCert(Certificate c2) throws KeyStoreException {
            try {
                this.chainCerts.put(new CertId(c2.getPublicKey()), c2);
            }
            catch (IOException iOException) {
                throw new KeyStoreException("Exception: " + iOException.getMessage(), iOException);
            }
        }

        @Override
        public int engineSize() {
            Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
            Enumeration enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                hashtable.put(enumeration.nextElement(), "cert");
            }
            enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (hashtable.get(string) != null) continue;
                hashtable.put(string, "key");
            }
            return hashtable.size();
        }

        @Override
        public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                super.engineSetEntry(alias, entry, new KeyStore.PasswordProtection(new char[0]));
            } else {
                if (entry instanceof KeyStore.SecretKeyEntry) {
                    throw new KeyStoreException("PKCS12 does not support storage of symmetric keys.");
                }
                super.engineSetEntry(alias, entry, null);
            }
        }

        protected PrivateKey unwrapKey(AlgorithmIdentifier algId, byte[] data, char[] password) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algId.getAlgorithm();
            try {
                if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    return (PrivateKey)this.createPKCS12BaseCipher(4, password, algId).engineUnwrap(data, "", 2);
                }
                if (!aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    throw new IOException("exception unwrapping private key - cannot recognize: " + aSN1ObjectIdentifier);
                }
                Cipher cipher = this.createPBES2Cipher(4, password, algId);
                return (PrivateKey)cipher.unwrap(data, "", 2);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ProvIOException("exception unwrapping private key - " + exception.toString(), exception);
            }
        }

        protected byte[] wrapKey(AlgorithmIdentifier algId, Key key, char[] password) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algId.getAlgorithm();
            try {
                Cipher cipher;
                if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    cipher = this.createPKCS12Cipher(3, password, algId);
                } else if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    cipher = this.createPBES2Cipher(3, password, algId);
                } else {
                    throw new IOException("exception unwrapping private key - cannot recognize: " + aSN1ObjectIdentifier);
                }
                return cipher.wrap(key);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ProvIOException("exception unwrapping private key - " + exception.toString(), exception);
            }
        }

        protected byte[] cryptData(boolean forEncryption, AlgorithmIdentifier algId, char[] password, byte[] data) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algId.getAlgorithm();
            int n2 = forEncryption ? 1 : 2;
            try {
                if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    return this.createPKCS12BaseCipher(n2, password, algId).engineDoFinal(data, 0, data.length);
                }
                if (!aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    throw new IOException("unknown PBE algorithm: " + aSN1ObjectIdentifier);
                }
                Cipher cipher = this.createPBES2Cipher(n2, password, algId);
                return cipher.doFinal(data);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ProvIOException("exception decrypting data - " + exception.toString(), exception);
            }
        }

        private Cipher createPKCS12Cipher(int mode, char[] password, AlgorithmIdentifier algId) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algId.getParameters());
            BouncyCastleFipsProvider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();
            Provider.Service service = bouncyCastleFipsProvider.getService("Cipher", "1.2.840.113549.1.12.1.6");
            CipherSpi cipherSpi = (CipherSpi)service.newInstance(null);
            Cipher cipher = Cipher.getInstance("1.2.840.113549.1.12.1.6", this.fipsProvider);
            PKCS12KeyWithParameters pKCS12KeyWithParameters = new PKCS12KeyWithParameters(password, this.wrongPKCS12Zero, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            cipher.init(mode, pKCS12KeyWithParameters);
            return cipher;
        }

        private BaseCipher createPKCS12BaseCipher(int mode, char[] password, AlgorithmIdentifier algId) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algId.getParameters());
            BouncyCastleFipsProvider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();
            Provider.Service service = bouncyCastleFipsProvider.getService("Cipher", algId.getAlgorithm().getId());
            BaseCipher baseCipher = (BaseCipher)service.newInstance(null);
            PKCS12KeyWithParameters pKCS12KeyWithParameters = new PKCS12KeyWithParameters(password, this.wrongPKCS12Zero, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            baseCipher.engineInit(mode, pKCS12KeyWithParameters, bouncyCastleFipsProvider.getDefaultSecureRandom());
            return baseCipher;
        }

        private Cipher createPBES2Cipher(int mode, char[] password, AlgorithmIdentifier algId) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algId.getParameters());
            PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
            AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId(), this.fipsProvider);
            SecretKey secretKey = pBKDF2Params.isDefaultPrf() ? secretKeyFactory.generateSecret(new PBEKeySpec(password, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue(), sizeProvider.getKeySize(algorithmIdentifier) * 8)) : secretKeyFactory.generateSecret(new PBKDF2KeySpec(password, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue(), sizeProvider.getKeySize(algorithmIdentifier) * 8, pBKDF2Params.getPrf()));
            Cipher cipher = Cipher.getInstance(algorithmIdentifier.getAlgorithm().getId());
            ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
            if (aSN1Encodable instanceof ASN1OctetString) {
                cipher.init(mode, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance(aSN1Encodable).getOctets()));
            } else {
                GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(aSN1Encodable);
                cipher.init(mode, (Key)secretKey, new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
            }
            return cipher;
        }

        @Override
        public void engineLoad(InputStream stream, char[] password) throws IOException {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Object object3;
            Object object4;
            ASN1Object aSN1Object2;
            Object object5;
            ASN1Object aSN1Object3;
            this.privateKeyCache.clear();
            if (stream == null) {
                return;
            }
            if (password == null) {
                throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(stream);
            bufferedInputStream.mark(10);
            int n2 = bufferedInputStream.read();
            if (n2 != 48) {
                throw new IOException("stream does not represent a PKCS12 key store");
            }
            bufferedInputStream.reset();
            ASN1InputStream aSN1InputStream = new ASN1InputStream(bufferedInputStream);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            Pfx pfx = Pfx.getInstance(aSN1Sequence);
            ContentInfo contentInfo = pfx.getAuthSafe();
            Vector<ASN1Object> vector = new Vector<ASN1Object>();
            boolean bl2 = false;
            if (pfx.getMacData() != null) {
                aSN1Object3 = pfx.getMacData();
                object5 = ((MacData)aSN1Object3).getMac();
                aSN1Object2 = ((DigestInfo)object5).getAlgorithmId();
                object4 = ((MacData)aSN1Object3).getSalt();
                int n3 = ((MacData)aSN1Object3).getIterationCount().intValue();
                object3 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            }
            this.keys = new IgnoresCaseHashtable();
            this.localIds = new Hashtable();
            if (contentInfo.getContentType().equals(data)) {
                aSN1InputStream = new ASN1InputStream(((ASN1OctetString)contentInfo.getContent()).getOctets());
                aSN1Object3 = AuthenticatedSafe.getInstance(aSN1InputStream.readObject());
                object5 = ((AuthenticatedSafe)aSN1Object3).getContentInfo();
                for (int i2 = 0; i2 != ((ContentInfo[])object5).length; ++i2) {
                    ASN1Primitive aSN1Primitive;
                    ASN1Primitive aSN1Primitive2;
                    Object object6;
                    Object object7;
                    Object object8;
                    Object object9;
                    if (object5[i2].getContentType().equals(data)) {
                        object4 = new ASN1InputStream(((ASN1OctetString)((ContentInfo)object5[i2]).getContent()).getOctets());
                        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1InputStream)object4).readObject();
                        for (int i3 = 0; i3 != aSN1Sequence2.size(); ++i3) {
                            SafeBag safeBag = SafeBag.getInstance(aSN1Sequence2.getObjectAt(i3));
                            if (safeBag.getBagId().equals(pkcs8ShroudedKeyBag)) {
                                aSN1Object = EncryptedPrivateKeyInfo.getInstance(safeBag.getBagValue());
                                object2 = this.unwrapKey(((EncryptedPrivateKeyInfo)aSN1Object).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)aSN1Object).getEncryptedData(), password);
                                object = null;
                                object9 = null;
                                if (safeBag.getBagAttributes() != null) {
                                    object8 = safeBag.getBagAttributes().getObjects();
                                    while (object8.hasMoreElements()) {
                                        object7 = (ASN1Sequence)object8.nextElement();
                                        object6 = (ASN1ObjectIdentifier)((ASN1Sequence)object7).getObjectAt(0);
                                        aSN1Primitive2 = (ASN1Set)((ASN1Sequence)object7).getObjectAt(1);
                                        aSN1Primitive = null;
                                        if (((ASN1Set)aSN1Primitive2).size() <= 0) continue;
                                        aSN1Primitive = (ASN1Primitive)((ASN1Set)aSN1Primitive2).getObjectAt(0);
                                        if (((ASN1Primitive)object6).equals(pkcs_9_at_friendlyName)) {
                                            if (object != null && !((String)object).equals(DERBMPString.getInstance(aSN1Primitive).getString())) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                            object = DERBMPString.getInstance(aSN1Primitive).getString();
                                            this.keys.put((String)object, object2);
                                            continue;
                                        }
                                        if (!((ASN1Primitive)object6).equals(pkcs_9_at_localKeyId)) continue;
                                        if (object9 != null && !((ASN1Primitive)object9).equals(aSN1Primitive)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        object9 = ASN1OctetString.getInstance(aSN1Primitive);
                                    }
                                }
                                if (object9 != null) {
                                    object8 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object9).getOctets()));
                                    if (object == null) {
                                        this.keys.put((String)object8, object2);
                                        continue;
                                    }
                                    this.localIds.put(object, object8);
                                    continue;
                                }
                                bl2 = true;
                                this.keys.put("unmarked", object2);
                                continue;
                            }
                            if (safeBag.getBagId().equals(certBag)) {
                                vector.addElement(safeBag);
                                continue;
                            }
                            JavaLangSystem.out.println("extra in data " + safeBag.getBagId());
                            JavaLangSystem.out.println(ASN1Dump.dumpAsString(safeBag));
                        }
                        continue;
                    }
                    if (((ContentInfo)object5[i2]).getContentType().equals(encryptedData)) {
                        object4 = EncryptedData.getInstance(((ContentInfo)object5[i2]).getContent());
                        byte[] byArray = this.cryptData(false, ((EncryptedData)object4).getEncryptionAlgorithm(), password, ((EncryptedData)object4).getContent().getOctets());
                        object3 = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
                        for (int i4 = 0; i4 != ((ASN1Sequence)object3).size(); ++i4) {
                            ASN1Primitive aSN1Primitive3;
                            aSN1Object = SafeBag.getInstance(((ASN1Sequence)object3).getObjectAt(i4));
                            if (((SafeBag)aSN1Object).getBagId().equals(certBag)) {
                                vector.addElement(aSN1Object);
                                continue;
                            }
                            if (((SafeBag)aSN1Object).getBagId().equals(pkcs8ShroudedKeyBag)) {
                                object2 = EncryptedPrivateKeyInfo.getInstance(((SafeBag)aSN1Object).getBagValue());
                                object = this.unwrapKey(((EncryptedPrivateKeyInfo)object2).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object2).getEncryptedData(), password);
                                object9 = null;
                                object8 = null;
                                object7 = ((SafeBag)aSN1Object).getBagAttributes().getObjects();
                                while (object7.hasMoreElements()) {
                                    object6 = (ASN1Sequence)object7.nextElement();
                                    aSN1Primitive2 = (ASN1ObjectIdentifier)((ASN1Sequence)object6).getObjectAt(0);
                                    aSN1Primitive = (ASN1Set)((ASN1Sequence)object6).getObjectAt(1);
                                    aSN1Primitive3 = null;
                                    if (((ASN1Set)aSN1Primitive).size() <= 0) continue;
                                    aSN1Primitive3 = (ASN1Primitive)((ASN1Set)aSN1Primitive).getObjectAt(0);
                                    if (aSN1Primitive2.equals(pkcs_9_at_friendlyName)) {
                                        if (object9 != null && !((String)object9).equals(DERBMPString.getInstance(aSN1Primitive3).getString())) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        object9 = DERBMPString.getInstance(aSN1Primitive3).getString();
                                        this.keys.put((String)object9, object);
                                        continue;
                                    }
                                    if (!aSN1Primitive2.equals(pkcs_9_at_localKeyId)) continue;
                                    if (object8 != null && !((ASN1Primitive)object8).equals(aSN1Primitive3)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                    object8 = ASN1OctetString.getInstance(aSN1Primitive3);
                                }
                                object6 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object8).getOctets()));
                                if (object9 == null) {
                                    this.keys.put((String)object6, object);
                                    continue;
                                }
                                this.localIds.put(object9, object6);
                                continue;
                            }
                            if (((SafeBag)aSN1Object).getBagId().equals(keyBag)) {
                                object2 = PrivateKeyInfo.getInstance(((SafeBag)aSN1Object).getBagValue());
                                object = this.fipsProvider.getPrivateKey((PrivateKeyInfo)object2);
                                object9 = null;
                                object8 = null;
                                object7 = ((SafeBag)aSN1Object).getBagAttributes().getObjects();
                                while (object7.hasMoreElements()) {
                                    object6 = (ASN1Sequence)object7.nextElement();
                                    aSN1Primitive2 = (ASN1ObjectIdentifier)((ASN1Sequence)object6).getObjectAt(0);
                                    aSN1Primitive = (ASN1Set)((ASN1Sequence)object6).getObjectAt(1);
                                    aSN1Primitive3 = null;
                                    if (((ASN1Set)aSN1Primitive).size() <= 0) continue;
                                    aSN1Primitive3 = (ASN1Primitive)((ASN1Set)aSN1Primitive).getObjectAt(0);
                                    if (aSN1Primitive2.equals(pkcs_9_at_friendlyName)) {
                                        if (object9 != null && !((String)object9).equals(DERBMPString.getInstance(aSN1Primitive3).getString())) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        object9 = DERBMPString.getInstance(aSN1Primitive3).getString();
                                        this.keys.put((String)object9, object);
                                        continue;
                                    }
                                    if (!aSN1Primitive2.equals(pkcs_9_at_localKeyId)) continue;
                                    if (object8 != null && !((ASN1Primitive)object8).equals(aSN1Primitive3)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                    object8 = ASN1OctetString.getInstance(aSN1Primitive3);
                                }
                                object6 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object8).getOctets()));
                                if (object9 == null) {
                                    this.keys.put((String)object6, object);
                                    continue;
                                }
                                this.localIds.put(object9, object6);
                                continue;
                            }
                            JavaLangSystem.out.println("extra in encryptedData " + ((SafeBag)aSN1Object).getBagId());
                            JavaLangSystem.out.println(ASN1Dump.dumpAsString(aSN1Object));
                        }
                        continue;
                    }
                    JavaLangSystem.out.println("extra " + ((ContentInfo)object5[i2]).getContentType().getId());
                    JavaLangSystem.out.println("extra " + ASN1Dump.dumpAsString(((ContentInfo)object5[i2]).getContent()));
                }
            }
            this.certs = new IgnoresCaseHashtable();
            this.chainCerts = new Hashtable();
            this.keyCerts = new Hashtable();
            for (int i5 = 0; i5 != vector.size(); ++i5) {
                Object object10;
                Object object11;
                object5 = (SafeBag)vector.elementAt(i5);
                aSN1Object2 = CertBag.getInstance(((SafeBag)object5).getBagValue());
                if (!((CertBag)aSN1Object2).getCertId().equals(x509Certificate)) {
                    throw new IOException("Unsupported certificate type: " + ((CertBag)aSN1Object2).getCertId());
                }
                try {
                    object11 = new ByteArrayInputStream(((ASN1OctetString)((CertBag)aSN1Object2).getCertValue()).getOctets());
                    object4 = this.certFact.generateCertificate((InputStream)object11);
                }
                catch (Exception exception) {
                    throw new ProvIOException(exception.toString(), exception);
                }
                object11 = null;
                object3 = null;
                if (((SafeBag)object5).getBagAttributes() != null) {
                    object10 = ((SafeBag)object5).getBagAttributes().getObjects();
                    while (object10.hasMoreElements()) {
                        aSN1Object = (ASN1Sequence)object10.nextElement();
                        object2 = (ASN1ObjectIdentifier)((ASN1Sequence)aSN1Object).getObjectAt(0);
                        object = (ASN1Primitive)((ASN1Set)((ASN1Sequence)aSN1Object).getObjectAt(1)).getObjectAt(0);
                        if (((ASN1Primitive)object2).equals(pkcs_9_at_friendlyName)) {
                            if (object3 != null && !((String)object3).equals(DERBMPString.getInstance(object).getString())) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                            object3 = DERBMPString.getInstance(object).getString();
                            continue;
                        }
                        if (!((ASN1Primitive)object2).equals(pkcs_9_at_localKeyId)) continue;
                        if (object11 != null && !((ASN1Primitive)object11).equals(object)) {
                            throw new IOException("attempt to add existing attribute with different value");
                        }
                        object11 = ASN1OctetString.getInstance(object);
                    }
                }
                this.chainCerts.put(new CertId(((Certificate)object4).getPublicKey()), object4);
                if (bl2) {
                    if (!this.keyCerts.isEmpty()) continue;
                    object10 = Strings.fromByteArray(Hex.encode(this.createSubjectKeyId(((Certificate)object4).getPublicKey()).getKeyIdentifier()));
                    this.keyCerts.put(object10, object4);
                    this.keys.put((String)object10, this.keys.remove("unmarked"));
                    continue;
                }
                if (object11 != null) {
                    object10 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object11).getOctets()));
                    this.keyCerts.put(object10, object4);
                }
                if (object3 == null) continue;
                this.certs.put((String)object3, object4);
            }
        }

        @Override
        public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
            char[] cArray;
            if (param == null) {
                throw new IllegalArgumentException("'param' arg cannot be null");
            }
            if (!(param instanceof PKCS12StoreParameter)) {
                throw new IllegalArgumentException("No support for 'param' of type " + param.getClass().getName());
            }
            PKCS12StoreParameter pKCS12StoreParameter = (PKCS12StoreParameter)param;
            KeyStore.ProtectionParameter protectionParameter = param.getProtectionParameter();
            if (protectionParameter == null) {
                cArray = null;
            } else if (protectionParameter instanceof KeyStore.PasswordProtection) {
                cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
            } else {
                throw new IllegalArgumentException("No support for protection parameter of type " + protectionParameter.getClass().getName());
            }
            this.doStore(pKCS12StoreParameter.getOutputStream(), cArray, pKCS12StoreParameter.isForDEREncoding());
        }

        @Override
        public void engineStore(OutputStream stream, char[] password) throws IOException {
            this.doStore(stream, password, false);
        }

        private void doStore(OutputStream stream, char[] password, boolean useDEREncoding) throws IOException {
            MacData macData;
            ASN1Object aSN1Object;
            Object object;
            Object object2;
            ContentInfo[] contentInfoArray;
            ASN1Object aSN1Object2;
            Object object3;
            Object object4;
            Enumeration enumeration;
            Object object5;
            Object object6;
            ASN1Object aSN1Object3;
            Object object7;
            Object object8;
            Object object9;
            byte[] byArray;
            if (password == null) {
                throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
            }
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            Enumeration enumeration2 = this.keys.keys();
            while (enumeration2.hasMoreElements()) {
                byArray = new byte[20];
                this.random.nextBytes(byArray);
                object9 = (String)enumeration2.nextElement();
                object8 = (PrivateKey)this.keys.get((String)object9);
                object7 = new PKCS12PBEParams(byArray, 1024);
                aSN1Object3 = new AlgorithmIdentifier(this.keyAlgorithm, (ASN1Encodable)object7);
                object6 = this.wrapKey((AlgorithmIdentifier)aSN1Object3, (Key)object8, password);
                object5 = new EncryptedPrivateKeyInfo((AlgorithmIdentifier)aSN1Object3, (byte[])object6);
                enumeration = new ASN1EncodableVector();
                object4 = new ASN1EncodableVector();
                object3 = this.engineGetCertificate((String)object9);
                ((ASN1EncodableVector)object4).add(pkcs_9_at_localKeyId);
                ((ASN1EncodableVector)object4).add(new DERSet(this.createSubjectKeyId(((Certificate)object3).getPublicKey())));
                ((ASN1EncodableVector)((Object)enumeration)).add(new DERSequence((ASN1EncodableVector)object4));
                object4 = new ASN1EncodableVector();
                ((ASN1EncodableVector)object4).add(pkcs_9_at_friendlyName);
                ((ASN1EncodableVector)object4).add(new DERSet(new DERBMPString((String)object9)));
                ((ASN1EncodableVector)((Object)enumeration)).add(new DERSequence((ASN1EncodableVector)object4));
                SafeBag safeBag = new SafeBag(pkcs8ShroudedKeyBag, ((EncryptedPrivateKeyInfo)object5).toASN1Primitive(), new DERSet((ASN1EncodableVector)((Object)enumeration)));
                aSN1EncodableVector.add(safeBag);
            }
            byArray = new DERSequence(aSN1EncodableVector).getEncoded("DER");
            object9 = new BEROctetString(byArray);
            object8 = new byte[20];
            this.random.nextBytes((byte[])object8);
            object7 = new ASN1EncodableVector();
            aSN1Object3 = new PKCS12PBEParams((byte[])object8, 1024);
            object6 = new AlgorithmIdentifier(this.certAlgorithm, ((PKCS12PBEParams)aSN1Object3).toASN1Primitive());
            object5 = new Hashtable();
            enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    object4 = (String)enumeration.nextElement();
                    object3 = this.engineGetCertificate((String)object4);
                    boolean bl2 = false;
                    aSN1Object2 = new CertBag(x509Certificate, new DEROctetString(((Certificate)object3).getEncoded()));
                    contentInfoArray = new ASN1EncodableVector();
                    object2 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object2).add(pkcs_9_at_localKeyId);
                    ((ASN1EncodableVector)object2).add(new DERSet(this.createSubjectKeyId(((Certificate)object3).getPublicKey())));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                    object2 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object2).add(pkcs_9_at_friendlyName);
                    ((ASN1EncodableVector)object2).add(new DERSet(new DERBMPString((String)object4)));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                    object = new SafeBag(certBag, ((CertBag)aSN1Object2).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                    ((ASN1EncodableVector)object7).add((ASN1Encodable)object);
                    ((Hashtable)object5).put(object3, object3);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
                }
            }
            enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    object4 = (String)enumeration.nextElement();
                    object3 = (Certificate)this.certs.get((String)object4);
                    boolean bl3 = false;
                    if (this.keys.get((String)object4) != null) continue;
                    aSN1Object2 = new CertBag(x509Certificate, new DEROctetString(((Certificate)object3).getEncoded()));
                    contentInfoArray = new ASN1EncodableVector();
                    object2 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object2).add(pkcs_9_at_friendlyName);
                    ((ASN1EncodableVector)object2).add(new DERSet(new DERBMPString((String)object4)));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                    object = new SafeBag(certBag, ((CertBag)aSN1Object2).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                    ((ASN1EncodableVector)object7).add((ASN1Encodable)object);
                    ((Hashtable)object5).put(object3, object3);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
                }
            }
            object4 = this.getUsedCertificateSet();
            enumeration = this.chainCerts.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    object3 = (CertId)enumeration.nextElement();
                    Certificate certificate = (Certificate)this.chainCerts.get(object3);
                    if (!object4.contains(certificate) || ((Hashtable)object5).get(certificate) != null) continue;
                    aSN1Object2 = new CertBag(x509Certificate, new DEROctetString(certificate.getEncoded()));
                    contentInfoArray = new ASN1EncodableVector();
                    object2 = new SafeBag(certBag, ((CertBag)aSN1Object2).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                    ((ASN1EncodableVector)object7).add((ASN1Encodable)object2);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
                }
            }
            object3 = new DERSequence((ASN1EncodableVector)object7).getEncoded("DER");
            byte[] byArray2 = this.cryptData(true, (AlgorithmIdentifier)object6, password, (byte[])object3);
            aSN1Object2 = new EncryptedData(data, (AlgorithmIdentifier)object6, new BEROctetString(byArray2));
            contentInfoArray = new ContentInfo[]{new ContentInfo(data, (ASN1Encodable)object9), new ContentInfo(encryptedData, ((EncryptedData)aSN1Object2).toASN1Primitive())};
            object2 = new AuthenticatedSafe(contentInfoArray);
            object = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = useDEREncoding ? new DEROutputStream((OutputStream)object) : new BEROutputStream((OutputStream)object);
            dEROutputStream.writeObject((ASN1Encodable)object2);
            byte[] byArray3 = ((ByteArrayOutputStream)object).toByteArray();
            ContentInfo contentInfo = new ContentInfo(data, new BEROctetString(byArray3));
            byte[] byArray4 = new byte[20];
            int n2 = 1024;
            this.random.nextBytes(byArray4);
            byte[] byArray5 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                aSN1Object = new AlgorithmIdentifier(id_SHA1, DERNull.INSTANCE);
                byte[] byArray6 = this.calculatePbeMac((AlgorithmIdentifier)aSN1Object, byArray4, n2, password, byArray5);
                DigestInfo digestInfo = new DigestInfo((AlgorithmIdentifier)aSN1Object, byArray6);
                macData = new MacData(digestInfo, byArray4, n2);
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
            aSN1Object = new Pfx(contentInfo, macData);
            dEROutputStream = useDEREncoding ? new DEROutputStream(stream) : new BEROutputStream(stream);
            dEROutputStream.writeObject(aSN1Object);
        }

        private byte[] calculatePbeMacWrongZero(AlgorithmIdentifier algID, byte[] salt, int itCount, byte[] data) throws Exception {
            byte[] byArray = this.getDerivedMacKey(algID, new byte[2], salt, itCount);
            String string = algID.getAlgorithm().getId();
            Mac mac = Mac.getInstance(string, this.fipsProvider);
            mac.init(new SecretKeySpec(byArray, string));
            mac.update(data);
            return mac.doFinal();
        }

        private byte[] calculatePbeMac(AlgorithmIdentifier algID, byte[] salt, int itCount, char[] password, byte[] data) throws Exception {
            byte[] byArray = this.getDerivedMacKey(algID, PasswordConverter.PKCS12.convert(password), salt, itCount);
            String string = algID.getAlgorithm().getId();
            Mac mac = Mac.getInstance(string, this.fipsProvider);
            mac.init(new SecretKeySpec(byArray, string));
            mac.update(data);
            return mac.doFinal();
        }

        private byte[] getDerivedMacKey(AlgorithmIdentifier algID, byte[] password, byte[] salt, int itCount) {
            int n2;
            PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver;
            if (algID.getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3411)) {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(SecureHash.Algorithm.GOST3411, password).withSalt(salt).withIterationCount(itCount));
                n2 = 32;
            } else if (algID.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA224, password).withSalt(salt).withIterationCount(itCount));
                n2 = 28;
            } else if (algID.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA256, password).withSalt(salt).withIterationCount(itCount));
                n2 = 32;
            } else {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA1, password).withSalt(salt).withIterationCount(itCount));
                n2 = 20;
            }
            return passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.MAC, n2);
        }

        private Set getUsedCertificateSet() {
            Object object;
            String string;
            HashSet<Object> hashSet = new HashSet<Object>();
            Enumeration enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = this.engineGetCertificateChain(string);
                for (int i2 = 0; i2 != ((Certificate[])object).length; ++i2) {
                    hashSet.add(object[i2]);
                }
            }
            enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = this.engineGetCertificate(string);
                hashSet.add(object);
            }
            return hashSet;
        }

        private static class IgnoresCaseHashtable {
            private Hashtable orig = new Hashtable();
            private Hashtable keys = new Hashtable();

            private IgnoresCaseHashtable() {
            }

            public void put(String key, Object value) {
                String string = Strings.toLowerCase(key);
                String string2 = (String)this.keys.get(string);
                if (string2 != null) {
                    this.orig.remove(string2);
                }
                this.keys.put(string, key);
                this.orig.put(key, value);
            }

            public Enumeration keys() {
                return this.orig.keys();
            }

            public Object remove(String alias) {
                if (alias == null) {
                    return null;
                }
                String string = (String)this.keys.remove(Strings.toLowerCase(alias));
                if (string == null) {
                    return null;
                }
                return this.orig.remove(string);
            }

            public Object get(String alias) {
                if (alias == null) {
                    return null;
                }
                String string = (String)this.keys.get(Strings.toLowerCase(alias));
                if (string == null) {
                    return null;
                }
                return this.orig.get(string);
            }

            public Enumeration elements() {
                return this.orig.elements();
            }

            public void clear() {
                this.orig.clear();
            }
        }

        private class CertId {
            byte[] id;

            CertId(PublicKey key) throws IOException {
                this.id = PKCS12KeyStoreSpi.this.createSubjectKeyId(key).getKeyIdentifier();
            }

            CertId(byte[] id2) {
                this.id = id2;
            }

            public int hashCode() {
                return Arrays.hashCode(this.id);
            }

            public boolean equals(Object o2) {
                if (o2 == this) {
                    return true;
                }
                if (!(o2 instanceof CertId)) {
                    return false;
                }
                CertId certId = (CertId)o2;
                return Arrays.areEqual(this.id, certId.id);
            }
        }
    }
}

